/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.excel;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.teiid.file.VirtualFileConnection;
import org.teiid.language.LanguageObject;
import org.teiid.language.Select;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.excel.BaseExcelExecution;

public class ExcelExecution
extends BaseExcelExecution
implements ResultSetExecution {
    private Class<?>[] expectedColumnTypes;

    public ExcelExecution(Select query, ExecutionContext executionContext, RuntimeMetadata metadata, VirtualFileConnection connection) throws TranslatorException {
        super(executionContext, metadata, connection);
        this.expectedColumnTypes = query.getColumnTypes();
        this.visit((LanguageObject)query);
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        Row row = this.nextRow();
        if (row == null) {
            return null;
        }
        return this.projectRow(row);
    }

    List<Object> projectRow(Row row) throws TranslatorException {
        ArrayList<Object> output = new ArrayList<Object>(this.visitor.getProjectedColumns().size());
        int id = row.getRowNum() + 1;
        int i = -1;
        block5: for (int index : this.visitor.getProjectedColumns()) {
            ++i;
            if (index == -1) {
                output.add(id);
                continue;
            }
            Cell cell = row.getCell(index - 1, Row.RETURN_BLANK_AS_NULL);
            if (cell == null) {
                output.add(null);
                continue;
            }
            switch (this.evaluator.evaluateInCell(cell).getCellType()) {
                case 0: {
                    output.add(this.convertFromExcelType(cell.getNumericCellValue(), cell, this.expectedColumnTypes[i]));
                    continue block5;
                }
                case 1: {
                    output.add(ExcelExecution.convertFromExcelType(cell.getStringCellValue(), this.expectedColumnTypes[i]));
                    continue block5;
                }
                case 4: {
                    output.add(this.convertFromExcelType(cell.getBooleanCellValue(), this.expectedColumnTypes[i]));
                    continue block5;
                }
            }
            output.add(null);
        }
        return output;
    }
}

