/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.couchbase;

import com.couchbase.client.java.query.N1qlQueryRow;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.couchbase.CouchbaseConnection;
import org.teiid.language.Argument;
import org.teiid.language.Command;
import org.teiid.logging.LogManager;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.couchbase.CouchbaseExecution;
import org.teiid.translator.couchbase.CouchbaseExecutionFactory;
import org.teiid.translator.couchbase.CouchbasePlugin;

public class CouchbaseDirectQueryExecution
extends CouchbaseExecution
implements ProcedureExecution {
    private List<Argument> arguments;
    private Iterator<N1qlQueryRow> results;

    public CouchbaseDirectQueryExecution(List<Argument> arguments, Command command, CouchbaseExecutionFactory executionFactory, ExecutionContext executionContext, RuntimeMetadata metadata, CouchbaseConnection connection) {
        super(executionFactory, executionContext, metadata, connection);
        this.arguments = arguments;
    }

    public void execute() throws TranslatorException {
        String n1ql = (String)this.arguments.get(0).getArgumentValue().getValue();
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)CouchbasePlugin.Util.gs((BundleUtil.Event)CouchbasePlugin.Event.TEIID29001, new Object[]{n1ql}));
        this.executionContext.logCommand(new Object[]{n1ql});
        this.results = this.connection.execute(n1ql).iterator();
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        ArrayList<Object[]> returns = new ArrayList<Object[]>(1);
        ArrayList<BlobType> result = new ArrayList<BlobType>(1);
        if (this.results != null && this.results.hasNext()) {
            final N1qlQueryRow row = this.results.next();
            InputStreamFactory isf = new InputStreamFactory(){

                public InputStream getInputStream() throws IOException {
                    return new ByteArrayInputStream(row.byteValue());
                }
            };
            result.add(new BlobType((Blob)new BlobImpl(isf)));
            returns.add(result.toArray());
            return returns;
        }
        return null;
    }

    public void close() {
        this.results = null;
    }

    public void cancel() throws TranslatorException {
        this.close();
    }

    public List<?> getOutputParameterValues() throws TranslatorException {
        return null;
    }
}

