/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.couchbase;

import com.couchbase.client.java.query.N1qlQueryResult;
import com.couchbase.client.java.query.N1qlQueryRow;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.couchbase.CouchbaseConnection;
import org.teiid.language.Call;
import org.teiid.language.LanguageObject;
import org.teiid.logging.LogManager;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.couchbase.CouchbaseExecution;
import org.teiid.translator.couchbase.CouchbaseExecutionFactory;
import org.teiid.translator.couchbase.CouchbasePlugin;
import org.teiid.translator.couchbase.N1QLVisitor;

public class CouchbaseProcedureExecution
extends CouchbaseExecution
implements ProcedureExecution {
    private final Call call;
    private N1QLVisitor visitor;
    private Iterator<N1qlQueryRow> results;

    protected CouchbaseProcedureExecution(CouchbaseExecutionFactory executionFactory, Call call, ExecutionContext executionContext, RuntimeMetadata metadata, CouchbaseConnection connection) {
        super(executionFactory, executionContext, metadata, connection);
        this.call = call;
    }

    public void execute() throws TranslatorException {
        this.visitor = this.executionFactory.getN1QLVisitor();
        this.visitor.append((LanguageObject)this.call);
        String n1ql = this.visitor.toString();
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)CouchbasePlugin.Util.gs((BundleUtil.Event)CouchbasePlugin.Event.TEIID29002, new Object[]{this.call, n1ql}));
        this.executionContext.logCommand(new Object[]{n1ql});
        N1qlQueryResult queryResult = this.connection.execute(n1ql);
        this.results = queryResult.iterator();
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        if (this.results != null && this.results.hasNext()) {
            final N1qlQueryRow row = this.results.next();
            String procName = this.call.getProcedureName();
            if (procName.equalsIgnoreCase("getDocuments") || procName.equalsIgnoreCase("getDocument")) {
                ArrayList<BlobType> result = new ArrayList<BlobType>(1);
                InputStreamFactory isf = new InputStreamFactory(){

                    public InputStream getInputStream() throws IOException {
                        return new ByteArrayInputStream(row.byteValue());
                    }
                };
                BlobType value = new BlobType((Blob)new BlobImpl(isf));
                result.add(value);
                return result;
            }
        }
        return null;
    }

    public List<?> getOutputParameterValues() throws TranslatorException {
        return Collections.emptyList();
    }

    public void cancel() throws TranslatorException {
        this.close();
    }

    public void close() {
        this.results = null;
    }
}

