/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.couchbase;

import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.query.N1qlQueryResult;
import com.couchbase.client.java.query.N1qlQueryRow;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.teiid.core.BundleUtil;
import org.teiid.couchbase.CouchbaseConnection;
import org.teiid.language.LanguageObject;
import org.teiid.language.QueryExpression;
import org.teiid.logging.LogManager;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.couchbase.CouchbaseExecution;
import org.teiid.translator.couchbase.CouchbaseExecutionFactory;
import org.teiid.translator.couchbase.CouchbasePlugin;
import org.teiid.translator.couchbase.N1QLVisitor;

public class CouchbaseQueryExecution
extends CouchbaseExecution
implements ResultSetExecution {
    private QueryExpression command;
    private Class<?>[] expectedTypes;
    private N1QLVisitor visitor;
    private Iterator<N1qlQueryRow> results;

    public CouchbaseQueryExecution(CouchbaseExecutionFactory executionFactory, QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, CouchbaseConnection connection) {
        super(executionFactory, executionContext, metadata, connection);
        this.command = command;
        this.expectedTypes = command.getColumnTypes();
    }

    public void execute() throws TranslatorException {
        this.visitor = this.executionFactory.getN1QLVisitor();
        this.visitor.append((LanguageObject)this.command);
        String n1ql = this.visitor.toString();
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)CouchbasePlugin.Util.gs((BundleUtil.Event)CouchbasePlugin.Event.TEIID29001, new Object[]{n1ql}));
        this.executionContext.logCommand(new Object[]{n1ql});
        N1qlQueryResult queryResult = this.connection.execute(n1ql);
        this.results = queryResult.iterator();
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        if (this.results == null || !this.results.hasNext()) {
            return null;
        }
        N1qlQueryRow queryRow = this.results.next();
        if (queryRow == null) {
            return null;
        }
        ArrayList<Object> row = new ArrayList<Object>(this.expectedTypes.length);
        JsonObject json = queryRow.value();
        for (int i = 0; i < this.expectedTypes.length; ++i) {
            String columnName = this.visitor.getSelectColumns().get(i);
            Object value = null;
            Class<?> type = this.expectedTypes[i];
            value = type == TypeFacility.RUNTIME_TYPES.STRING ? json.getString(columnName) : (type == TypeFacility.RUNTIME_TYPES.INTEGER ? json.getInt(columnName) : (type == TypeFacility.RUNTIME_TYPES.LONG ? json.getLong(columnName) : (type == TypeFacility.RUNTIME_TYPES.DOUBLE ? json.getDouble(columnName) : (type == TypeFacility.RUNTIME_TYPES.BOOLEAN ? json.getBoolean(columnName) : (type == TypeFacility.RUNTIME_TYPES.BIG_INTEGER ? json.getNumber(columnName) : (type == TypeFacility.RUNTIME_TYPES.BIG_DECIMAL ? json.getNumber(columnName) : json.get(columnName)))))));
            row.add(this.executionFactory.retrieveValue(type, value));
        }
        return row;
    }

    public void close() {
        this.results = null;
    }

    public void cancel() throws TranslatorException {
    }
}

