/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.couchbase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.Literal;
import org.teiid.language.SearchedCase;
import org.teiid.language.SearchedWhenClause;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.AliasModifier;

public class SubstringFunctionModifier
extends AliasModifier {
    public SubstringFunctionModifier() {
        super("substr");
    }

    public List<?> translate(Function function) {
        this.modify(function);
        Expression from = (Expression)function.getParameters().get(1);
        Boolean isFromNegative = this.isNegative(from);
        Function length = new Function("length", Arrays.asList((Expression)function.getParameters().get(0)), TypeFacility.RUNTIME_TYPES.INTEGER);
        if (function.getParameters().size() == 2 && (isFromNegative == null || isFromNegative.booleanValue())) {
            function.getParameters().add(length);
        }
        if (function.getParameters().size() == 3) {
            Expression forLength = (Expression)function.getParameters().get(2);
            ArrayList<SearchedWhenClause> clauses = new ArrayList<SearchedWhenClause>(2);
            Boolean isNegative = this.isNegative(forLength);
            Expression adjustedFrom = from;
            if (isFromNegative == null || isFromNegative.booleanValue()) {
                adjustedFrom = new SearchedCase(Arrays.asList(new SearchedWhenClause((Condition)new Comparison(from, (Expression)new Literal((Object)0, TypeFacility.RUNTIME_TYPES.INTEGER), Comparison.Operator.LT), (Expression)new Function("+", Arrays.asList(new Function("+", Arrays.asList(length, new Literal((Object)1, TypeFacility.RUNTIME_TYPES.INTEGER)), TypeFacility.RUNTIME_TYPES.INTEGER), from), TypeFacility.RUNTIME_TYPES.INTEGER))), from, TypeFacility.RUNTIME_TYPES.INTEGER);
            }
            Function maxLength = new Function("-", Arrays.asList(length, new Function("-", Arrays.asList(adjustedFrom, new Literal((Object)1, TypeFacility.RUNTIME_TYPES.INTEGER)), TypeFacility.RUNTIME_TYPES.INTEGER)), TypeFacility.RUNTIME_TYPES.INTEGER);
            clauses.add(new SearchedWhenClause((Condition)new Comparison(forLength, (Expression)maxLength, Comparison.Operator.GT), (Expression)maxLength));
            Expression defaultExpr = null;
            if (isNegative == null) {
                clauses.add(new SearchedWhenClause((Condition)new Comparison(forLength, (Expression)new Literal((Object)0, TypeFacility.RUNTIME_TYPES.INTEGER), Comparison.Operator.GT), forLength));
            } else {
                if (isNegative.booleanValue()) {
                    return Arrays.asList(new Literal(null, TypeFacility.RUNTIME_TYPES.STRING));
                }
                defaultExpr = forLength;
            }
            SearchedCase sc = new SearchedCase(clauses, defaultExpr, TypeFacility.RUNTIME_TYPES.INTEGER);
            function.getParameters().set(2, sc);
        }
        Expression adjustedFrom = (Expression)function.getParameters().get(1);
        if (isFromNegative == null) {
            SearchedCase sc = new SearchedCase(Arrays.asList(new SearchedWhenClause((Condition)new Comparison(adjustedFrom, (Expression)new Literal((Object)0, TypeFacility.RUNTIME_TYPES.INTEGER), Comparison.Operator.GT), (Expression)new Function("-", Arrays.asList(adjustedFrom, new Literal((Object)1, TypeFacility.RUNTIME_TYPES.INTEGER)), TypeFacility.RUNTIME_TYPES.INTEGER))), from, TypeFacility.RUNTIME_TYPES.INTEGER);
            function.getParameters().set(1, sc);
        } else if (!isFromNegative.booleanValue()) {
            function.getParameters().set(1, new Function("-", Arrays.asList(adjustedFrom, new Literal((Object)1, TypeFacility.RUNTIME_TYPES.INTEGER)), TypeFacility.RUNTIME_TYPES.INTEGER));
        }
        return null;
    }

    private Boolean isNegative(Expression ex) {
        Boolean isNegative = null;
        if (ex instanceof Literal) {
            Literal l = (Literal)ex;
            int value = (Integer)l.getValue();
            isNegative = value < 0;
        }
        return isNegative;
    }
}

