/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.service;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.core.edm.primitivetype.AbstractGeospatialType;
import org.apache.olingo.commons.core.edm.primitivetype.EdmBinary;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDate;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDateTimeOffset;
import org.apache.olingo.commons.core.edm.primitivetype.EdmStream;
import org.apache.olingo.commons.core.edm.primitivetype.EdmTimeOfDay;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;
import org.apache.olingo.server.core.responses.EntityResponse;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.Transform;
import org.teiid.core.types.TransformationException;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.logging.LogManager;
import org.teiid.odata.api.QueryResponse;
import org.teiid.olingo.ODataPlugin;
import org.teiid.olingo.ProjectedColumn;
import org.teiid.olingo.common.ODataTypeManager;
import org.teiid.olingo.service.DocumentNode;
import org.teiid.olingo.service.ExpandDocumentNode;
import org.teiid.olingo.service.TeiidNotImplementedException;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Symbol;

public class EntityCollectionResponse
extends EntityCollection
implements QueryResponse {
    private String nextToken;
    private DocumentNode documentNode;
    private String baseURL;
    private Map<String, Object> streams;
    private int skipped = 0;
    private int topCount = 0;
    private int collectionCount = 0;

    private EntityCollectionResponse() {
    }

    public EntityCollectionResponse(String baseURL, DocumentNode resource) {
        this.baseURL = baseURL;
        this.documentNode = resource;
    }

    @Override
    public void addRow(ResultSet rs) throws SQLException {
        Entity entity = EntityCollectionResponse.createEntity(rs, this.documentNode, this.baseURL, this);
        this.processExpands(EntityCollectionResponse.asRow(rs), entity, this.documentNode);
        this.getEntities().add(entity);
    }

    private void processExpands(Row vals, Entity entity, DocumentNode node) throws SQLException {
        if (node.getExpands() == null || node.getExpands().isEmpty()) {
            return;
        }
        for (ExpandDocumentNode expandNode : node.getExpands()) {
            Object[] expandedVals = vals.getArray(expandNode.getColumnIndex());
            if (expandedVals == null) continue;
            for (Object o : expandedVals) {
                Object[] expandedVal = (Object[])o;
                Entity expandEntity = EntityCollectionResponse.createEntity(expandedVal, (DocumentNode)expandNode, this.baseURL, this);
                Link link = entity.getNavigationLink(expandNode.getNavigationName());
                if (expandNode.isCollection()) {
                    EntityCollectionResponse expandResponse;
                    boolean addEntity;
                    if (link.getInlineEntitySet() == null) {
                        link.setInlineEntitySet((EntityCollection)new EntityCollectionResponse());
                    }
                    if (addEntity = (expandResponse = (EntityCollectionResponse)link.getInlineEntitySet()).processOptions(expandNode.getSkip(), expandNode.getTop(), expandEntity)) {
                        link.getInlineEntitySet().getEntities().add(expandEntity);
                    }
                } else {
                    link.setInlineEntity(expandEntity);
                }
                this.processExpands(EntityCollectionResponse.asRow(expandedVal), expandEntity, expandNode);
            }
        }
    }

    static Entity createEntity(Object[] vals, DocumentNode node, String baseURL, EntityCollectionResponse response) throws SQLException {
        return EntityCollectionResponse.createEntity(EntityCollectionResponse.asRow(vals), node, baseURL, response);
    }

    static Entity createEntity(ResultSet vals, DocumentNode node, String baseURL, EntityCollectionResponse response) throws SQLException {
        return EntityCollectionResponse.createEntity(EntityCollectionResponse.asRow(vals), node, baseURL, response);
    }

    static Entity createEntity(Row row, DocumentNode node, String baseURL, EntityCollectionResponse response) throws SQLException {
        List<ProjectedColumn> projected = node.getAllProjectedColumns();
        EdmEntityType entityType = node.getEdmEntityType();
        LinkedHashMap<String, Link> streamProperties = new LinkedHashMap<String, Link>();
        Entity entity = new Entity();
        entity.setType(entityType.getFullQualifiedName().getFullQualifiedNameAsString());
        boolean allNulls = true;
        for (ProjectedColumn column : projected) {
            String propertyName = Symbol.getShortName((Expression)column.getExpression());
            Object value = row.getObject(column.getOrdinal());
            if (value != null) {
                allNulls = false;
            }
            try {
                SingletonPrimitiveType type = (SingletonPrimitiveType)column.getEdmType();
                if (type instanceof EdmStream) {
                    EntityCollectionResponse.buildStreamLink(streamProperties, value, propertyName);
                    if (response == null) continue;
                    response.setStream(propertyName, value);
                    continue;
                }
                Property property = EntityCollectionResponse.buildPropery(propertyName, type, column.getPrecision(), column.getScale(), column.isCollection(), value);
                entity.addProperty(property);
            }
            catch (IOException | TeiidProcessingException e) {
                throw new SQLException(e);
            }
        }
        if (allNulls) {
            return null;
        }
        try {
            String id = EntityResponse.buildLocation((String)baseURL, (Entity)entity, (String)entityType.getName(), (EdmEntityType)entityType);
            entity.setId(new URI(id));
            for (String name : streamProperties.keySet()) {
                Link link = streamProperties.get(name);
                link.setHref(id + "/" + name);
                entity.getMediaEditLinks().add(link);
                entity.addProperty(EntityCollectionResponse.createPrimitive(name, (EdmPrimitiveType)EdmStream.getInstance(), new URI(link.getHref())));
            }
            for (String name : entityType.getNavigationPropertyNames()) {
                Link navLink = new Link();
                navLink.setTitle(name);
                navLink.setHref(id + "/" + name);
                navLink.setRel("http://docs.oasis-open.org/odata/ns/related/" + name);
                entity.getNavigationLinks().add(navLink);
                Link assosiationLink = new Link();
                assosiationLink.setTitle(name);
                assosiationLink.setHref(id + "/" + name + "/$ref");
                assosiationLink.setRel("http://docs.oasis-open.org/odata/ns/relatedlinks/" + name);
                entity.getAssociationLinks().add(assosiationLink);
            }
        }
        catch (URISyntaxException e) {
            throw new SQLException(e);
        }
        catch (EdmPrimitiveTypeException e) {
            throw new SQLException(e);
        }
        return entity;
    }

    private static Row asRow(final ResultSet vals) {
        return new Row(){

            @Override
            public Object getObject(int column) throws SQLException {
                return vals.getObject(column);
            }

            @Override
            public Object[] getArray(int columnIndex) throws SQLException {
                java.sql.Array array = vals.getArray(columnIndex);
                if (array == null) {
                    return null;
                }
                return (Object[])array.getArray();
            }
        };
    }

    private static Row asRow(final Object[] vals) {
        return new Row(){

            @Override
            public Object getObject(int column) throws SQLException {
                return vals[column - 1];
            }

            @Override
            public Object[] getArray(int columnIndex) {
                return (Object[])vals[columnIndex - 1];
            }
        };
    }

    void setStream(String propertyName, Object value) {
        if (this.streams == null) {
            this.streams = new HashMap<String, Object>();
        }
        this.streams.put(propertyName, value);
    }

    public Object getStream(String propertyName) {
        if (this.streams == null) {
            return null;
        }
        return this.streams.get(propertyName);
    }

    private static void buildStreamLink(LinkedHashMap<String, Link> streamProperties, Object value, String propName) {
        if (value != null) {
            Link streamLink = new Link();
            streamLink.setTitle(propName);
            if (value instanceof SQLXML) {
                streamLink.setType("application/xml");
            } else if (value instanceof Clob) {
                streamLink.setType("application/json");
            } else if (value instanceof Blob) {
                streamLink.setType("application/octet-stream");
            }
            streamLink.setRel("http://docs.oasis-open.org/odata/ns/mediaresource/" + propName);
            streamProperties.put(propName, streamLink);
        }
    }

    static Property buildPropery(String propName, SingletonPrimitiveType type, Integer precision, Integer scale, boolean isArray, Object value) throws TeiidProcessingException, SQLException, IOException {
        if (value instanceof java.sql.Array) {
            value = ((java.sql.Array)value).getArray();
            int length = Array.getLength(value);
            ArrayList<Object> values = new ArrayList<Object>();
            for (int i = 0; i < length; ++i) {
                Object o = Array.get(value, i);
                if (o != null && o.getClass().isArray()) {
                    throw new TeiidNotImplementedException((BundleUtil.Event)ODataPlugin.Event.TEIID16029, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16029, new Object[]{propName}));
                }
                Object p = EntityCollectionResponse.getPropertyValue(type, precision, scale, isArray, o);
                values.add(p);
            }
            return EntityCollectionResponse.createCollection(propName, (EdmPrimitiveType)type, values);
        }
        if (isArray) {
            ArrayList<Object> values = new ArrayList<Object>();
            values.add(EntityCollectionResponse.getPropertyValue(type, precision, scale, isArray, value));
            return EntityCollectionResponse.createCollection(propName, (EdmPrimitiveType)type, values);
        }
        return EntityCollectionResponse.createPrimitive(propName, (EdmPrimitiveType)type, EntityCollectionResponse.getPropertyValue(type, precision, scale, isArray, value));
    }

    private static Property createPrimitive(String name, EdmPrimitiveType type, Object value) {
        return new Property(type.getFullQualifiedName().getFullQualifiedNameAsString(), name, type instanceof AbstractGeospatialType ? ValueType.GEOSPATIAL : ValueType.PRIMITIVE, value);
    }

    private static Property createCollection(String name, EdmPrimitiveType type, ArrayList<Object> values) {
        return new Property(type.getFullQualifiedName().getFullQualifiedNameAsString(), name, type instanceof AbstractGeospatialType ? ValueType.COLLECTION_GEOSPATIAL : ValueType.COLLECTION_PRIMITIVE, values);
    }

    static Object getPropertyValue(SingletonPrimitiveType expectedType, Integer precision, Integer scale, boolean isArray, Object value) throws TransformationException, SQLException, IOException, FunctionExecutionException {
        if (value == null) {
            return null;
        }
        value = EntityCollectionResponse.getPropertyValueInternal(expectedType, isArray, value);
        value = ODataTypeManager.rationalizePrecision((Integer)precision, (Integer)scale, (Object)value);
        return value;
    }

    private static Object getPropertyValueInternal(SingletonPrimitiveType expectedType, boolean isArray, Object value) throws TransformationException, SQLException, IOException, FunctionExecutionException {
        Class targetType;
        Class sourceType = DataTypeManager.getRuntimeType(value.getClass());
        if (sourceType.isAssignableFrom(expectedType.getDefaultType())) {
            return value;
        }
        if (expectedType instanceof EdmDate && sourceType == Date.class) {
            return value;
        }
        if (expectedType instanceof EdmDateTimeOffset && sourceType == Timestamp.class) {
            return value;
        }
        if (expectedType instanceof EdmTimeOfDay && sourceType == Time.class) {
            return value;
        }
        if (expectedType instanceof EdmBinary) {
            LogManager.logDetail((String)"org.teiid.ODATA", (Object)"Possible OOM when inlining the stream based values");
            if (sourceType == ClobType.class) {
                return ClobType.getString((Clob)((Clob)value)).getBytes();
            }
            if (sourceType == SQLXML.class) {
                return ((SQLXML)value).getString().getBytes();
            }
            if (sourceType == BlobType.class) {
                return ObjectConverterUtil.convertToByteArray((InputStream)((Blob)value).getBinaryStream());
            }
            if (value instanceof Serializable) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(value);
                oos.close();
                bos.close();
                return bos.toByteArray();
            }
        } else if (expectedType instanceof AbstractGeospatialType && sourceType == DataTypeManager.DefaultDataClasses.BLOB) {
            return ODataTypeManager.convertToODataValue((InputStream)((Blob)value).getBinaryStream(), (boolean)false);
        }
        if (sourceType != (targetType = DataTypeManager.getDataTypeClass((String)ODataTypeManager.teiidType((SingletonPrimitiveType)expectedType, (boolean)isArray)))) {
            Transform t = DataTypeManager.getTransform((Class)sourceType, (Class)targetType);
            value = t != null ? t.transform(value, targetType) : value;
        }
        return value;
    }

    @Override
    public long size() {
        return this.getEntities().size();
    }

    @Override
    public void setCount(long count) {
        this.collectionCount = (int)count;
    }

    @Override
    public void setNextToken(String token) {
        this.nextToken = token;
    }

    @Override
    public String getNextToken() {
        return this.nextToken;
    }

    private boolean processOptions(int skip, int top, Entity expandEntity) {
        ++this.collectionCount;
        if (skip > 0 && this.skipped < skip) {
            ++this.skipped;
            return false;
        }
        if (top > -1) {
            if (this.topCount < top) {
                ++this.topCount;
                return true;
            }
            return false;
        }
        return true;
    }

    public Integer getCount() {
        return this.collectionCount;
    }

    static interface Row {
        public Object getObject(int var1) throws SQLException;

        public Object[] getArray(int var1) throws SQLException;
    }
}

