/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriResourceCount;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceIt;
import org.apache.olingo.server.api.uri.UriResourceLambdaAll;
import org.apache.olingo.server.api.uri.UriResourceLambdaAny;
import org.apache.olingo.server.api.uri.UriResourceLambdaVariable;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePrimitiveProperty;
import org.apache.olingo.server.api.uri.UriResourceRoot;
import org.apache.olingo.server.api.uri.queryoption.expression.Alias;
import org.apache.olingo.server.api.uri.queryoption.expression.Binary;
import org.apache.olingo.server.api.uri.queryoption.expression.Enumeration;
import org.apache.olingo.server.api.uri.queryoption.expression.LambdaRef;
import org.apache.olingo.server.api.uri.queryoption.expression.Literal;
import org.apache.olingo.server.api.uri.queryoption.expression.Member;
import org.apache.olingo.server.api.uri.queryoption.expression.Method;
import org.apache.olingo.server.api.uri.queryoption.expression.TypeLiteral;
import org.apache.olingo.server.api.uri.queryoption.expression.Unary;
import org.apache.olingo.server.core.RequestURLHierarchyVisitor;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.JDBCSQLTypeInfo;
import org.teiid.core.util.Assertion;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.MetadataStore;
import org.teiid.odata.api.SQLParameter;
import org.teiid.olingo.ODataExpressionVisitor;
import org.teiid.olingo.ODataPlugin;
import org.teiid.olingo.ProjectedColumn;
import org.teiid.olingo.common.ODataTypeManager;
import org.teiid.olingo.service.DocumentNode;
import org.teiid.olingo.service.ExpandDocumentNode;
import org.teiid.olingo.service.ODataSQLBuilder;
import org.teiid.olingo.service.TeiidNotImplementedException;
import org.teiid.olingo.service.TeiidServiceHandler;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.ExpressionCriteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.symbol.Symbol;

public class ODataExpressionToSQLVisitor
extends RequestURLHierarchyVisitor
implements ODataExpressionVisitor {
    private final Stack<Expression> stack = new Stack();
    private List<SQLParameter> params;
    private boolean prepared = false;
    private final UriInfo uriInfo;
    private MetadataStore metadata;
    private DocumentNode ctxQuery;
    private DocumentNode ctxExpression;
    private DocumentNode ctxLambda;
    private TeiidServiceHandler.UniqueNameGenerator nameGenerator;
    private ODataSQLBuilder.URLParseService parseService;
    private Column lastProperty;
    private OData odata;
    private boolean root;

    public ODataExpressionToSQLVisitor(DocumentNode resource, boolean prepared, UriInfo info, MetadataStore metadata, OData odata, TeiidServiceHandler.UniqueNameGenerator nameGenerator, List<SQLParameter> params, ODataSQLBuilder.URLParseService parseService) {
        this.ctxQuery = resource;
        this.prepared = prepared;
        this.uriInfo = info;
        this.metadata = metadata;
        this.nameGenerator = nameGenerator;
        this.params = params;
        this.parseService = parseService;
        this.ctxExpression = this.ctxQuery;
        this.odata = odata;
    }

    public Expression getExpression(org.apache.olingo.server.api.uri.queryoption.expression.Expression expr) throws TeiidException {
        try {
            this.accept(expr);
        }
        catch (TeiidRuntimeException e) {
            if (e.getCause() instanceof TeiidException) {
                throw (TeiidException)e.getCause();
            }
            throw e;
        }
        return this.stack.pop();
    }

    public Expression getExpression(UriInfoResource info) throws TeiidException {
        try {
            this.visit(info);
        }
        catch (TeiidRuntimeException e) {
            if (e.getCause() instanceof TeiidException) {
                throw (TeiidException)e.getCause();
            }
            throw e;
        }
        return this.stack.pop();
    }

    public DocumentNode getEntityResource() {
        return this.ctxQuery;
    }

    @Override
    public void visit(Alias expr) {
        String strValue = this.uriInfo.getValueForAlias(expr.getParameterName());
        try {
            if (strValue == null) {
                this.stack.add((Expression)new Constant(null));
            } else if (strValue.startsWith("$root")) {
                this.stack.add((Expression)new ScalarSubquery((QueryCommand)this.parseService.parse(strValue, null)));
            } else {
                String type = "Edm.String";
                if (this.lastProperty != null) {
                    EdmPrimitiveTypeKind kind = ODataTypeManager.odataType((BaseColumn)this.lastProperty);
                    type = kind.getFullQualifiedName().getFullQualifiedNameAsString();
                    this.lastProperty = null;
                }
                Object value = ODataTypeManager.parseLiteral((String)type, (String)strValue);
                this.handleValue(value);
            }
        }
        catch (TeiidException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    @Override
    public void visit(Binary expr) {
        this.accept(expr.getLeftOperand());
        Expression lhs = this.stack.pop();
        this.accept(expr.getRightOperand());
        Expression rhs = this.stack.pop();
        CompareCriteria binaryExpr = null;
        switch (expr.getOperator()) {
            case HAS: {
                throw new TeiidRuntimeException((Throwable)((Object)new TeiidNotImplementedException((BundleUtil.Event)ODataPlugin.Event.TEIID16036, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16036, new Object[0]))));
            }
            case MUL: {
                binaryExpr = new Function("*", new Expression[]{lhs, rhs});
                break;
            }
            case DIV: {
                binaryExpr = new Function("/", new Expression[]{lhs, rhs});
                break;
            }
            case MOD: {
                binaryExpr = new Function("MOD", new Expression[]{lhs, rhs});
                break;
            }
            case ADD: {
                binaryExpr = new Function("+", new Expression[]{lhs, rhs});
                break;
            }
            case SUB: {
                binaryExpr = new Function("-", new Expression[]{lhs, rhs});
                break;
            }
            case GT: {
                binaryExpr = new CompareCriteria(lhs, 4, rhs);
                break;
            }
            case GE: {
                binaryExpr = new CompareCriteria(lhs, 6, rhs);
                break;
            }
            case LT: {
                binaryExpr = new CompareCriteria(lhs, 3, rhs);
                break;
            }
            case LE: {
                binaryExpr = new CompareCriteria(lhs, 5, rhs);
                break;
            }
            case EQ: {
                if (rhs instanceof Constant && ((Constant)rhs).getType() == DataTypeManager.DefaultDataClasses.NULL) {
                    binaryExpr = new IsNullCriteria(lhs);
                    break;
                }
                binaryExpr = new CompareCriteria(lhs, 1, rhs);
                break;
            }
            case NE: {
                if (rhs instanceof Constant && ((Constant)rhs).getType() == DataTypeManager.DefaultDataClasses.NULL) {
                    IsNullCriteria crit = new IsNullCriteria(lhs);
                    crit.setNegated(true);
                    binaryExpr = crit;
                    break;
                }
                binaryExpr = new CompareCriteria(lhs, 2, rhs);
                break;
            }
            case AND: {
                binaryExpr = new CompoundCriteria(0, (Criteria)lhs, (Criteria)rhs);
                break;
            }
            case OR: {
                binaryExpr = new CompoundCriteria(1, (Criteria)lhs, (Criteria)rhs);
            }
        }
        this.stack.push((Expression)binaryExpr);
    }

    @Override
    public void visit(Enumeration expr) {
        throw new TeiidRuntimeException((Throwable)new TeiidException("unsupported option"));
    }

    @Override
    public void visit(LambdaRef expr) {
    }

    @Override
    public void visit(Literal expr) {
        try {
            Object value = null;
            if (expr.getText() != null && !expr.getText().equalsIgnoreCase("null")) {
                String type = expr.getType().getFullQualifiedName().getFullQualifiedNameAsString();
                value = ODataTypeManager.parseLiteral((String)type, (String)expr.getText());
            }
            this.handleValue(value);
        }
        catch (TeiidException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    private void handleValue(Object value) {
        boolean isGeo = false;
        if (value instanceof Geospatial) {
            String geoLiteral = ((Geospatial)value).toString();
            value = geoLiteral.substring(geoLiteral.indexOf("'") + 1, geoLiteral.length() - 1);
            isGeo = true;
        }
        Constant ex = null;
        if (!this.prepared || value == null) {
            ex = new Constant(value);
        } else {
            ex = new Function("CONVERT", new Expression[]{new Reference(this.params.size()), new Constant((Object)DataTypeManager.getDataTypeName(value.getClass()))});
            this.params.add(new SQLParameter(value, JDBCSQLTypeInfo.getSQLTypeFromClass((String)value.getClass().getName())));
        }
        if (isGeo) {
            ex = new Function("st_geomfromewkt", new Expression[]{ex});
        }
        this.stack.add((Expression)ex);
    }

    @Override
    public void visit(Member expr) {
        this.visit(expr.getResourcePath());
    }

    private Expression addOne(Expression expr) {
        CompareCriteria when = new CompareCriteria(expr, 3, (Expression)new Constant((Object)0));
        SearchedCaseExpression caseExpr = new SearchedCaseExpression(Arrays.asList(when), Arrays.asList(expr));
        caseExpr.setElseExpression((Expression)new Function("+", new Expression[]{expr, new Constant((Object)1)}));
        return caseExpr;
    }

    private Expression minusOne(Expression expr) {
        return new Function("-", new Expression[]{expr, new Constant((Object)1)});
    }

    @Override
    public void visit(Method expr) {
        ArrayList<Expression> teiidExprs = new ArrayList<Expression>();
        for (org.apache.olingo.server.api.uri.queryoption.expression.Expression exp : expr.getParameters()) {
            this.accept(exp);
            teiidExprs.add(this.stack.pop());
        }
        switch (expr.getMethod()) {
            case CONTAINS: {
                CompareCriteria criteria = new CompareCriteria((Expression)new Function("LOCATE", new Expression[]{(Expression)teiidExprs.get(1), (Expression)teiidExprs.get(0), new Constant((Object)1)}), 6, (Expression)new Constant((Object)1));
                this.stack.push((Expression)criteria);
                break;
            }
            case STARTSWITH: {
                CompareCriteria criteria = new CompareCriteria((Expression)new Function("LOCATE", new Expression[]{(Expression)teiidExprs.get(1), (Expression)teiidExprs.get(0), new Constant((Object)1)}), 1, (Expression)new Constant((Object)1));
                this.stack.push((Expression)criteria);
                break;
            }
            case ENDSWITH: {
                CompareCriteria criteria = new CompareCriteria((Expression)new Function("ENDSWITH", new Expression[]{(Expression)teiidExprs.get(1), (Expression)teiidExprs.get(0)}), 1, (Expression)new Constant((Object)Boolean.TRUE));
                this.stack.push((Expression)criteria);
                break;
            }
            case LENGTH: {
                this.stack.push((Expression)new Function("LENGTH", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case INDEXOF: {
                this.stack.push(this.minusOne((Expression)new Function("LOCATE", new Expression[]{(Expression)teiidExprs.get(1), (Expression)teiidExprs.get(0)})));
                break;
            }
            case SUBSTRING: {
                Expression[] exprs = teiidExprs.toArray(new Expression[teiidExprs.size()]);
                exprs[1] = this.addOne(exprs[1]);
                this.stack.push((Expression)new Function("SUBSTRING", exprs));
                break;
            }
            case TOLOWER: {
                this.stack.push((Expression)new Function("LCASE", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case TOUPPER: {
                this.stack.push((Expression)new Function("UCASE", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case TRIM: {
                this.stack.push((Expression)new Function("TRIM", new Expression[]{new Constant((Object)"BOTH"), new Constant((Object)Character.valueOf(' ')), (Expression)teiidExprs.get(0)}));
                break;
            }
            case CONCAT: {
                this.stack.push((Expression)new Function("CONCAT", new Expression[]{(Expression)teiidExprs.get(0), (Expression)teiidExprs.get(1)}));
                break;
            }
            case YEAR: {
                this.stack.push((Expression)new Function("YEAR", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case MONTH: {
                this.stack.push((Expression)new Function("MONTH", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case DAY: {
                this.stack.push((Expression)new Function("DAYOFMONTH", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case HOUR: {
                this.stack.push((Expression)new Function("HOUR", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case MINUTE: {
                this.stack.push((Expression)new Function("MINUTE", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case SECOND: {
                this.stack.push((Expression)new Function("SECOND", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case NOW: {
                this.stack.push((Expression)new Function("NOW", new Expression[0]));
                break;
            }
            case ROUND: {
                this.stack.push((Expression)new Function("ROUND", new Expression[]{(Expression)teiidExprs.get(0), new Constant((Object)0)}));
                break;
            }
            case FLOOR: {
                this.stack.push((Expression)new Function("FLOOR", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case CEILING: {
                this.stack.push((Expression)new Function("CEILING", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case CAST: {
                this.stack.push((Expression)new Function("CONVERT", new Expression[]{(Expression)teiidExprs.get(0), (Expression)teiidExprs.get(1)}));
                break;
            }
            case DATE: {
                this.stack.push((Expression)new Function("CONVERT", new Expression[]{(Expression)teiidExprs.get(0), new Constant((Object)"date")}));
                break;
            }
            case TIME: {
                this.stack.push((Expression)new Function("CONVERT", new Expression[]{(Expression)teiidExprs.get(0), new Constant((Object)"time")}));
                break;
            }
            case GEODISTANCE: {
                this.stack.push((Expression)new Function("st_distance", new Expression[]{(Expression)teiidExprs.get(0), (Expression)teiidExprs.get(1)}));
                break;
            }
            case GEOLENGTH: {
                this.stack.push((Expression)new Function("st_length", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case GEOINTERSECTS: {
                this.stack.push((Expression)new Function("st_intersects", new Expression[]{(Expression)teiidExprs.get(0), (Expression)teiidExprs.get(1)}));
                break;
            }
            default: {
                throw new TeiidRuntimeException((Throwable)((Object)new TeiidNotImplementedException((BundleUtil.Event)ODataPlugin.Event.TEIID16027, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16027, new Object[]{expr.getMethod()}))));
            }
        }
    }

    @Override
    public void visit(TypeLiteral expr) {
        this.stack.push((Expression)new Constant((Object)ODataTypeManager.teiidType((SingletonPrimitiveType)((SingletonPrimitiveType)expr.getType()), (boolean)false)));
    }

    @Override
    public void visit(Unary expr) {
        this.accept(expr.getOperand());
        Expression teiidExpr = this.stack.pop();
        switch (expr.getOperator()) {
            case MINUS: {
                this.stack.push((Expression)new Function("*", new Expression[]{new Constant((Object)-1), teiidExpr}));
                break;
            }
            case NOT: {
                this.stack.push((Expression)new NotCriteria((Criteria)new ExpressionCriteria(teiidExpr)));
            }
        }
    }

    private void accept(org.apache.olingo.server.api.uri.queryoption.expression.Expression expr) {
        if (expr instanceof Alias) {
            this.visit((Alias)expr);
        } else if (expr instanceof Binary) {
            this.visit((Binary)expr);
        } else if (expr instanceof Enumeration) {
            this.visit((Enumeration)expr);
        } else if (expr instanceof LambdaRef) {
            this.visit((LambdaRef)expr);
        } else if (expr instanceof Literal) {
            this.visit((Literal)expr);
        } else if (expr instanceof Member) {
            this.visit((Member)expr);
        } else if (expr instanceof Method) {
            this.visit((Method)expr);
        } else if (expr instanceof TypeLiteral) {
            this.visit((TypeLiteral)expr);
        } else if (expr instanceof Unary) {
            this.visit((Unary)expr);
        }
    }

    public void visit(UriResourcePrimitiveProperty info) {
        Column c;
        if (this.root) {
            this.stack.add((Expression)new ScalarSubquery(this.buildRootSubQuery(info.getProperty().getName(), this.ctxExpression)));
            this.root = false;
        } else {
            this.stack.add((Expression)new ElementSymbol(info.getProperty().getName(), this.ctxExpression.getGroupSymbol()));
        }
        this.lastProperty = c = this.ctxExpression.getColumnByName(info.getProperty().getName());
        this.ctxExpression = this.ctxQuery;
    }

    public void visit(UriResourceCount option) {
    }

    public void visit(UriResourceNavigation info) {
        try {
            DocumentNode navigationResource = DocumentNode.build((EdmEntityType)info.getType(), info.getKeyPredicates(), this.metadata, this.odata, this.nameGenerator, true, this.getUriInfo(), this.parseService);
            Query query = new Query();
            query.setSelect(new Select(Arrays.asList(new AggregateSymbol(AggregateSymbol.Type.COUNT.name(), false, null))));
            query.setFrom(new From(Arrays.asList(navigationResource.getFromClause())));
            Criteria criteria = this.ctxQuery.buildJoinCriteria(navigationResource, info.getProperty());
            if (criteria == null) {
                throw new TeiidException((BundleUtil.Event)ODataPlugin.Event.TEIID16037, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16037, new Object[0]));
            }
            query.setCriteria(criteria);
            this.stack.add((Expression)new ScalarSubquery((QueryCommand)query));
        }
        catch (TeiidException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    public void visit(UriResourceLambdaAll all) {
        this.accept(all.getExpression());
        if (this.ctxLambda != null) {
            Expression predicate = this.stack.pop();
            predicate = new SubqueryCompareCriteria((Expression)new Constant((Object)true), (QueryCommand)this.buildSubquery(this.ctxLambda, predicate), 1, 4);
            this.stack.push(predicate);
        }
        this.ctxLambda = null;
    }

    public void visit(UriResourceLambdaAny any) {
        this.accept(any.getExpression());
        if (this.ctxLambda != null) {
            Expression predicate = this.stack.pop();
            Query q = this.buildSubquery(this.ctxLambda, (Expression)new Constant((Object)1));
            Object crit = null;
            crit = predicate instanceof Criteria ? (Criteria)predicate : new ExpressionCriteria(predicate);
            q.setCriteria(Criteria.combineCriteria((Criteria)q.getCriteria(), (Criteria)crit));
            predicate = new ExistsCriteria((QueryCommand)q);
            this.stack.push(predicate);
        }
        this.ctxLambda = null;
    }

    public void visit(UriResourceLambdaVariable resource) {
        try {
            if (this.ctxLambda == null) {
                DocumentNode lambda = DocumentNode.build((EdmEntityType)resource.getType(), null, this.metadata, this.odata, this.nameGenerator, false, this.uriInfo, this.parseService);
                lambda.setGroupSymbol(new GroupSymbol(resource.getVariableName(), lambda.getFullName()));
                this.ctxLambda = lambda;
            }
            this.ctxExpression = this.ctxLambda;
        }
        catch (TeiidException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    private Query buildSubquery(DocumentNode eResource, Expression projected) {
        Select s1 = new Select();
        s1.addSymbol(projected);
        Query q = new Query();
        From from = new From();
        from.addGroup(eResource.getGroupSymbol());
        q.setFrom(from);
        q.setCriteria(DocumentNode.buildJoinCriteria(eResource, this.ctxQuery));
        q.setSelect(s1);
        return q;
    }

    public void visit(UriResourceIt info) {
        if (info.getType() instanceof SingletonPrimitiveType) {
            Function ex = null;
            if (this.ctxQuery.getIterator() == null) {
                String group = this.nameGenerator.getNextGroup();
                GroupSymbol groupSymbol = new GroupSymbol(group);
                StoredProcedure procedure = new StoredProcedure();
                procedure.setProcedureName("arrayiterate");
                Collection<ProjectedColumn> values = this.ctxQuery.getProjectedColumns().values();
                Assertion.assertTrue((values.size() == 1 ? 1 : 0) != 0);
                ProjectedColumn projectedColumn = values.iterator().next();
                Expression projectedEs = projectedColumn.getExpression();
                ArrayList<SPParameter> params = new ArrayList<SPParameter>();
                SPParameter param = new SPParameter(1, 1, "val");
                param.setExpression(projectedEs);
                params.add(param);
                procedure.setParameter(param);
                SubqueryFromClause fromClause = new SubqueryFromClause(group, (Command)procedure);
                fromClause.setLateral(true);
                ElementSymbol es = new ElementSymbol("col", groupSymbol);
                String type = ODataTypeManager.teiidType((SingletonPrimitiveType)((SingletonPrimitiveType)info.getType()), (boolean)false);
                Function castFunction = new Function("CAST", new Expression[]{es, new Constant((Object)type)});
                DocumentNode itResource = new DocumentNode();
                Expression clone = (Expression)castFunction.clone();
                AggregateSymbol symbol = new AggregateSymbol(AggregateSymbol.Type.ARRAY_AGG.name(), false, clone);
                AliasSymbol expression = new AliasSymbol(Symbol.getShortName((Expression)projectedEs), (Expression)symbol);
                itResource.setFromClause((FromClause)fromClause);
                itResource.setGroupSymbol(groupSymbol);
                itResource.addProjectedColumn((Expression)expression, info.getType(), projectedColumn.getProperty(), true);
                this.ctxQuery.getProjectedColumns().remove(projectedColumn.getExpression());
                this.ctxQuery.setIterator(itResource);
                ex = castFunction;
            } else {
                GroupSymbol groupSymbol = this.ctxQuery.getIterator().getGroupSymbol();
                ElementSymbol es = new ElementSymbol("col", groupSymbol);
                String type = ODataTypeManager.teiidType((SingletonPrimitiveType)((SingletonPrimitiveType)info.getType()), (boolean)false);
                ex = new Function("CAST", new Expression[]{es, new Constant((Object)type)});
            }
            this.stack.push((Expression)ex);
        } else {
            ExpandDocumentNode node;
            DocumentNode parent;
            boolean ex = true;
            if (this.ctxQuery instanceof ExpandDocumentNode && (parent = (node = (ExpandDocumentNode)this.ctxQuery).getCollectionContext()) != null) {
                this.ctxExpression = parent;
                ex = false;
            }
            if (ex) {
                throw new TeiidRuntimeException((Throwable)((Object)new TeiidNotImplementedException((BundleUtil.Event)ODataPlugin.Event.TEIID16010, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16010, new Object[0]))));
            }
        }
    }

    public void visit(UriResourceRoot info) {
        this.root = true;
    }

    public void visit(UriResourceEntitySet info) {
        EdmEntityType edmEntityType = info.getEntitySet().getEntityType();
        if (this.root) {
            try {
                this.ctxExpression = DocumentNode.build(edmEntityType, info.getKeyPredicates(), this.metadata, this.odata, this.nameGenerator, true, this.getUriInfo(), null);
            }
            catch (TeiidException e) {
                throw new TeiidRuntimeException((Throwable)e);
            }
        } else if (this.ctxQuery.getEdmEntityType().getFullQualifiedName().equals((Object)edmEntityType.getFullQualifiedName())) {
            this.ctxExpression = this.ctxQuery;
        } else {
            for (DocumentNode er : this.ctxQuery.getSibilings()) {
                if (!er.getEdmEntityType().getFullQualifiedName().equals((Object)edmEntityType.getFullQualifiedName())) continue;
                this.ctxExpression = er;
                break;
            }
        }
    }

    public QueryCommand buildRootSubQuery(String element, DocumentNode resource) {
        Select s1 = new Select();
        s1.addSymbol((Expression)new ElementSymbol(element, resource.getGroupSymbol()));
        From f1 = new From();
        f1.addGroup(resource.getGroupSymbol());
        Query q1 = new Query();
        q1.setSelect(s1);
        q1.setFrom(f1);
        q1.setCriteria(resource.getCriteria());
        return q1;
    }
}

