/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.commons.api.data.Parameter;
import org.apache.olingo.commons.api.edm.EdmOperation;
import org.apache.olingo.commons.api.edm.EdmParameter;
import org.apache.olingo.commons.api.edm.EdmReturnType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.server.api.deserializer.DeserializerException;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.core.requests.ActionRequest;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.JDBCSQLTypeInfo;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.XMLType;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.odata.api.ProcedureReturnType;
import org.teiid.odata.api.SQLParameter;
import org.teiid.olingo.common.ODataTypeManager;
import org.teiid.olingo.service.TeiidServiceHandler;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class ProcedureSQLBuilder {
    private final List<SQLParameter> sqlParameters;
    private Procedure procedure;
    private ProcedureReturn procedureReturn;
    private TeiidServiceHandler.OperationParameterValueProvider parameterValueProvider;

    public ProcedureSQLBuilder(MetadataStore metadata, EdmOperation edmOperation, TeiidServiceHandler.OperationParameterValueProvider parameterProvider, ArrayList<SQLParameter> params) throws TeiidProcessingException {
        FullQualifiedName fqn = edmOperation.getFullQualifiedName();
        String withoutVDB = fqn.getNamespace().substring(fqn.getNamespace().lastIndexOf(46) + 1);
        Schema schema = metadata.getSchema(withoutVDB);
        this.procedure = schema.getProcedure(edmOperation.getName());
        this.parameterValueProvider = parameterProvider;
        this.sqlParameters = params;
        this.visit(edmOperation);
    }

    public ProcedureReturn getReturn() {
        return this.procedureReturn;
    }

    private void visit(EdmOperation edmOperation) throws TeiidProcessingException {
        if (edmOperation.getReturnType() != null) {
            this.visit(edmOperation.getReturnType());
        }
        for (String parameterName : edmOperation.getParameterNames()) {
            this.visit(edmOperation.getParameter(parameterName));
        }
    }

    private boolean hasResultSet() {
        return this.procedure.getResultSet() != null;
    }

    private void visit(EdmReturnType returnType) {
        if (this.hasResultSet()) {
            this.procedureReturn = new ProcedureReturn(returnType, null, true);
        } else {
            ProcedureParameter parameter = this.getReturnParameter();
            Class teiidType = DataTypeManager.getDataTypeClass((String)parameter.getRuntimeType());
            Integer sqlType = JDBCSQLTypeInfo.getSQLType((String)DataTypeManager.getDataTypeName((Class)teiidType));
            this.procedureReturn = new ProcedureReturn(returnType, sqlType, false);
        }
    }

    private ProcedureParameter getReturnParameter() {
        for (ProcedureParameter parameter : this.procedure.getParameters()) {
            if (!parameter.getType().equals((Object)ProcedureParameter.Type.ReturnValue)) continue;
            return parameter;
        }
        return null;
    }

    private void visit(EdmParameter edmParameter) throws TeiidProcessingException {
        Class<?> runtimeType = this.resolveParameterType(this.procedure.getName(), edmParameter.getName());
        Integer sqlType = JDBCSQLTypeInfo.getSQLType((String)DataTypeManager.getDataTypeName(runtimeType));
        Object value = this.parameterValueProvider.getValue(edmParameter, runtimeType);
        this.sqlParameters.add(new SQLParameter(edmParameter.getName(), value, sqlType));
    }

    public String buildProcedureSQL() {
        StringBuilder sql = new StringBuilder();
        if (this.getReturn().hasResultSet()) {
            sql.append("{");
        } else {
            sql.append("{? = ");
        }
        sql.append("call ").append(SQLStringVisitor.escapeSinglePart((String)this.procedure.getFullName()));
        sql.append("(");
        boolean first = true;
        for (SQLParameter parameter : this.sqlParameters) {
            if (!first) {
                sql.append(",");
            }
            first = false;
            sql.append(SQLStringVisitor.escapeSinglePart((String)parameter.getName())).append("=>?");
        }
        sql.append(")");
        sql.append("}");
        return sql.toString();
    }

    private Class<?> resolveParameterType(String procedureName, String parameterName) {
        for (ProcedureParameter pp : this.procedure.getParameters()) {
            if (!pp.getName().equalsIgnoreCase(parameterName)) continue;
            return DataTypeManager.getDataTypeClass((String)pp.getRuntimeType());
        }
        return null;
    }

    static class FunctionParameterValueProvider
    implements TeiidServiceHandler.OperationParameterValueProvider {
        private List<UriParameter> parameters;

        public FunctionParameterValueProvider(List<UriParameter> parameters) {
            this.parameters = parameters;
        }

        @Override
        public Object getValue(EdmParameter edmParameter, Class<?> runtimeType) throws TeiidProcessingException {
            for (UriParameter parameter : this.parameters) {
                if (!parameter.getName().equals(edmParameter.getName())) continue;
                return ODataTypeManager.parseLiteral((EdmParameter)edmParameter, runtimeType, (String)parameter.getText());
            }
            return null;
        }
    }

    static class ActionParameterValueProvider
    implements TeiidServiceHandler.OperationParameterValueProvider {
        private InputStream payload;
        private boolean alreadyConsumed;
        private ActionRequest actionRequest;
        private List<Parameter> parameters;

        public ActionParameterValueProvider(InputStream payload, ActionRequest actionRequest) {
            this.payload = payload;
            this.actionRequest = actionRequest;
        }

        @Override
        public Object getValue(EdmParameter edmParameter, Class<?> runtimeType) throws TeiidProcessingException {
            if (!this.alreadyConsumed) {
                this.alreadyConsumed = true;
                if (DataTypeManager.isLOB(runtimeType)) {
                    InputStreamFactory isf = new InputStreamFactory(){

                        public InputStream getInputStream() throws IOException {
                            return payload;
                        }
                    };
                    if (runtimeType.isAssignableFrom(XMLType.class)) {
                        return new SQLXMLImpl(isf);
                    }
                    if (runtimeType.isAssignableFrom(ClobType.class)) {
                        return new ClobImpl(isf, -1L);
                    }
                    if (runtimeType.isAssignableFrom(BlobType.class)) {
                        return new BlobImpl(isf);
                    }
                } else {
                    try {
                        this.parameters = this.actionRequest.getParameters();
                    }
                    catch (DeserializerException e) {
                        throw new TeiidProcessingException((Throwable)e);
                    }
                }
            }
            if (this.parameters != null && !this.parameters.isEmpty()) {
                for (Parameter parameter : this.parameters) {
                    if (!parameter.getName().equals(edmParameter.getName())) continue;
                    return parameter.getValue();
                }
            }
            return null;
        }
    }

    static class ProcedureReturn
    implements ProcedureReturnType {
        private EdmReturnType type;
        private Integer sqlType = null;
        private boolean hasResultSet;

        public ProcedureReturn(EdmReturnType type, Integer sqlType, boolean hasResultSet) {
            this.type = type;
            this.sqlType = sqlType;
            this.hasResultSet = hasResultSet;
        }

        public EdmReturnType getReturnType() {
            return this.type;
        }

        @Override
        public boolean hasResultSet() {
            return this.hasResultSet;
        }

        @Override
        public Integer getSqlType() {
            return this.sqlType;
        }
    }
}

