/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufParser;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.TagHandler;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.EnumValueDescriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.protostream.impl.BaseMarshallerDelegate;
import org.infinispan.protostream.impl.ByteArrayOutputStreamEx;
import org.infinispan.protostream.impl.RawProtoStreamReaderImpl;
import org.infinispan.protostream.impl.RawProtoStreamWriterImpl;
import org.infinispan.protostream.impl.SerializationContextImpl;

public final class ProtobufUtil {
    private static final String WRAPPING_DEFINITIONS_RES = "/org/infinispan/protostream/message-wrapping.proto";
    private static final ThreadLocal<DateFormat> timestampFormat = ThreadLocal.withInitial(() -> {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.setGregorianChange(new Date(Long.MIN_VALUE));
        sdf.setCalendar(calendar);
        return sdf;
    });

    private ProtobufUtil() {
    }

    public static SerializationContext newSerializationContext(Configuration configuration) {
        SerializationContextImpl serializationContext = new SerializationContextImpl(configuration);
        try {
            serializationContext.registerProtoFiles(FileDescriptorSource.fromResources(WRAPPING_DEFINITIONS_RES));
        }
        catch (IOException | DescriptorParserException e) {
            throw new RuntimeException("Failed to initialize serialization context", e);
        }
        serializationContext.registerMarshaller(new WrappedMessage.Marshaller());
        return serializationContext;
    }

    private static <A> void writeTo(ImmutableSerializationContext ctx, RawProtoStreamWriter out, A t) throws IOException {
        if (t == null) {
            throw new IllegalArgumentException("Object to marshall cannot be null");
        }
        BaseMarshallerDelegate<?> marshallerDelegate = ((SerializationContextImpl)ctx).getMarshallerDelegate(t.getClass());
        marshallerDelegate.marshall(null, t, null, out);
        out.flush();
    }

    public static void writeTo(ImmutableSerializationContext ctx, OutputStream out, Object t) throws IOException {
        ProtobufUtil.writeTo(ctx, RawProtoStreamWriterImpl.newInstance(out), t);
    }

    public static byte[] toByteArray(ImmutableSerializationContext ctx, Object t) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ProtobufUtil.writeTo(ctx, baos, t);
        return baos.toByteArray();
    }

    public static ByteBuffer toByteBuffer(ImmutableSerializationContext ctx, Object t) throws IOException {
        ByteArrayOutputStreamEx baos = new ByteArrayOutputStreamEx();
        ProtobufUtil.writeTo(ctx, baos, t);
        return baos.getByteBuffer();
    }

    private static <A> A readFrom(ImmutableSerializationContext ctx, RawProtoStreamReader in, Class<A> clazz) throws IOException {
        BaseMarshallerDelegate<A> marshallerDelegate = ((SerializationContextImpl)ctx).getMarshallerDelegate(clazz);
        return marshallerDelegate.unmarshall(null, null, in);
    }

    public static <A> A readFrom(ImmutableSerializationContext ctx, InputStream in, Class<A> clazz) throws IOException {
        return ProtobufUtil.readFrom(ctx, RawProtoStreamReaderImpl.newInstance(in), clazz);
    }

    public static <A> A fromByteArray(ImmutableSerializationContext ctx, byte[] bytes, Class<A> clazz) throws IOException {
        return ProtobufUtil.readFrom(ctx, RawProtoStreamReaderImpl.newInstance(bytes), clazz);
    }

    public static <A> A fromByteArray(ImmutableSerializationContext ctx, byte[] bytes, int offset, int length, Class<A> clazz) throws IOException {
        return ProtobufUtil.readFrom(ctx, RawProtoStreamReaderImpl.newInstance(bytes, offset, length), clazz);
    }

    public static <A> A fromByteBuffer(ImmutableSerializationContext ctx, ByteBuffer byteBuffer, Class<A> clazz) throws IOException {
        return ProtobufUtil.readFrom(ctx, RawProtoStreamReaderImpl.newInstance(byteBuffer), clazz);
    }

    public static <A> A fromWrappedByteArray(ImmutableSerializationContext ctx, byte[] bytes) throws IOException {
        return ProtobufUtil.fromWrappedByteArray(ctx, bytes, 0, bytes.length);
    }

    public static <A> A fromWrappedByteArray(ImmutableSerializationContext ctx, byte[] bytes, int offset, int length) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes, offset, length);
        return (A)WrappedMessage.readMessage(ctx, RawProtoStreamReaderImpl.newInstance(bais));
    }

    public static <A> A fromWrappedByteBuffer(ImmutableSerializationContext ctx, ByteBuffer byteBuffer) throws IOException {
        return (A)WrappedMessage.readMessage(ctx, RawProtoStreamReaderImpl.newInstance(byteBuffer));
    }

    public static byte[] toWrappedByteArray(ImmutableSerializationContext ctx, Object t) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        WrappedMessage.writeMessage(ctx, RawProtoStreamWriterImpl.newInstance(baos), t);
        return baos.toByteArray();
    }

    public static ByteBuffer toWrappedByteBuffer(ImmutableSerializationContext ctx, Object t) throws IOException {
        ByteArrayOutputStreamEx baos = new ByteArrayOutputStreamEx();
        WrappedMessage.writeMessage(ctx, RawProtoStreamWriterImpl.newInstance(baos), t);
        return baos.getByteBuffer();
    }

    public static String toCanonicalJSON(ImmutableSerializationContext ctx, byte[] bytes) throws IOException {
        return ProtobufUtil.toCanonicalJSON(ctx, bytes, true);
    }

    public static String toCanonicalJSON(ImmutableSerializationContext ctx, byte[] bytes, boolean prettyPrint) throws IOException {
        StringBuilder jsonOut = new StringBuilder();
        ProtobufUtil.toCanonicalJSON(ctx, bytes, jsonOut, prettyPrint ? 0 : -1);
        return jsonOut.toString();
    }

    private static void toCanonicalJSON(final ImmutableSerializationContext ctx, byte[] bytes, final StringBuilder jsonOut, final int initNestingLevel) throws IOException {
        if (bytes.length == 0) {
            jsonOut.append("null");
            return;
        }
        final Descriptor wrapperDescriptor = ctx.getMessageDescriptor("org.infinispan.protostream.WrappedMessage");
        final boolean prettyPrint = initNestingLevel >= 0;
        final TagHandler messageHandler = new TagHandler(){
            private JsonNestingLevel nestingLevel;

            private void indent() {
                jsonOut.append('\n');
                for (int k = initNestingLevel + this.nestingLevel.indent; k > 0; --k) {
                    jsonOut.append("   ");
                }
            }

            @Override
            public void onStart() {
                this.nestingLevel = new JsonNestingLevel(null);
                if (prettyPrint) {
                    this.indent();
                    ++this.nestingLevel.indent;
                }
                jsonOut.append('{');
            }

            @Override
            public void onTag(int fieldNumber, FieldDescriptor fieldDescriptor, Object tagValue) {
                if (fieldDescriptor == null) {
                    return;
                }
                this.startSlot(fieldDescriptor);
                switch (fieldDescriptor.getType()) {
                    case STRING: 
                    case INT64: 
                    case SINT64: 
                    case UINT64: 
                    case FIXED64: {
                        jsonOut.append('\"').append(tagValue).append('\"');
                        break;
                    }
                    case FLOAT: {
                        Float f = (Float)tagValue;
                        if (f.isInfinite() || f.isNaN()) {
                            jsonOut.append('\"').append(f).append('\"');
                            break;
                        }
                        jsonOut.append(f);
                        break;
                    }
                    case DOUBLE: {
                        Double d = (Double)tagValue;
                        if (d.isInfinite() || d.isNaN()) {
                            jsonOut.append('\"').append(d).append('\"');
                            break;
                        }
                        jsonOut.append(d);
                        break;
                    }
                    case ENUM: {
                        EnumValueDescriptor enumValue = fieldDescriptor.getEnumType().findValueByNumber((Integer)tagValue);
                        jsonOut.append('\"').append(enumValue.getName()).append('\"');
                        break;
                    }
                    case BYTES: {
                        String base64encoded = Base64.getEncoder().encodeToString((byte[])tagValue);
                        jsonOut.append('\"').append(base64encoded).append('\"');
                        break;
                    }
                    default: {
                        if (tagValue instanceof Date) {
                            jsonOut.append('\"').append(ProtobufUtil.formatDate((Date)tagValue)).append('\"');
                            break;
                        }
                        jsonOut.append(tagValue);
                    }
                }
            }

            @Override
            public void onStartNested(int fieldNumber, FieldDescriptor fieldDescriptor) {
                if (fieldDescriptor == null) {
                    return;
                }
                this.startSlot(fieldDescriptor);
                this.nestingLevel = new JsonNestingLevel(this.nestingLevel);
                if (prettyPrint) {
                    this.indent();
                    ++this.nestingLevel.indent;
                }
                jsonOut.append('{');
            }

            @Override
            public void onEndNested(int fieldNumber, FieldDescriptor fieldDescriptor) {
                if (prettyPrint) {
                    --this.nestingLevel.indent;
                    this.indent();
                }
                jsonOut.append('}');
                this.nestingLevel = this.nestingLevel.previous;
            }

            @Override
            public void onEnd() {
                if (this.nestingLevel.repeatedFieldDescriptor != null) {
                    this.endArraySlot();
                }
                if (prettyPrint) {
                    --this.nestingLevel.indent;
                    this.indent();
                }
                jsonOut.append('}');
                this.nestingLevel = null;
                if (prettyPrint) {
                    jsonOut.append('\n');
                }
            }

            private void startSlot(FieldDescriptor fieldDescriptor) {
                if (this.nestingLevel.repeatedFieldDescriptor != null && this.nestingLevel.repeatedFieldDescriptor != fieldDescriptor) {
                    this.endArraySlot();
                }
                if (this.nestingLevel.isFirstField) {
                    this.nestingLevel.isFirstField = false;
                } else {
                    jsonOut.append(',');
                }
                if (!fieldDescriptor.isRepeated() || this.nestingLevel.repeatedFieldDescriptor == null) {
                    if (prettyPrint) {
                        this.indent();
                    }
                    jsonOut.append('\"').append(fieldDescriptor.getName()).append("\":");
                }
                if (prettyPrint) {
                    jsonOut.append(' ');
                }
                if (fieldDescriptor.isRepeated() && this.nestingLevel.repeatedFieldDescriptor == null) {
                    this.nestingLevel.repeatedFieldDescriptor = fieldDescriptor;
                    jsonOut.append('[');
                }
            }

            private void endArraySlot() {
                if (prettyPrint && this.nestingLevel.repeatedFieldDescriptor.getType() == Type.MESSAGE) {
                    this.indent();
                }
                this.nestingLevel.repeatedFieldDescriptor = null;
                jsonOut.append(']');
            }
        };
        TagHandler wrapperHandler = new TagHandler(){
            private Integer typeId;
            private String typeName;
            private byte[] wrappedMessage;
            private Integer wrappedEnum;

            private GenericDescriptor getDescriptor() {
                return this.typeId != null ? ctx.getDescriptorByTypeId(this.typeId) : ctx.getDescriptorByName(this.typeName);
            }

            @Override
            public void onTag(int fieldNumber, FieldDescriptor fieldDescriptor, Object tagValue) {
                if (fieldDescriptor == null) {
                    return;
                }
                switch (fieldNumber) {
                    case 19: {
                        this.typeId = (Integer)tagValue;
                        break;
                    }
                    case 16: {
                        this.typeName = (String)tagValue;
                        break;
                    }
                    case 17: {
                        this.wrappedMessage = (byte[])tagValue;
                        break;
                    }
                    case 18: {
                        this.wrappedEnum = (Integer)tagValue;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        messageHandler.onStart();
                        messageHandler.onTag(fieldNumber, fieldDescriptor, tagValue);
                        messageHandler.onEnd();
                    }
                }
            }

            @Override
            public void onEnd() {
                if (this.wrappedEnum != null) {
                    EnumDescriptor enumDescriptor = (EnumDescriptor)this.getDescriptor();
                    String enumConstantName = enumDescriptor.findValueByNumber(this.wrappedEnum).getName();
                    FieldDescriptor fd = wrapperDescriptor.findFieldByNumber(18);
                    messageHandler.onStart();
                    messageHandler.onTag(18, fd, enumConstantName);
                    messageHandler.onEnd();
                } else if (this.wrappedMessage != null) {
                    try {
                        Descriptor messageDescriptor = (Descriptor)this.getDescriptor();
                        ProtobufParser.INSTANCE.parse(messageHandler, messageDescriptor, this.wrappedMessage);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        };
        ProtobufParser.INSTANCE.parse(wrapperHandler, wrapperDescriptor, bytes);
    }

    private static String formatDate(Date tagValue) {
        return timestampFormat.get().format(tagValue);
    }

    private static final class JsonNestingLevel {
        boolean isFirstField = true;
        FieldDescriptor repeatedFieldDescriptor;
        int indent;
        JsonNestingLevel previous;

        JsonNestingLevel(JsonNestingLevel previous) {
            this.previous = previous;
            this.indent = previous != null ? previous.indent + 1 : 0;
        }
    }
}

