/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.infinispan.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.teiid.infinispan.api.TableWireFormat;
import org.teiid.translator.document.Document;

public class InfinispanDocument
extends Document {
    private TreeMap<Integer, TableWireFormat> wireMap;
    private boolean matched = true;
    private Map<String, Stats> statsMap = new HashMap<String, Stats>();
    private Object identifier;

    public Object getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Object identifier) {
        this.identifier = identifier;
    }

    public InfinispanDocument(String name, TreeMap<Integer, TableWireFormat> columnMap, InfinispanDocument parent) {
        super(name, false, (Document)parent);
        this.wireMap = columnMap;
    }

    public void addProperty(int wireType, Object value) {
        TableWireFormat twf = this.wireMap.get(wireType);
        if (twf.isArrayType()) {
            super.addArrayProperty(twf.getColumnName(), value);
        } else {
            super.addProperty(twf.getColumnName(), value);
        }
    }

    public TreeMap<Integer, TableWireFormat> getWireMap() {
        return this.wireMap;
    }

    public boolean isMatched() {
        return this.matched;
    }

    public void setMatched(boolean matched) {
        this.matched = matched;
    }

    public void incrementUpdateCount(String childName, boolean matched) {
        Stats s = this.statsMap.get(childName);
        if (s == null) {
            s = new Stats();
            this.statsMap.put(childName, s);
        }
        if (matched) {
            s.matched.incrementAndGet();
        } else {
            s.unmatched.incrementAndGet();
        }
    }

    public int getUpdateCount(String childName, boolean matched) {
        Stats s = this.statsMap.get(childName);
        if (s == null) {
            return 0;
        }
        if (matched) {
            return s.matched.get();
        }
        return s.unmatched.get();
    }

    public int merge(InfinispanDocument updates) {
        int updated = 1;
        for (Map.Entry entry : updates.getProperties().entrySet()) {
            this.addProperty((String)entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : updates.getChildren().entrySet()) {
            String childName = (String)entry.getKey();
            List childUpdates = updates.getChildDocuments(childName);
            InfinispanDocument childUpdate = (InfinispanDocument)((Object)childUpdates.get(0));
            if (childUpdate.getProperties().isEmpty()) continue;
            List previousChildren = this.getChildDocuments(childName);
            if (previousChildren == null || previousChildren.isEmpty()) {
                this.addChildDocument(childName, childUpdate);
                continue;
            }
            for (Document doc : previousChildren) {
                InfinispanDocument previousChild = (InfinispanDocument)doc;
                if (!previousChild.isMatched()) continue;
                for (Map.Entry childEntry : childUpdate.getProperties().entrySet()) {
                    String key = ((String)childEntry.getKey()).substring(((String)childEntry.getKey()).lastIndexOf(47) + 1);
                    previousChild.addProperty(key, childEntry.getValue());
                    ++updated;
                }
            }
        }
        return updated;
    }

    static class Stats {
        AtomicInteger matched = new AtomicInteger(0);
        AtomicInteger unmatched = new AtomicInteger(0);

        Stats() {
        }
    }
}

