/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.infinispan.api;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.infinispan.protostream.RawProtobufMarshaller;
import org.infinispan.protostream.impl.ByteArrayOutputStreamEx;
import org.infinispan.protostream.impl.RawProtoStreamWriterImpl;
import org.teiid.infinispan.api.DocumentFilter;
import org.teiid.infinispan.api.InfinispanDocument;
import org.teiid.infinispan.api.ProtobufDataManager;
import org.teiid.infinispan.api.TableWireFormat;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.document.Document;

public class TeiidTableMarsheller
implements RawProtobufMarshaller<InfinispanDocument>,
Serializable {
    private static final long serialVersionUID = 6540991524742624955L;
    private String documentName;
    private TreeMap<Integer, TableWireFormat> wireMap = new TreeMap();
    private DocumentFilter docFilter;

    public TeiidTableMarsheller(String docName, TreeMap<Integer, TableWireFormat> wireMap) {
        this(docName, wireMap, null);
    }

    public TeiidTableMarsheller(String docName, TreeMap<Integer, TableWireFormat> wireMap, DocumentFilter filter) {
        this.documentName = docName;
        this.wireMap = wireMap;
        this.docFilter = filter;
    }

    public String getTypeName() {
        return this.documentName;
    }

    public InfinispanDocument readFrom(ImmutableSerializationContext ctx, RawProtoStreamReader in) throws IOException {
        InfinispanDocument row = new InfinispanDocument(this.documentName, this.wireMap, null);
        TeiidTableMarsheller.readDocument(in, row, this.wireMap, this.docFilter);
        return row;
    }

    public void writeTo(ImmutableSerializationContext ctx, RawProtoStreamWriter out, InfinispanDocument document) throws IOException {
        TreeMap<Integer, TableWireFormat> wireMap = document.getWireMap();
        block17: for (Map.Entry<Integer, TableWireFormat> entry : wireMap.entrySet()) {
            TableWireFormat twf = entry.getValue();
            if (twf == null) {
                throw new IOException("Error in wireformat");
            }
            int tag = twf.getWriteTag();
            if (twf.isNested()) {
                List children = document.getChildDocuments(twf.getAttributeName());
                if (children == null) continue;
                for (Document d : children) {
                    ByteArrayOutputStreamEx baos = new ByteArrayOutputStreamEx();
                    RawProtoStreamWriter rpsw = RawProtoStreamWriterImpl.newInstance((OutputStream)baos);
                    this.writeTo(ctx, rpsw, (InfinispanDocument)d);
                    rpsw.flush();
                    baos.flush();
                    out.writeBytes(tag, baos.getByteBuffer());
                }
                continue;
            }
            Object value = document.getProperties().get(twf.getAttributeName());
            if (value == null) continue;
            ArrayList values = null;
            boolean array = twf.isArrayType();
            if (array) {
                values = (ArrayList)value;
            }
            switch (twf.getProtobufType()) {
                case DOUBLE: {
                    if (array) {
                        for (Object o : values) {
                            out.writeDouble(tag, ProtobufDataManager.convertToInfinispan(Double.class, o).doubleValue());
                        }
                        continue block17;
                    }
                    out.writeDouble(tag, ProtobufDataManager.convertToInfinispan(Double.class, value).doubleValue());
                    break;
                }
                case FLOAT: {
                    if (array) {
                        for (Object o : values) {
                            out.writeFloat(tag, ProtobufDataManager.convertToInfinispan(Float.class, o).floatValue());
                        }
                        continue block17;
                    }
                    out.writeFloat(tag, ProtobufDataManager.convertToInfinispan(Float.class, value).floatValue());
                    break;
                }
                case BOOL: {
                    if (array) {
                        for (Object o : values) {
                            out.writeBool(tag, ProtobufDataManager.convertToInfinispan(Boolean.class, o).booleanValue());
                        }
                        continue block17;
                    }
                    out.writeBool(tag, ProtobufDataManager.convertToInfinispan(Boolean.class, value).booleanValue());
                    break;
                }
                case STRING: {
                    if (array) {
                        for (Object o : values) {
                            out.writeString(tag, ProtobufDataManager.convertToInfinispan(String.class, o));
                        }
                        continue block17;
                    }
                    out.writeString(tag, ProtobufDataManager.convertToInfinispan(String.class, value));
                    break;
                }
                case BYTES: {
                    if (array) {
                        for (Object o : values) {
                            out.writeBytes(tag, ProtobufDataManager.convertToInfinispan(byte[].class, o));
                        }
                        continue block17;
                    }
                    out.writeBytes(tag, ProtobufDataManager.convertToInfinispan(byte[].class, value));
                    break;
                }
                case INT32: {
                    if (array) {
                        for (Object o : values) {
                            out.writeInt32(tag, ProtobufDataManager.convertToInfinispan(Integer.class, o).intValue());
                        }
                        continue block17;
                    }
                    out.writeInt32(tag, ProtobufDataManager.convertToInfinispan(Integer.class, value).intValue());
                    break;
                }
                case SFIXED32: {
                    if (array) {
                        for (Object o : values) {
                            out.writeSFixed32(tag, ProtobufDataManager.convertToInfinispan(Integer.class, o).intValue());
                        }
                        continue block17;
                    }
                    out.writeSFixed32(tag, ProtobufDataManager.convertToInfinispan(Integer.class, value).intValue());
                    break;
                }
                case FIXED32: {
                    if (array) {
                        for (Object o : values) {
                            out.writeFixed32(tag, ProtobufDataManager.convertToInfinispan(Integer.class, o).intValue());
                        }
                        continue block17;
                    }
                    out.writeFixed32(tag, ProtobufDataManager.convertToInfinispan(Integer.class, value).intValue());
                    break;
                }
                case UINT32: {
                    if (array) {
                        for (Object o : values) {
                            out.writeUInt32(tag, ProtobufDataManager.convertToInfinispan(Integer.class, o).intValue());
                        }
                        continue block17;
                    }
                    out.writeUInt32(tag, ProtobufDataManager.convertToInfinispan(Integer.class, value).intValue());
                    break;
                }
                case SINT32: {
                    if (array) {
                        for (Object o : values) {
                            out.writeSInt32(tag, ProtobufDataManager.convertToInfinispan(Integer.class, o).intValue());
                        }
                        continue block17;
                    }
                    out.writeSInt32(tag, ProtobufDataManager.convertToInfinispan(Integer.class, value).intValue());
                    break;
                }
                case INT64: {
                    if (array) {
                        for (Object o : values) {
                            out.writeInt64(tag, ProtobufDataManager.convertToInfinispan(Long.class, o).longValue());
                        }
                        continue block17;
                    }
                    out.writeInt64(tag, ProtobufDataManager.convertToInfinispan(Long.class, value).longValue());
                    break;
                }
                case UINT64: {
                    if (array) {
                        for (Object o : values) {
                            out.writeUInt64(tag, ProtobufDataManager.convertToInfinispan(Long.class, o).longValue());
                        }
                        continue block17;
                    }
                    out.writeUInt64(tag, ProtobufDataManager.convertToInfinispan(Long.class, value).longValue());
                    break;
                }
                case FIXED64: {
                    if (array) {
                        for (Object o : values) {
                            out.writeFixed64(tag, ProtobufDataManager.convertToInfinispan(Long.class, o).longValue());
                        }
                        continue block17;
                    }
                    out.writeFixed64(tag, ProtobufDataManager.convertToInfinispan(Long.class, value).longValue());
                    break;
                }
                case SFIXED64: {
                    if (array) {
                        for (Object o : values) {
                            out.writeSFixed64(tag, ProtobufDataManager.convertToInfinispan(Long.class, o).longValue());
                        }
                        continue block17;
                    }
                    out.writeSFixed64(tag, ProtobufDataManager.convertToInfinispan(Long.class, value).longValue());
                    break;
                }
                case SINT64: {
                    if (array) {
                        for (Object o : values) {
                            out.writeSInt64(tag, ProtobufDataManager.convertToInfinispan(Long.class, o).longValue());
                        }
                        continue block17;
                    }
                    out.writeSInt64(tag, ProtobufDataManager.convertToInfinispan(Long.class, value).longValue());
                    break;
                }
                default: {
                    throw new IOException("Unexpected field type : " + twf.getProtobufType());
                }
            }
        }
    }

    static void readDocument(RawProtoStreamReader in, InfinispanDocument document, TreeMap<Integer, TableWireFormat> columnMap, DocumentFilter filter) throws IOException {
        int tag;
        block19: while ((tag = in.readTag()) != 0) {
            TableWireFormat twf = columnMap.get(tag);
            if (twf == null) {
                throw new IOException("Error in wireformat");
            }
            if (twf.isNested()) {
                InfinispanDocument child = new InfinispanDocument(twf.getAttributeName(), twf.getNestedWireMap(), document);
                int length = in.readRawVarint32();
                int oldLimit = in.pushLimit(length);
                TeiidTableMarsheller.readDocument(in, child, twf.getNestedWireMap(), filter);
                try {
                    if (filter == null) {
                        document.addChildDocument(twf.getAttributeName(), child);
                        document.incrementUpdateCount(twf.getAttributeName(), true);
                    } else {
                        boolean matched = filter.matches(document.getProperties(), child.getProperties());
                        if (matched) {
                            if (filter.action() == DocumentFilter.Action.ADD) {
                                document.addChildDocument(twf.getAttributeName(), child);
                            } else if (filter.action() != DocumentFilter.Action.REMOVE) {
                                document.addChildDocument(twf.getAttributeName(), child);
                            }
                        } else if (filter.action() == DocumentFilter.Action.ALWAYSADD || filter.action() == DocumentFilter.Action.REMOVE) {
                            document.addChildDocument(twf.getAttributeName(), child);
                        }
                        child.setMatched(matched);
                        document.incrementUpdateCount(twf.getAttributeName(), matched);
                    }
                }
                catch (TranslatorException e) {
                    throw new IOException(e.getCause());
                }
                in.checkLastTagWas(0);
                in.popLimit(oldLimit);
                continue;
            }
            switch (twf.getProtobufType()) {
                case DOUBLE: {
                    document.addProperty(tag, ProtobufDataManager.convertToRuntime(twf.expectedType(), in.readDouble()));
                    continue block19;
                }
                case FLOAT: {
                    document.addProperty(tag, ProtobufDataManager.convertToRuntime(twf.expectedType(), Float.valueOf(in.readFloat())));
                    continue block19;
                }
                case BOOL: {
                    document.addProperty(tag, ProtobufDataManager.convertToRuntime(twf.expectedType(), in.readBool()));
                    continue block19;
                }
                case STRING: {
                    document.addProperty(tag, ProtobufDataManager.convertToRuntime(twf.expectedType(), in.readString()));
                    continue block19;
                }
                case BYTES: {
                    document.addProperty(tag, ProtobufDataManager.convertToRuntime(twf.expectedType(), in.readByteArray()));
                    continue block19;
                }
                case INT32: {
                    document.addProperty(tag, ProtobufDataManager.convertToRuntime(twf.expectedType(), in.readInt32()));
                    continue block19;
                }
                case SFIXED32: {
                    document.addProperty(tag, ProtobufDataManager.convertToRuntime(twf.expectedType(), in.readSFixed32()));
                    continue block19;
                }
                case FIXED32: {
                    document.addProperty(tag, ProtobufDataManager.convertToRuntime(twf.expectedType(), in.readFixed32()));
                    continue block19;
                }
                case UINT32: {
                    document.addProperty(tag, ProtobufDataManager.convertToRuntime(twf.expectedType(), in.readUInt32()));
                    continue block19;
                }
                case SINT32: {
                    document.addProperty(tag, ProtobufDataManager.convertToRuntime(twf.expectedType(), in.readSInt32()));
                    continue block19;
                }
                case INT64: {
                    document.addProperty(tag, ProtobufDataManager.convertToRuntime(twf.expectedType(), in.readInt64()));
                    continue block19;
                }
                case UINT64: {
                    document.addProperty(tag, ProtobufDataManager.convertToRuntime(twf.expectedType(), in.readUInt64()));
                    continue block19;
                }
                case FIXED64: {
                    document.addProperty(tag, ProtobufDataManager.convertToRuntime(twf.expectedType(), in.readFixed64()));
                    continue block19;
                }
                case SFIXED64: {
                    document.addProperty(tag, ProtobufDataManager.convertToRuntime(twf.expectedType(), in.readSFixed64()));
                    continue block19;
                }
                case SINT64: {
                    document.addProperty(tag, ProtobufDataManager.convertToRuntime(twf.expectedType(), in.readSInt64()));
                    continue block19;
                }
            }
            throw new IOException("Unexpected field type : " + twf.getProtobufType());
        }
    }

    public Class getJavaClass() {
        return InfinispanDocument.class;
    }
}

