/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.accumulo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.hadoop.io.Text;
import org.teiid.language.LanguageObject;
import org.teiid.language.Select;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.accumulo.AccumuloConnection;
import org.teiid.translator.accumulo.AccumuloDataTypeManager;
import org.teiid.translator.accumulo.AccumuloExecutionFactory;
import org.teiid.translator.accumulo.AccumuloMetadataProcessor;
import org.teiid.translator.accumulo.AccumuloQueryVisitor;

public class AccumuloQueryExecution
implements ResultSetExecution {
    private AccumuloConnection connection;
    private Iterator<Map.Entry<Key, Value>> results;
    private Class<?>[] expectedColumnTypes;
    private AccumuloExecutionFactory aef;
    private AccumuloQueryVisitor visitor;
    private Map.Entry<Key, Value> prevEntry;

    public AccumuloQueryExecution(AccumuloExecutionFactory aef, Select command, ExecutionContext executionContext, RuntimeMetadata metadata, AccumuloConnection connection) throws TranslatorException {
        this.aef = aef;
        this.connection = connection;
        this.expectedColumnTypes = command.getColumnTypes();
        this.visitor = new AccumuloQueryVisitor(this.aef);
        this.visitor.visitNode((LanguageObject)command);
        if (!this.visitor.exceptions.isEmpty()) {
            throw this.visitor.exceptions.get(0);
        }
    }

    public void execute() throws TranslatorException {
        try {
            Connector connector = this.connection.getInstance();
            List<Range> ranges = this.visitor.getRanges();
            Table scanTable = this.visitor.getScanTable();
            List<IteratorSetting> scanIterators = this.visitor.scanIterators();
            this.results = AccumuloQueryExecution.runQuery(this.aef, connector, this.connection.getAuthorizations(), ranges, scanTable, scanIterators);
        }
        catch (TableNotFoundException e) {
            this.results = null;
        }
    }

    static Iterator<Map.Entry<Key, Value>> runQuery(AccumuloExecutionFactory aef, Connector connector, Authorizations auths, List<Range> ranges, Table scanTable, List<IteratorSetting> scanIterators) throws TableNotFoundException {
        if (ranges.size() <= 1) {
            Scanner scanner = connector.createScanner(SQLStringVisitor.getRecordName((AbstractMetadataRecord)scanTable), auths);
            if (!ranges.isEmpty()) {
                scanner.setRange(ranges.get(0));
            }
            if (scanIterators != null && !scanIterators.isEmpty()) {
                for (IteratorSetting it : scanIterators) {
                    scanner.addScanIterator(it);
                }
            }
            scanner.enableIsolation();
            return scanner.iterator();
        }
        BatchScanner scanner = connector.createBatchScanner(SQLStringVisitor.getRecordName((AbstractMetadataRecord)scanTable), auths, aef.getQueryThreadsCount());
        scanner.setRanges(ranges);
        return scanner.iterator();
    }

    private SortedMap<Key, Value> readNextRow() {
        ByteSequence prevRowId = null;
        TreeMap<Key, Value> row = new TreeMap<Key, Value>();
        while (this.prevEntry != null || this.results != null && this.results.hasNext()) {
            Map.Entry<Key, Value> entry = null;
            if (this.prevEntry != null) {
                entry = this.prevEntry;
                this.prevEntry = null;
            } else {
                entry = this.results.next();
            }
            ByteSequence rowId = entry.getKey().getRowData();
            if (prevRowId == null || prevRowId.equals((Object)rowId)) {
                prevRowId = rowId;
                row.put(entry.getKey(), entry.getValue());
                continue;
            }
            this.prevEntry = entry;
            return row;
        }
        return row;
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        SortedMap<Key, Value> rowItems = this.readNextRow();
        boolean rowIdAdded = false;
        LinkedHashMap<String, byte[]> values = new LinkedHashMap<String, byte[]>();
        for (Key key : rowItems.keySet()) {
            Text cf = key.getColumnFamily();
            Text cq = key.getColumnQualifier();
            Text rowid = key.getRow();
            Value value = (Value)rowItems.get(key);
            Column match = this.findMatchingColumn(cf, cq);
            if (!rowIdAdded) {
                values.put("rowid", rowid.getBytes());
                rowIdAdded = true;
            }
            if (match == null) continue;
            String valueIn = match.getProperty("{http://www.teiid.org/translator/accumulo/2013}VALUE-IN", false);
            if (values.get(match.getName()) != null) continue;
            values.put(match.getName(), this.buildValue(valueIn, cq, value));
        }
        return this.nextRow(values);
    }

    private Column findMatchingColumn(Text rowCF, Text rowCQ) {
        String CF = new String(rowCF.getBytes());
        String CQ = new String(rowCQ.getBytes());
        Column column = this.visitor.lookupColumn(CF + "/" + CQ);
        if (column == null) {
            column = this.visitor.lookupColumn(CF);
        }
        return column;
    }

    private List<?> nextRow(Map<String, byte[]> values) {
        if (!values.isEmpty()) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < this.visitor.projectedColumns().size(); ++i) {
                Column column = this.visitor.projectedColumns().get(i);
                String colName = SQLStringVisitor.getRecordName((AbstractMetadataRecord)column);
                byte[] value = values.get(colName);
                list.add(AccumuloDataTypeManager.deserialize(value, this.expectedColumnTypes[i]));
            }
            return list;
        }
        return null;
    }

    private byte[] buildValue(String pattern, Text cq, Value value) {
        if (pattern == null) {
            return value.get();
        }
        if ((pattern = pattern.substring(1, pattern.length() - 1)).equals(AccumuloMetadataProcessor.ValueIn.VALUE.name())) {
            return value.get();
        }
        if (pattern.equals(AccumuloMetadataProcessor.ValueIn.CQ.name())) {
            return cq.getBytes();
        }
        return null;
    }

    public void close() {
    }

    public void cancel() throws TranslatorException {
    }
}

