/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.net.socket;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.teiid.client.security.ILogon;
import org.teiid.client.security.InvalidSessionException;
import org.teiid.client.security.LogonException;
import org.teiid.client.security.LogonResult;
import org.teiid.client.util.ExceptionUtil;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.gss.MakeGSS;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.net.CommunicationException;
import org.teiid.net.ConnectionException;
import org.teiid.net.HostInfo;
import org.teiid.net.ServerConnection;
import org.teiid.net.socket.AuthenticationType;
import org.teiid.net.socket.SingleInstanceCommunicationException;
import org.teiid.net.socket.SocketServerInstance;
import org.teiid.net.socket.SocketServerInstanceFactory;
import org.teiid.net.socket.SocketServerInstanceImpl;
import org.teiid.net.socket.UrlServerDiscovery;

public class SocketServerConnection
implements ServerConnection {
    private static final int FAILOVER_PING_INTERVAL = 1000;
    private SocketServerInstanceFactory connectionFactory;
    private UrlServerDiscovery serverDiscovery;
    private static Logger log = Logger.getLogger("org.teiid.client.sockets");
    private boolean secure;
    private Properties connProps;
    private SocketServerInstance serverInstance;
    private LogonResult logonResult;
    private ILogon logon;
    private boolean closed;
    private boolean failOver;
    private long lastPing = System.currentTimeMillis();
    private int pingFailOverInterval = 1000;
    private String serverVersion;

    public SocketServerConnection(SocketServerInstanceFactory connectionFactory, boolean secure, UrlServerDiscovery serverDiscovery, Properties connProps) throws CommunicationException, ConnectionException {
        this.connectionFactory = connectionFactory;
        this.serverDiscovery = serverDiscovery;
        this.connProps = connProps;
        this.secure = secure;
        this.logon = this.getService(ILogon.class);
        this.failOver = Boolean.valueOf(connProps.getProperty("autoFailover"));
        this.serverVersion = this.selectServerInstance().getServerVersion();
    }

    public synchronized SocketServerInstance selectServerInstance() throws CommunicationException, ConnectionException {
        if (this.closed) {
            throw new CommunicationException((BundleUtil.Event)JDBCPlugin.Event.TEIID20016, JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID20016, new Object[0]));
        }
        if (this.serverInstance != null && (!this.failOver || this.serverInstance.isOpen())) {
            return this.serverInstance;
        }
        ArrayList<HostInfo> hostKeys = new ArrayList<HostInfo>(this.serverDiscovery.getKnownHosts());
        this.closeServerInstance();
        ArrayList<HostInfo> hostCopy = new ArrayList<HostInfo>(hostKeys);
        int knownHosts = hostKeys.size();
        while (hostKeys.size() > 0) {
            HostInfo hostInfo = this.serverDiscovery.selectNextInstance(hostKeys);
            Object ex = null;
            try {
                if (!hostInfo.isResolved()) {
                    InetAddress inetAddress = hostInfo.getInetAddress();
                    if (!hostInfo.isResolved()) {
                        hostInfo = new HostInfo(hostInfo.getHostName(), new InetSocketAddress(inetAddress, hostInfo.getPortNumber()));
                    }
                }
                hostInfo.setSsl(this.secure);
                this.serverInstance = this.connectionFactory.getServerInstance(hostInfo);
                this.connectSession();
                return this.serverInstance;
            }
            catch (IOException e) {
                ex = e;
            }
            catch (SingleInstanceCommunicationException e) {
                ex = e;
            }
            if (knownHosts == 1) {
                if (ex instanceof UnknownHostException) {
                    throw new SingleInstanceCommunicationException(JDBCPlugin.Event.TEIID20019, (Throwable)ex, JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID20019, new Object[]{hostInfo.getHostName()}));
                }
                throw new SingleInstanceCommunicationException(JDBCPlugin.Event.TEIID20020, (Throwable)ex, JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID20020, new Object[]{hostInfo.getHostName(), String.valueOf(hostInfo.getPortNumber()), ((Throwable)ex).getMessage()}));
            }
            log.log(Level.FINE, "Unable to connect to host", (Throwable)ex);
        }
        throw new CommunicationException((BundleUtil.Event)JDBCPlugin.Event.TEIID20021, JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID20021, new Object[]{((Object)hostCopy).toString()}));
    }

    private void logon(ILogon newLogon) throws LogonException, TeiidComponentException, CommunicationException {
        SocketServerInstance instance = this.serverInstance;
        SocketServerConnection.updateConnectionProperties(this.connProps, instance.getLocalAddress(), true);
        LogonResult newResult = null;
        newResult = this.connProps.contains("jaasName") ? MakeGSS.authenticate(newLogon, this.connProps) : newLogon.logon(this.connProps);
        AuthenticationType type = (AuthenticationType)((Object)newResult.getProperty("authType"));
        if (type != null) {
            if (type == AuthenticationType.GSS) {
                newResult = MakeGSS.authenticate(newLogon, this.connProps);
            } else {
                throw new LogonException(JDBCPlugin.Event.TEIID20034, JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID20034, new Object[]{type}));
            }
        }
        this.logoff();
        this.logonResult = newResult;
    }

    public static void updateConnectionProperties(Properties connectionProperties, InetAddress addr, boolean setMac) {
        if (addr == null) {
            return;
        }
        String address = addr.getHostAddress();
        Object old = connectionProperties.put("clientIpAddress", address);
        if (old == null || !address.equals(old)) {
            if (addr.isLoopbackAddress()) {
                connectionProperties.put("clientHostName", addr.getCanonicalHostName());
            } else {
                connectionProperties.put("clientHostName", "localhost");
            }
            if (setMac) {
                try {
                    NetworkInterface ni = NetworkInterface.getByInetAddress(addr);
                    if (ni != null && ni.getHardwareAddress() != null) {
                        StringBuilder sb = new StringBuilder();
                        for (byte b : ni.getHardwareAddress()) {
                            sb.append(PropertiesUtils.toHex((int)(b >> 4)));
                            sb.append(PropertiesUtils.toHex((int)b));
                        }
                        connectionProperties.put("clientMAC", sb.toString());
                    }
                }
                catch (SocketException e) {
                    connectionProperties.remove("clientMAC");
                }
            } else {
                connectionProperties.remove("clientMAC");
            }
        }
    }

    private ILogon connectSession() throws CommunicationException, ConnectionException {
        ILogon newLogon = this.serverInstance.getService(ILogon.class);
        if (this.logonResult != null) {
            try {
                newLogon.assertIdentity(this.logonResult.getSessionToken());
            }
            catch (TeiidException e) {
                this.disconnect();
            }
        }
        if (this.logonResult == null) {
            try {
                this.logon(newLogon);
            }
            catch (LogonException e) {
                throw new ConnectionException((Throwable)((Object)e));
            }
            catch (TeiidComponentException e) {
                if (e.getCause() instanceof CommunicationException) {
                    throw (CommunicationException)((Object)e.getCause());
                }
                throw new CommunicationException(JDBCPlugin.Event.TEIID20018, e, JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID20018, new Object[0]));
            }
        }
        return newLogon;
    }

    @Override
    public <T> T getService(Class<T> iface) {
        return iface.cast(Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{iface}, (InvocationHandler)new SocketServerInstanceImpl.RemoteInvocationHandler(iface, PropertiesUtils.getBooleanProperty((Properties)this.connProps, (String)"encryptRequests", (boolean)false)){

            @Override
            protected SocketServerInstance getInstance() throws CommunicationException {
                if (SocketServerConnection.this.failOver && System.currentTimeMillis() - SocketServerConnection.this.lastPing > (long)SocketServerConnection.this.pingFailOverInterval) {
                    try {
                        ResultsFuture<?> future = SocketServerConnection.this.selectServerInstance().getService(ILogon.class).ping();
                        future.get();
                    }
                    catch (SingleInstanceCommunicationException e) {
                        SocketServerConnection.this.closeServerInstance();
                    }
                    catch (CommunicationException e) {
                        throw e;
                    }
                    catch (InvalidSessionException e) {
                        SocketServerConnection.this.disconnect();
                        SocketServerConnection.this.closeServerInstance();
                    }
                    catch (Exception e) {
                        SocketServerConnection.this.closeServerInstance();
                    }
                }
                SocketServerConnection.this.lastPing = System.currentTimeMillis();
                try {
                    return SocketServerConnection.this.selectServerInstance();
                }
                catch (ConnectionException e) {
                    throw new CommunicationException((Throwable)((Object)e));
                }
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    return super.invoke(proxy, method, args);
                }
                catch (Exception e) {
                    if (ExceptionUtil.getExceptionOfType(e, InvalidSessionException.class) != null) {
                        SocketServerConnection.this.disconnect();
                    }
                    throw e;
                }
            }
        }));
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        if (this.serverInstance != null) {
            this.logoff();
            this.closeServerInstance();
        }
        this.closed = true;
    }

    private void logoff() {
        if (this.logonResult == null) {
            return;
        }
        this.disconnect();
        try {
            ResultsFuture<?> writeFuture = this.serverInstance.getService(ILogon.class).logoff();
            writeFuture.get(100L, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void disconnect() {
        this.logonResult = null;
    }

    private synchronized ResultsFuture<?> isOpen() throws CommunicationException, InvalidSessionException, TeiidComponentException {
        if (this.closed) {
            throw new CommunicationException((BundleUtil.Event)JDBCPlugin.Event.TEIID20023, JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID20023, new Object[0]));
        }
        return this.logon.ping();
    }

    @Override
    public boolean isOpen(long msToTest) {
        try {
            ResultsFuture<?> future = this.isOpen();
            future.get(msToTest, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (Throwable th) {
            return false;
        }
    }

    @Override
    public LogonResult getLogonResult() {
        return this.logonResult;
    }

    synchronized void closeServerInstance() {
        if (this.serverInstance != null) {
            this.serverInstance.shutdown();
            this.serverInstance = null;
        }
    }

    @Override
    public boolean isSameInstance(ServerConnection otherService) throws CommunicationException {
        if (!(otherService instanceof SocketServerConnection)) {
            return false;
        }
        try {
            return this.selectServerInstance().getHostInfo().equals(((SocketServerConnection)otherService).selectServerInstance().getHostInfo());
        }
        catch (ConnectionException e) {
            throw new CommunicationException((Throwable)((Object)e));
        }
    }

    public void setFailOver(boolean failOver) {
        this.failOver = failOver;
    }

    public void setFailOverPingInterval(int pingFailOverInterval) {
        this.pingFailOverInterval = pingFailOverInterval;
    }

    @Override
    public void authenticate() throws ConnectionException, CommunicationException {
        if (this.serverInstance == null) {
            this.selectServerInstance();
        } else {
            ILogon logonInstance = this.serverInstance.getService(ILogon.class);
            try {
                this.logon(logonInstance);
            }
            catch (LogonException e) {
                throw new ConnectionException((Throwable)((Object)e));
            }
            catch (TeiidComponentException e) {
                throw new CommunicationException(e);
            }
        }
    }

    @Override
    public boolean supportsContinuous() {
        return false;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public String getServerVersion() {
        return this.serverVersion;
    }
}

