/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.net.socket;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.Properties;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.net.CommunicationException;
import org.teiid.net.ConnectionException;
import org.teiid.net.HostInfo;
import org.teiid.net.ServerConnectionFactory;
import org.teiid.net.TeiidURL;
import org.teiid.net.socket.ObjectChannelFactory;
import org.teiid.net.socket.OioOjbectChannelFactory;
import org.teiid.net.socket.SocketServerConnection;
import org.teiid.net.socket.SocketServerInstance;
import org.teiid.net.socket.SocketServerInstanceFactory;
import org.teiid.net.socket.SocketServerInstanceImpl;
import org.teiid.net.socket.UrlServerDiscovery;

public class SocketServerConnectionFactory
implements ServerConnectionFactory,
SocketServerInstanceFactory {
    private static SocketServerConnectionFactory INSTANCE;
    private ObjectChannelFactory channelFactory;
    private long synchronousTtl = 240000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized SocketServerConnectionFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SocketServerConnectionFactory();
            Properties props = PropertiesUtils.getCombinedProperties();
            InputStream is = SocketServerConnectionFactory.class.getResourceAsStream("/teiid-client-settings.properties");
            if (is != null) {
                Properties newProps = new Properties();
                try {
                    newProps.load(is);
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                props.putAll((Map<?, ?>)newProps);
            }
            INSTANCE.initialize(props);
        }
        return INSTANCE;
    }

    public void initialize(Properties info) {
        PropertiesUtils.setBeanProperties((Object)this, (Properties)info, (String)"org.teiid.sockets");
        this.channelFactory = new OioOjbectChannelFactory(info);
    }

    @Override
    public SocketServerInstance getServerInstance(HostInfo info) throws CommunicationException, IOException {
        SocketServerInstanceImpl ssii = new SocketServerInstanceImpl(info, this.getSynchronousTtl(), this.channelFactory.getSoTimeout());
        ssii.connect(this.channelFactory);
        return ssii;
    }

    @Override
    public SocketServerConnection getConnection(Properties connectionProperties) throws CommunicationException, ConnectionException {
        TeiidURL url;
        try {
            url = new TeiidURL(connectionProperties.getProperty("serverURL"));
        }
        catch (MalformedURLException e1) {
            throw new ConnectionException(JDBCPlugin.Event.TEIID20014, e1, e1.getMessage());
        }
        UrlServerDiscovery discovery = new UrlServerDiscovery();
        discovery.init(url, connectionProperties);
        return new SocketServerConnection(this, url.isUsingSSL(), discovery, connectionProperties);
    }

    public long getSynchronousTtl() {
        return this.synchronousTtl;
    }

    public void setSynchronousTtl(long synchronousTTL) {
        this.synchronousTtl = synchronousTTL;
    }
}

