/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.impl.EngineStatisticsMetadata;
import org.teiid.adminapi.jboss.VDBMetadataMapper;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.jboss.BufferManagerService;
import org.teiid.jboss.TeiidOperationHandler;
import org.teiid.runtime.EmbeddedAdminFactory;
import org.teiid.services.BufferServiceImpl;

class EngineStatistics
extends TeiidOperationHandler {
    protected EngineStatistics() {
        super("engine-statistics");
    }

    @Override
    protected void executeOperation(OperationContext context, DQPCore engine, ModelNode operation) throws OperationFailedException {
        try {
            BufferManagerService bufferMgrSvc = this.getBufferManager(context);
            EngineStatisticsMetadata stats = EmbeddedAdminFactory.createEngineStats((int)this.getSessionCount(context), (BufferServiceImpl)bufferMgrSvc, (DQPCore)engine);
            VDBMetadataMapper.EngineStatisticsMetadataMapper.INSTANCE.wrap(stats, context.getResult());
        }
        catch (AdminException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Override
    protected void describeParameters(SimpleOperationDefinitionBuilder builder) {
        builder.setReplyType(ModelType.OBJECT);
        builder.setReplyParameters(VDBMetadataMapper.EngineStatisticsMetadataMapper.INSTANCE.getAttributeDefinitions());
    }
}

