/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.Collection;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.jboss.VDBMetadataMapper;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.jboss.OperationsConstants;
import org.teiid.jboss.TeiidOperationHandler;
import org.teiid.vdb.runtime.VDBKey;

class ListSessions
extends TeiidOperationHandler {
    protected ListSessions() {
        super("list-sessions");
    }

    @Override
    protected void executeOperation(OperationContext context, DQPCore engine, ModelNode operation) throws OperationFailedException {
        VDBMetaData metadata;
        String vdbName = null;
        String version = null;
        VDBKey vdbKey = null;
        if (operation.hasDefined(OperationsConstants.OPTIONAL_VDB_VERSION.getName()) && operation.hasDefined(OperationsConstants.OPTIONAL_VDB_NAME.getName()) && (vdbKey = (VDBKey)(metadata = ListSessions.checkVDB(context, vdbName = operation.get(OperationsConstants.OPTIONAL_VDB_NAME.getName()).asString(), version = operation.get(OperationsConstants.OPTIONAL_VDB_VERSION.getName()).asString())).getAttachment(VDBKey.class)) == null) {
            vdbKey = new VDBKey(vdbName, (Object)version);
        }
        ModelNode result = context.getResult();
        Collection sessions = null;
        sessions = vdbKey != null ? this.getSessionService(context).getSessionsLoggedInToVDB(vdbKey) : this.getSessionService(context).getActiveSessions();
        for (SessionMetadata session : sessions) {
            VDBMetadataMapper.SessionMetadataMapper.INSTANCE.wrap(session, result.add());
        }
    }

    @Override
    protected void describeParameters(SimpleOperationDefinitionBuilder builder) {
        builder.addParameter((AttributeDefinition)OperationsConstants.OPTIONAL_VDB_NAME);
        builder.addParameter((AttributeDefinition)OperationsConstants.OPTIONAL_VDB_VERSION);
        builder.setReplyType(ModelType.LIST);
        builder.setReplyParameters(VDBMetadataMapper.SessionMetadataMapper.INSTANCE.getAttributeDefinitions());
    }
}

