/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.jboss.VDBMetadataMapper;
import org.teiid.deployers.VDBRepository;
import org.teiid.jboss.BaseOperationHandler;
import org.teiid.jboss.OperationsConstants;
import org.teiid.jboss.TeiidServiceNames;

class ListVDBs
extends BaseOperationHandler<VDBRepository> {
    protected ListVDBs() {
        super("list-vdbs");
    }

    @Override
    protected VDBRepository getService(OperationContext context, PathAddress pathAddress, ModelNode operation) throws OperationFailedException {
        ServiceController sc = context.getServiceRegistry(false).getRequiredService(TeiidServiceNames.VDB_REPO);
        return (VDBRepository)VDBRepository.class.cast(sc.getValue());
    }

    @Override
    protected void executeOperation(OperationContext context, VDBRepository repo, ModelNode operation) throws OperationFailedException {
        boolean includeSchema = true;
        if (operation.hasDefined(OperationsConstants.INCLUDE_SCHEMA.getName())) {
            includeSchema = operation.get(OperationsConstants.INCLUDE_SCHEMA.getName()).asBoolean();
        }
        ModelNode result = context.getResult();
        List vdbs = repo.getVDBs();
        for (VDBMetaData vdb : vdbs) {
            VDBMetadataMapper.INSTANCE.wrap(vdb, result.add(), includeSchema);
        }
    }

    @Override
    protected void describeParameters(SimpleOperationDefinitionBuilder builder) {
        builder.addParameter((AttributeDefinition)OperationsConstants.INCLUDE_SCHEMA);
        builder.setReplyType(ModelType.LIST);
        builder.setReplyParameters(VDBMetadataMapper.INSTANCE.getAttributeDefinitions());
    }
}

