/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.concurrent.ScheduledExecutorService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.teiid.deployers.VDBLifeCycleListener;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.jboss.JBossLifeCycleListener;
import org.teiid.jboss.NodeTracker;
import org.teiid.runtime.MaterializationManager;
import org.teiid.runtime.NodeListener;

class MaterializationManagementService
implements Service<MaterializationManager> {
    private ScheduledExecutorService scheduler;
    private MaterializationManager manager;
    protected final InjectedValue<DQPCore> dqpInjector = new InjectedValue();
    protected final InjectedValue<VDBRepository> vdbRepositoryInjector = new InjectedValue();
    protected final InjectedValue<NodeTracker> nodeTrackerInjector = new InjectedValue();
    private JBossLifeCycleListener shutdownListener;

    public MaterializationManagementService(JBossLifeCycleListener shutdownListener, ScheduledExecutorService scheduler) {
        this.shutdownListener = shutdownListener;
        this.scheduler = scheduler;
    }

    public void start(StartContext context) throws StartException {
        this.manager = new MaterializationManager(this.shutdownListener){

            public ScheduledExecutorService getScheduledExecutorService() {
                return MaterializationManagementService.this.scheduler;
            }

            public DQPCore getDQP() {
                return (DQPCore)MaterializationManagementService.this.dqpInjector.getValue();
            }

            public VDBRepository getVDBRepository() {
                return (VDBRepository)MaterializationManagementService.this.vdbRepositoryInjector.getValue();
            }
        };
        ((VDBRepository)this.vdbRepositoryInjector.getValue()).addListener((VDBLifeCycleListener)this.manager);
        if (this.nodeTrackerInjector.getValue() != null) {
            ((NodeTracker)((Object)this.nodeTrackerInjector.getValue())).addNodeListener((NodeListener)this.manager);
        }
    }

    public void stop(StopContext context) {
        this.scheduler.shutdownNow();
        ((VDBRepository)this.vdbRepositoryInjector.getValue()).removeListener((VDBLifeCycleListener)this.manager);
        NodeTracker value = (NodeTracker)((Object)this.nodeTrackerInjector.getValue());
        if (value != null) {
            value.removeNodeListener((NodeListener)this.manager);
        }
    }

    public MaterializationManager getValue() throws IllegalStateException, IllegalArgumentException {
        return this.manager;
    }
}

