/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.teiid.core.BundleUtil;
import org.teiid.logging.LogManager;
import org.teiid.runtime.NodeListener;
import org.teiid.runtime.RuntimePlugin;

public abstract class NodeTracker
extends ReceiverAdapter {
    private Map<Address, String> nodes = new HashMap<Address, String>();
    private JChannel channel;
    private String nodeName;
    private Set<NodeListener> nodeListeners = Collections.synchronizedSet(new HashSet());

    public abstract ScheduledExecutorService getScheduledExecutorService();

    public NodeTracker(JChannel channel, String nodeName) throws Exception {
        this.nodeName = nodeName;
        this.channel = channel;
        this.channel.setReceiver((Receiver)this);
        this.channel.connect("teiid-node-tracker");
    }

    public void addNodeListener(NodeListener nodeListener) {
        this.nodeListeners.add(nodeListener);
    }

    public void removeNodeListener(NodeListener nodeListener) {
        this.nodeListeners.remove(nodeListener);
    }

    public boolean isNodeAlive(String nodeName) {
        if (this.nodeName.equalsIgnoreCase(nodeName)) {
            return true;
        }
        return this.nodes.values().contains(nodeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void viewAccepted(View view) {
        HashMap<Address, String> newMembers = new HashMap<Address, String>();
        Map<Address, String> deadMembers = null;
        if (view.getMembers() != null && !this.nodes.isEmpty()) {
            Map<Address, String> map = this.nodes;
            synchronized (map) {
                for (Address addr : view.getMembers()) {
                    String name = this.nodes.remove(addr);
                    if (name == null) continue;
                    newMembers.put(addr, name);
                }
                deadMembers = this.nodes;
                this.nodes = newMembers;
            }
            if (!deadMembers.isEmpty()) {
                for (String name : deadMembers.values()) {
                    if (this.nodeListeners.isEmpty()) continue;
                    for (NodeListener nl : this.nodeListeners) {
                        nl.nodeDropped(name);
                    }
                }
            }
        }
        this.getScheduledExecutorService().schedule(new Runnable(){

            @Override
            public void run() {
                Message msg = new Message(null, (Object)NodeTracker.this.nodeName);
                try {
                    NodeTracker.this.channel.send(msg);
                }
                catch (Exception e) {
                    LogManager.logError((String)"org.teiid.RUNTIME", (Throwable)e, (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40165, new Object[0]));
                }
            }
        }, 2000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(Message msg) {
        Map<Address, String> map = this.nodes;
        synchronized (map) {
            String prevNode = this.nodes.put(msg.getSrc(), (String)msg.getObject());
            if (prevNode == null) {
                for (NodeListener nl : this.nodeListeners) {
                    nl.nodeJoined((String)msg.getObject());
                }
            }
        }
    }
}

