/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.metadata.property.PropertyReplacers;
import org.jboss.metadata.property.PropertyResolver;
import org.jboss.msc.service.ServiceController;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBMetadataParser;
import org.teiid.core.BundleUtil;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.StringUtil;
import org.teiid.deployers.VDBRepository;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.ObjectSerializer;
import org.teiid.jboss.TeiidAttachments;
import org.teiid.jboss.TeiidServiceNames;
import org.teiid.logging.LogManager;
import org.teiid.metadatastore.DeploymentBasedDatabaseStore;
import org.xml.sax.SAXException;

class VDBParserDeployer
implements DeploymentUnitProcessor {
    private VDBRepository vdbRepo;

    public VDBParserDeployer(VDBRepository vdbRepo) {
        this.vdbRepo = vdbRepo;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!TeiidAttachments.isVDBDeployment(deploymentUnit)) {
            return;
        }
        VirtualFile file = ((ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
        if (TeiidAttachments.isVDBXMLDeployment(deploymentUnit)) {
            this.parseVDBXML(file, deploymentUnit, phaseContext, true);
        } else if (TeiidAttachments.isVDBDDLDeployment(deploymentUnit)) {
            this.parseVDBDDL(file, deploymentUnit, phaseContext, true);
        } else {
            try {
                file.getChildrenRecursively(new VirtualFileFilter(){

                    public boolean accepts(VirtualFile file) {
                        if (file.isDirectory()) {
                            return false;
                        }
                        return false;
                    }
                });
                VirtualFile vdbXml = file.getChild("/META-INF/vdb.xml");
                VirtualFile vdbDDL = file.getChild("/META-INF/vdb.ddl");
                if (!vdbXml.exists() && !vdbDDL.exists()) {
                    throw new DeploymentUnitProcessingException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50101, new Object[]{deploymentUnit}));
                }
                if (vdbXml.exists()) {
                    this.parseVDBXML(vdbXml, deploymentUnit, phaseContext, false);
                } else {
                    this.parseVDBDDL(vdbDDL, deploymentUnit, phaseContext, false);
                }
                this.mergeMetaData(deploymentUnit);
            }
            catch (IOException e) {
                throw new DeploymentUnitProcessingException(IntegrationPlugin.Event.TEIID50017.name(), (Throwable)e);
            }
        }
    }

    private VDBMetaData parseVDBXML(VirtualFile file, DeploymentUnit deploymentUnit, DeploymentPhaseContext phaseContext, boolean xmlDeployment) throws DeploymentUnitProcessingException {
        try {
            VDBMetadataParser.validate((InputStream)file.openStream());
            PropertyResolver propertyResolver = (PropertyResolver)deploymentUnit.getAttachment(org.jboss.as.ee.metadata.property.Attachments.FINAL_PROPERTY_RESOLVER);
            PropertyReplacer replacer = PropertyReplacers.resolvingReplacer((PropertyResolver)propertyResolver);
            String vdbContents = replacer.replaceProperties(ObjectConverterUtil.convertToString((InputStream)file.openStream()));
            VDBMetaData vdb = VDBMetadataParser.unmarshell((InputStream)new ByteArrayInputStream(vdbContents.getBytes("UTF-8")));
            ServiceController sc = phaseContext.getServiceRegistry().getService(TeiidServiceNames.OBJECT_SERIALIZER);
            ObjectSerializer serializer = (ObjectSerializer)ObjectSerializer.class.cast(sc.getValue());
            if (serializer.buildVdbXml(vdb).exists()) {
                vdb = VDBMetadataParser.unmarshell((InputStream)new FileInputStream(serializer.buildVdbXml(vdb)));
            }
            vdb.setStatus(VDB.Status.LOADING);
            if (xmlDeployment) {
                vdb.setXmlDeployment(true);
            } else {
                String name = deploymentUnit.getName();
                String fileName = StringUtil.getLastToken((String)name, (String)"/");
                int index = fileName.indexOf(46);
                int lastIndex = fileName.lastIndexOf(46);
                if (index > 0 && index != lastIndex && fileName.substring(0, index).equals(vdb.getName())) {
                    vdb.setVersion(name.substring(index + 1, lastIndex));
                }
            }
            deploymentUnit.putAttachment(TeiidAttachments.VDB_METADATA, (Object)vdb);
            LogManager.logDetail((String)"org.teiid.RUNTIME", (Object)("VDB " + file.getName() + " has been parsed."));
            return vdb;
        }
        catch (XMLStreamException e) {
            throw new DeploymentUnitProcessingException(IntegrationPlugin.Event.TEIID50017.name(), (Throwable)e);
        }
        catch (IOException e) {
            throw new DeploymentUnitProcessingException(IntegrationPlugin.Event.TEIID50017.name(), (Throwable)e);
        }
        catch (SAXException e) {
            throw new DeploymentUnitProcessingException(IntegrationPlugin.Event.TEIID50017.name(), (Throwable)e);
        }
    }

    private VDBMetaData parseVDBDDL(VirtualFile file, DeploymentUnit deploymentUnit, DeploymentPhaseContext phaseContext, boolean xmlDeployment) throws DeploymentUnitProcessingException {
        try {
            PropertyReplacer replacer = (PropertyReplacer)deploymentUnit.getAttachment(org.jboss.as.ee.metadata.property.Attachments.FINAL_PROPERTY_REPLACER);
            String vdbContents = replacer.replaceProperties(ObjectConverterUtil.convertToString((InputStream)file.openStream()));
            ObjectSerializer serializer = (ObjectSerializer)ObjectSerializer.class.cast(phaseContext.getServiceRegistry().getService(TeiidServiceNames.OBJECT_SERIALIZER).getValue());
            DeploymentBasedDatabaseStore store = new DeploymentBasedDatabaseStore(this.vdbRepo);
            VDBMetaData vdb = store.getVDBMetadata(vdbContents);
            if (serializer.buildVdbXml(vdb).exists()) {
                vdb = VDBMetadataParser.unmarshell((InputStream)new FileInputStream(serializer.buildVdbXml(vdb)));
            }
            vdb.setStatus(VDB.Status.LOADING);
            vdb.setXmlDeployment(xmlDeployment);
            deploymentUnit.putAttachment(TeiidAttachments.VDB_METADATA, (Object)vdb);
            LogManager.logDetail((String)"org.teiid.RUNTIME", (Object)("VDB " + file.getName() + " has been parsed."));
            return vdb;
        }
        catch (XMLStreamException e) {
            throw new DeploymentUnitProcessingException(IntegrationPlugin.Event.TEIID50017.name(), (Throwable)e);
        }
        catch (IOException e) {
            throw new DeploymentUnitProcessingException(IntegrationPlugin.Event.TEIID50017.name(), (Throwable)e);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    protected VDBMetaData mergeMetaData(DeploymentUnit deploymentUnit) {
        VDBMetaData vdb = (VDBMetaData)deploymentUnit.getAttachment(TeiidAttachments.VDB_METADATA);
        VirtualFile file = ((ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
        if (vdb == null) {
            LogManager.logError((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50016, new Object[]{file.getName()}));
            return null;
        }
        LogManager.logTrace((String)"org.teiid.RUNTIME", (Object)"VDB", (Object)file.getName(), (Object)"has been parsed.");
        return vdb;
    }
}

