/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.accumulo;

import java.util.List;
import javax.resource.ResourceException;
import javax.security.auth.Subject;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.ConnectorImpl;
import org.apache.accumulo.core.client.impl.Credentials;
import org.apache.accumulo.core.client.impl.ServerClient;
import org.apache.accumulo.core.client.impl.thrift.ClientService;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.Pair;
import org.apache.thrift.transport.TTransportException;
import org.teiid.core.util.StringUtil;
import org.teiid.resource.adapter.accumulo.AccumuloManagedConnectionFactory;
import org.teiid.resource.spi.BasicConnection;
import org.teiid.resource.spi.BasicManagedConnectionFactory;
import org.teiid.resource.spi.ConnectionContext;
import org.teiid.translator.accumulo.AccumuloConnection;

public class AccumuloConnectionImpl
extends BasicConnection
implements AccumuloConnection {
    private ConnectorImpl conn;
    private String[] roles;

    public AccumuloConnectionImpl(AccumuloManagedConnectionFactory mcf, ZooKeeperInstance inst) throws ResourceException {
        try {
            if (mcf.getRoles() != null) {
                List auths = StringUtil.getTokens((String)mcf.getRoles(), (String)",");
                this.roles = auths.toArray(new String[auths.size()]);
            }
            String userName = mcf.getUsername();
            String password = mcf.getPassword();
            Subject subject = ConnectionContext.getSubject();
            if (subject != null) {
                userName = ConnectionContext.getUserName((Subject)subject, (BasicManagedConnectionFactory)mcf, (String)userName);
                password = ConnectionContext.getPassword((Subject)subject, (BasicManagedConnectionFactory)mcf, (String)userName, (String)password);
                this.roles = ConnectionContext.getRoles((Subject)subject, (String[])this.roles);
            }
            this.checkTabletServerExists(inst, userName, password);
            this.conn = (ConnectorImpl)inst.getConnector(userName, (AuthenticationToken)new PasswordToken((CharSequence)password));
        }
        catch (AccumuloException e) {
            throw new ResourceException((Throwable)e);
        }
        catch (AccumuloSecurityException e) {
            throw new ResourceException((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkTabletServerExists(ZooKeeperInstance inst, String userName, String password) throws ResourceException {
        ClientService.Client client = null;
        try {
            Pair pair = ServerClient.getConnection((ClientContext)new ClientContext((Instance)inst, new Credentials(userName, (AuthenticationToken)new PasswordToken((CharSequence)password)), inst.getConfiguration()), (boolean)true, (long)10L);
            client = (ClientService.Client)pair.getSecond();
            if (client == null) return;
        }
        catch (TTransportException e) {
            try {
                throw new ResourceException(AccumuloManagedConnectionFactory.UTIL.getString("no_tserver"), (Throwable)e);
            }
            catch (Throwable throwable) {
                if (client == null) throw throwable;
                ServerClient.close(client);
                throw throwable;
            }
        }
        ServerClient.close((ClientService.Client)client);
        return;
    }

    public Connector getInstance() {
        return this.conn;
    }

    public void close() throws ResourceException {
    }

    public Authorizations getAuthorizations() {
        if (this.roles != null && this.roles.length > 0) {
            return new Authorizations(this.roles);
        }
        return new Authorizations();
    }
}

