/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.accumulo;

import javax.resource.ResourceException;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.teiid.core.BundleUtil;
import org.teiid.resource.adapter.accumulo.AccumuloConnectionImpl;
import org.teiid.resource.spi.BasicConnectionFactory;
import org.teiid.resource.spi.BasicManagedConnectionFactory;

public class AccumuloManagedConnectionFactory
extends BasicManagedConnectionFactory {
    private static final long serialVersionUID = 1608787576847881344L;
    public static final BundleUtil UTIL = BundleUtil.getBundleUtil(AccumuloManagedConnectionFactory.class);
    private String instanceName;
    private String zooKeeperServerList;
    private String username;
    private String password;
    private String roles;

    public BasicConnectionFactory<AccumuloConnectionImpl> createConnectionFactory() throws ResourceException {
        return new AccumuloConnectionFactory(this);
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getZooKeeperServerList() {
        return this.zooKeeperServerList;
    }

    public void setZooKeeperServerList(String zooKeeperServerList) {
        this.zooKeeperServerList = zooKeeperServerList;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRoles() {
        return this.roles;
    }

    public void setRoles(String roles) {
        this.roles = roles;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.instanceName == null ? 0 : this.instanceName.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.roles == null ? 0 : this.roles.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        result = 31 * result + (this.zooKeeperServerList == null ? 0 : this.zooKeeperServerList.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AccumuloManagedConnectionFactory other = (AccumuloManagedConnectionFactory)((Object)obj);
        if (this.instanceName == null ? other.instanceName != null : !this.instanceName.equals(other.instanceName)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.roles == null ? other.roles != null : !this.roles.equals(other.roles)) {
            return false;
        }
        if (this.username == null ? other.username != null : !this.username.equals(other.username)) {
            return false;
        }
        return !(this.zooKeeperServerList == null ? other.zooKeeperServerList != null : !this.zooKeeperServerList.equals(other.zooKeeperServerList));
    }

    class AccumuloConnectionFactory
    extends BasicConnectionFactory<AccumuloConnectionImpl> {
        private static final long serialVersionUID = 831361159531236916L;
        private ZooKeeperInstance instance;
        private AccumuloManagedConnectionFactory mcf;

        public AccumuloConnectionFactory(AccumuloManagedConnectionFactory mcf) {
            this.mcf = mcf;
            this.instance = new ZooKeeperInstance(mcf.getInstanceName(), mcf.getZooKeeperServerList());
        }

        public AccumuloConnectionImpl getConnection() throws ResourceException {
            return new AccumuloConnectionImpl(this.mcf, this.instance);
        }
    }
}

