/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.infinispan.hotrod;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.TeiidComponentException;
import org.teiid.infinispan.api.DocumentFilter;
import org.teiid.language.NamedTable;
import org.teiid.metadata.Column;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.util.CommandContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.infinispan.hotrod.IckleConversionVisitor;
import org.teiid.translator.infinispan.hotrod.MarshallerBuilder;
import org.teiid.translator.infinispan.hotrod.ProtobufMetadataProcessor;

public class ComplexDocumentFilter
implements DocumentFilter {
    private NamedTable parentTable;
    private NamedTable childTable;
    private Criteria criteria;
    private RuntimeMetadata metadata;
    private Map<ElementSymbol, Integer> elementMap = new HashMap<ElementSymbol, Integer>();
    private DocumentFilter.Action action;

    public ComplexDocumentFilter(NamedTable parentTable, NamedTable childTable, RuntimeMetadata metadata, String filter, DocumentFilter.Action action) throws TranslatorException {
        GroupSymbol gs;
        this.parentTable = parentTable;
        this.childTable = childTable;
        this.metadata = metadata;
        this.action = action;
        int i = 0;
        for (Column column : parentTable.getMetadataObject().getColumns()) {
            gs = new GroupSymbol(parentTable.getCorrelationName());
            gs.setMetadataID((Object)parentTable.getMetadataObject());
            this.elementMap.put(new ElementSymbol(column.getName(), gs), i++);
        }
        for (Column column : childTable.getMetadataObject().getColumns()) {
            gs = new GroupSymbol(childTable.getCorrelationName());
            gs.setMetadataID((Object)childTable.getMetadataObject());
            this.elementMap.put(new ElementSymbol(column.getName(), gs), i++);
        }
        try {
            this.criteria = QueryParser.getQueryParser().parseCriteria(filter);
        }
        catch (QueryParserException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public boolean matches(Map<String, Object> parentProperties, Map<String, Object> childProperties) throws TranslatorException {
        try {
            ArrayList<Object> tuple = new ArrayList<Object>();
            int i = 0;
            for (Column column : this.parentTable.getMetadataObject().getColumns()) {
                tuple.add(i++, parentProperties.get(MarshallerBuilder.getDocumentAttributeName(column, false, this.metadata)));
            }
            for (Column column : this.childTable.getMetadataObject().getColumns()) {
                if (ProtobufMetadataProcessor.isPseudo(column)) {
                    Column parentColumn = IckleConversionVisitor.normalizePseudoColumn(column, this.metadata);
                    tuple.add(i++, parentProperties.get(MarshallerBuilder.getDocumentAttributeName(parentColumn, false, this.metadata)));
                    continue;
                }
                tuple.add(i++, childProperties.get(MarshallerBuilder.getDocumentAttributeName(column, true, this.metadata)));
            }
            CommandContext cc = new CommandContext();
            Evaluator evaluator = new Evaluator(this.elementMap, null, cc);
            return evaluator.evaluate(this.criteria, tuple);
        }
        catch (ExpressionEvaluationException e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (BlockedException e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (TeiidComponentException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public DocumentFilter.Action action() {
        return this.action;
    }
}

