/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.infinispan.hotrod;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.teiid.core.BundleUtil;
import org.teiid.language.AggregateFunction;
import org.teiid.language.ColumnReference;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.language.DerivedColumn;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.Join;
import org.teiid.language.LanguageObject;
import org.teiid.language.Limit;
import org.teiid.language.NamedTable;
import org.teiid.language.Select;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.document.DocumentNode;
import org.teiid.translator.infinispan.hotrod.InfinispanPlugin;
import org.teiid.translator.infinispan.hotrod.MarshallerBuilder;
import org.teiid.translator.infinispan.hotrod.ProtobufMetadataProcessor;

public class IckleConversionVisitor
extends SQLStringVisitor {
    protected ArrayList<TranslatorException> exceptions = new ArrayList();
    protected RuntimeMetadata metadata;
    protected List<Expression> projectedExpressions = new ArrayList<Expression>();
    protected NamedTable parentTable;
    protected NamedTable queriedTable;
    private Integer rowLimit;
    private Integer rowOffset;
    private boolean includePK;
    protected boolean avoidProjection = false;
    private DocumentNode rootNode;
    private DocumentNode joinedNode;
    private LinkedHashMap<String, Class<?>> projectedDocumentAttributes = new LinkedHashMap();
    private AtomicInteger aliasCounter = new AtomicInteger();
    protected boolean nested;

    public IckleConversionVisitor(RuntimeMetadata metadata, boolean includePK) {
        this.metadata = metadata;
        this.includePK = includePK;
        this.shortNameOnly = true;
    }

    public Table getParentTable() {
        return this.parentTable.getMetadataObject();
    }

    public NamedTable getParentNamedTable() {
        return this.parentTable;
    }

    public Table getQueryTable() {
        return this.queriedTable.getMetadataObject();
    }

    public NamedTable getQueryNamedTable() {
        return this.queriedTable;
    }

    public boolean isNestedOperation() {
        return this.nested;
    }

    public void visit(NamedTable obj) {
        this.queriedTable = obj;
        if (obj.getCorrelationName() == null) {
            obj.setCorrelationName(obj.getMetadataObject().getName().toLowerCase() + "_" + this.aliasCounter.getAndIncrement());
        }
        if (this.rootNode == null) {
            KeyRecord pk;
            String messageName = null;
            String aliasName = null;
            String mergedTableName = ProtobufMetadataProcessor.getMerge(obj.getMetadataObject());
            if (mergedTableName == null) {
                aliasName = obj.getCorrelationName();
                messageName = this.getMessageName(obj.getMetadataObject());
                this.parentTable = obj;
                this.joinedNode = this.rootNode = new DocumentNode(obj.getMetadataObject(), true);
                HashSet<String> tags = new HashSet<String>();
                for (Column column : obj.getMetadataObject().getColumns()) {
                    String childMessageName;
                    if (ProtobufMetadataProcessor.getParentTag(column) == -1 || tags.contains(childMessageName = ProtobufMetadataProcessor.getMessageName(column))) continue;
                    tags.add(childMessageName);
                    Table t = new Table();
                    t.setName(childMessageName);
                    this.joinedNode = this.rootNode.joinWith(Join.JoinType.INNER_JOIN, new DocumentNode(t, false));
                }
            } else {
                try {
                    Table mergedTable = this.metadata.getTable(mergedTableName);
                    messageName = this.getMessageName(mergedTable);
                    aliasName = mergedTable.getName().toLowerCase() + "_" + this.aliasCounter.getAndIncrement();
                    this.parentTable = new NamedTable(mergedTable.getName(), aliasName, mergedTable);
                    this.rootNode = new DocumentNode(mergedTable, true);
                    this.joinedNode = this.rootNode.joinWith(Join.JoinType.INNER_JOIN, new DocumentNode(obj.getMetadataObject(), true));
                    this.nested = true;
                }
                catch (TranslatorException e) {
                    this.exceptions.add(e);
                }
            }
            this.buffer.append(messageName);
            if (aliasName != null) {
                this.buffer.append(" ");
                this.buffer.append(aliasName);
            }
            if (this.includePK && (pk = this.parentTable.getMetadataObject().getPrimaryKey()) != null) {
                for (Column column : pk.getColumns()) {
                    this.projectedExpressions.add((Expression)new ColumnReference(obj, column.getName(), column, column.getJavaType()));
                }
            }
        }
    }

    private String getMessageName(Table obj) {
        String messageName = ProtobufMetadataProcessor.getMessageName(obj);
        if (messageName == null) {
            messageName = obj.getName();
        }
        return messageName;
    }

    public boolean isPartOfPrimaryKey(String columnName) {
        KeyRecord pk = this.getParentTable().getPrimaryKey();
        if (pk != null) {
            for (Column column : pk.getColumns()) {
                if (!column.getName().equals(columnName)) continue;
                return true;
            }
        }
        return false;
    }

    public void visit(Join obj) {
        Condition cond = null;
        if (obj.getLeftItem() instanceof Join) {
            cond = obj.getCondition();
            this.append((LanguageObject)obj.getLeftItem());
            Table right = ((NamedTable)obj.getRightItem()).getMetadataObject();
            this.joinedNode.joinWith(obj.getJoinType(), new DocumentNode(right, true));
        } else if (obj.getRightItem() instanceof Join) {
            cond = obj.getCondition();
            this.append((LanguageObject)obj.getRightItem());
            Table left = ((NamedTable)obj.getLeftItem()).getMetadataObject();
            this.joinedNode.joinWith(obj.getJoinType(), new DocumentNode(left, true));
        } else {
            cond = obj.getCondition();
            this.append((LanguageObject)obj.getLeftItem());
            this.queriedTable = (NamedTable)obj.getRightItem();
            Table right = ((NamedTable)obj.getRightItem()).getMetadataObject();
            this.joinedNode.joinWith(obj.getJoinType(), new DocumentNode(right, true));
        }
        if (cond != null) {
            this.append((LanguageObject)cond);
        }
    }

    public void visit(Limit obj) {
        if (obj.getRowOffset() != 0) {
            this.rowOffset = new Integer(obj.getRowOffset());
        }
        if (obj.getRowLimit() != 0) {
            this.rowLimit = new Integer(obj.getRowLimit());
        }
    }

    public void visit(Select obj) {
        this.buffer.append("FROM").append(" ");
        this.visitNodes(obj.getFrom());
        if (obj.getWhere() != null) {
            this.buffer.append(" ");
            this.buffer.append("WHERE").append(" ");
            this.visitNode((LanguageObject)obj.getWhere());
        }
        if (obj.getGroupBy() != null) {
            this.buffer.append(" ");
            this.append((LanguageObject)obj.getGroupBy());
        }
        if (obj.getHaving() != null) {
            this.buffer.append(" ").append("HAVING").append(" ");
            this.append((LanguageObject)obj.getHaving());
        }
        if (obj.getOrderBy() != null) {
            this.buffer.append(" ");
            this.visitNode((LanguageObject)obj.getOrderBy());
            if (this.nested) {
                this.exceptions.add(new TranslatorException(InfinispanPlugin.Util.gs((BundleUtil.Event)InfinispanPlugin.Event.TEIID25010, new Object[0])));
            }
        }
        if (obj.getLimit() != null) {
            this.buffer.append(" ");
            this.visitNode((LanguageObject)obj.getLimit());
        }
        this.visitNodes(obj.getDerivedColumns());
    }

    public void visit(Comparison obj) {
        if (obj.getOperator() == Comparison.Operator.EQ && obj.getLeftExpression() instanceof ColumnReference && obj.getRightExpression() instanceof ColumnReference) {
            Column left = ((ColumnReference)obj.getLeftExpression()).getMetadataObject();
            Column right = ((ColumnReference)obj.getRightExpression()).getMetadataObject();
            if (this.getQualifiedName(left).equals(this.getQualifiedName(right))) {
                return;
            }
        }
        super.visit(obj);
    }

    public void visit(ColumnReference obj) {
        this.buffer.append(this.getQualifiedName(obj.getMetadataObject()));
    }

    public void visit(DerivedColumn obj) {
        if (obj.getExpression() instanceof ColumnReference) {
            Column column = ((ColumnReference)obj.getExpression()).getMetadataObject();
            if (!column.isSelectable()) {
                this.exceptions.add(new TranslatorException(InfinispanPlugin.Util.gs((BundleUtil.Event)InfinispanPlugin.Event.TEIID25001, new Object[]{column.getName()})));
            }
            try {
                column = IckleConversionVisitor.normalizePseudoColumn(column, this.metadata);
            }
            catch (TranslatorException e1) {
                this.exceptions.add(e1);
            }
            if (!this.includePK || !this.isPartOfPrimaryKey(column.getName())) {
                if (column.getParent().equals((Object)this.parentTable.getMetadataObject())) {
                    this.projectedExpressions.add((Expression)new ColumnReference(this.parentTable, column.getName(), column, column.getJavaType()));
                } else {
                    this.projectedExpressions.add((Expression)new ColumnReference(this.queriedTable, column.getName(), column, column.getJavaType()));
                }
            }
            boolean nested = false;
            if (ProtobufMetadataProcessor.getParentTag(column) != -1 || ProtobufMetadataProcessor.getParentTag((Table)column.getParent()) != -1) {
                this.avoidProjection = true;
                nested = true;
            }
            try {
                this.projectedDocumentAttributes.put(MarshallerBuilder.getDocumentAttributeName(column, nested, this.metadata), column.getJavaType());
            }
            catch (TranslatorException e) {
                this.exceptions.add(e);
            }
        } else if (obj.getExpression() instanceof Function) {
            if (!this.parentTable.equals(this.queriedTable)) {
                this.exceptions.add(new TranslatorException((BundleUtil.Event)InfinispanPlugin.Event.TEIID25008, InfinispanPlugin.Util.gs((BundleUtil.Event)InfinispanPlugin.Event.TEIID25008, new Object[0])));
            }
            AggregateFunction func = (AggregateFunction)obj.getExpression();
            this.projectedExpressions.add((Expression)func);
            this.projectedDocumentAttributes.put(obj.getAlias(), func.getType());
        } else {
            this.exceptions.add(new TranslatorException(InfinispanPlugin.Util.gs((BundleUtil.Event)InfinispanPlugin.Event.TEIID25002, new Object[]{obj})));
        }
    }

    static Column normalizePseudoColumn(Column column, RuntimeMetadata metadata) throws TranslatorException {
        String pseudo = ProtobufMetadataProcessor.getPseudo(column);
        if (pseudo != null) {
            Table columnParent = (Table)column.getParent();
            Table pseudoColumnParent = metadata.getTable(ProtobufMetadataProcessor.getMerge(columnParent));
            return pseudoColumnParent.getColumnByName(IckleConversionVisitor.getRecordName((AbstractMetadataRecord)column));
        }
        return column;
    }

    public String getQuery() {
        StringBuilder sb = new StringBuilder();
        if (!this.avoidProjection) {
            this.addSelectedColumns(sb);
            sb.append(" ");
        }
        sb.append(super.toString());
        return sb.toString();
    }

    String getQualifiedName(Column column) {
        String aliasName = this.parentTable.getCorrelationName();
        String nis = this.getName((AbstractMetadataRecord)column);
        String parentName = ProtobufMetadataProcessor.getParentColumnName(column);
        if (parentName == null && !ProtobufMetadataProcessor.isPseudo(column)) {
            parentName = ProtobufMetadataProcessor.getParentColumnName((Table)column.getParent());
        }
        if (parentName != null) {
            nis = parentName + "." + nis;
        }
        if (aliasName != null) {
            return aliasName + "." + nis;
        }
        return nis;
    }

    StringBuilder addSelectedColumns(StringBuilder sb) {
        sb.append("SELECT").append(" ");
        boolean first = true;
        for (Expression expr : this.projectedExpressions) {
            if (!first) {
                sb.append(",").append(" ");
            }
            if (expr instanceof ColumnReference) {
                Column column = ((ColumnReference)expr).getMetadataObject();
                String nis = this.getQualifiedName(column);
                sb.append(nis);
            } else if (expr instanceof Function) {
                Function func = (Function)expr;
                sb.append(func.getName()).append("(");
                if (func.getParameters().isEmpty() && "COUNT".equalsIgnoreCase(func.getName())) {
                    sb.append("*");
                } else {
                    ColumnReference columnRef = (ColumnReference)func.getParameters().get(0);
                    Column column = columnRef.getMetadataObject();
                    String nis = this.getQualifiedName(column);
                    sb.append(nis);
                }
                sb.append(")");
            }
            first = false;
        }
        return sb;
    }

    public Integer getRowLimit() {
        return this.rowLimit;
    }

    public Integer getRowOffset() {
        return this.rowOffset;
    }

    protected boolean useAsInGroupAlias() {
        return false;
    }

    public Map<String, Class<?>> getProjectedDocumentAttributes() throws TranslatorException {
        return this.projectedDocumentAttributes;
    }

    RuntimeMetadata getMetadata() {
        return this.metadata;
    }

    DocumentNode getDocumentNode() {
        return this.rootNode;
    }
}

