/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.infinispan.hotrod;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.infinispan.commons.api.BasicCache;
import org.teiid.core.BundleUtil;
import org.teiid.infinispan.api.InfinispanConnection;
import org.teiid.language.Argument;
import org.teiid.language.Command;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.infinispan.hotrod.InfinispanExecutionFactory;
import org.teiid.translator.infinispan.hotrod.InfinispanPlugin;
import org.teiid.translator.infinispan.hotrod.ProtobufMetadataProcessor;

public class InfinispanDirectQueryExecution
implements ProcedureExecution {
    private static Pattern truncatePattern = Pattern.compile("truncate (\\S+)");
    private static Pattern renamePattern = Pattern.compile("rename (\\S+)\\s+(\\S+)");
    protected int columnCount;
    private List<Argument> arguments;
    protected int updateCount = -1;
    private InfinispanConnection connection;
    private ExecutionContext context;
    private RuntimeMetadata metadata;

    public InfinispanDirectQueryExecution(List<Argument> arguments, Command command, ExecutionContext context, RuntimeMetadata metadata, InfinispanConnection connection) {
        this.arguments = arguments;
        this.connection = connection;
        this.context = context;
        this.metadata = metadata;
    }

    public void execute() throws TranslatorException {
        String command = (String)this.arguments.get(0).getArgumentValue().getValue();
        BasicCache<String, String> aliasCache = InfinispanDirectQueryExecution.getAliasCache(this.connection);
        Matcher m = truncatePattern.matcher(command);
        if (m.matches()) {
            String tableName = m.group(1);
            this.clearContents(aliasCache, tableName);
            return;
        }
        m = renamePattern.matcher(command);
        if (m.matches()) {
            String tableOne = m.group(1);
            String tableTwo = m.group(2);
            String aliasName = InfinispanDirectQueryExecution.getAliasName(this.context, aliasCache, tableOne);
            if (aliasName.equals(tableOne)) {
                aliasCache.put((Object)InfinispanDirectQueryExecution.fqn(this.context, tableTwo), (Object)tableOne);
                aliasCache.put((Object)InfinispanDirectQueryExecution.fqn(this.context, tableOne), (Object)tableTwo);
            } else if (aliasName.equals(tableTwo)) {
                aliasCache.put((Object)InfinispanDirectQueryExecution.fqn(this.context, tableOne), (Object)tableOne);
                aliasCache.put((Object)InfinispanDirectQueryExecution.fqn(this.context, tableTwo), (Object)tableTwo);
            } else {
                throw new TranslatorException((BundleUtil.Event)InfinispanPlugin.Event.TEIID25015, InfinispanPlugin.Util.gs((BundleUtil.Event)InfinispanPlugin.Event.TEIID25015, new Object[]{tableOne, aliasName}));
            }
            return;
        }
        throw new TranslatorException((BundleUtil.Event)InfinispanPlugin.Event.TEIID25016, InfinispanPlugin.Util.gs((BundleUtil.Event)InfinispanPlugin.Event.TEIID25016, new Object[]{command}));
    }

    private void clearContents(BasicCache<String, String> aliasCache, String tableName) throws TranslatorException {
        Table table = this.metadata.getTable(tableName = InfinispanDirectQueryExecution.getAliasName(this.context, aliasCache, tableName));
        String cacheName = ProtobufMetadataProcessor.getCacheName(table);
        BasicCache cache = this.connection.getCache(cacheName, false);
        if (cache == null) {
            throw new TranslatorException((BundleUtil.Event)InfinispanPlugin.Event.TEIID25014, InfinispanPlugin.Util.gs((BundleUtil.Event)InfinispanPlugin.Event.TEIID25014, new Object[]{tableName}));
        }
        cache.clear();
    }

    static String getAliasName(ExecutionContext context, BasicCache<String, String> aliasCache, String alias) throws TranslatorException {
        String key = InfinispanDirectQueryExecution.fqn(context, alias);
        String value = (String)aliasCache.get((Object)key);
        if (value != null) {
            return value;
        }
        return alias;
    }

    static Table getAliasTable(ExecutionContext context, RuntimeMetadata metadata, BasicCache<String, String> aliasCache, Table table) throws TranslatorException {
        String alias = table.getFullName();
        String key = InfinispanDirectQueryExecution.fqn(context, alias);
        String value = (String)aliasCache.get((Object)key);
        alias = value != null ? value.substring(value.lastIndexOf(46) + 1) : alias.substring(alias.lastIndexOf(46) + 1);
        return metadata.getTable(((Schema)table.getParent()).getName(), alias);
    }

    static String fqn(ExecutionContext context, String key) {
        return context.getVdbName() + "." + context.getVdbVersion() + "." + key;
    }

    static BasicCache<String, String> getAliasCache(InfinispanConnection connection) throws TranslatorException {
        BasicCache cache = connection.getCache(InfinispanExecutionFactory.TEIID_ALIAS_NAMING_CACHE, true);
        if (cache == null) {
            throw new TranslatorException((BundleUtil.Event)InfinispanPlugin.Event.TEIID25014, InfinispanPlugin.Util.gs((BundleUtil.Event)InfinispanPlugin.Event.TEIID25014, new Object[]{InfinispanExecutionFactory.TEIID_ALIAS_NAMING_CACHE}));
        }
        return cache;
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        return null;
    }

    public List<?> getOutputParameterValues() throws TranslatorException {
        return null;
    }

    public void close() {
    }

    public void cancel() throws TranslatorException {
    }
}

