/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.infinispan.hotrod;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.infinispan.api.InfinispanConnection;
import org.teiid.infinispan.api.ProtobufResource;
import org.teiid.language.Argument;
import org.teiid.language.Command;
import org.teiid.language.QueryExpression;
import org.teiid.metadata.Column;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.resource.api.ConnectionFactory;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.infinispan.hotrod.InfinispanDirectQueryExecution;
import org.teiid.translator.infinispan.hotrod.InfinispanQueryExecution;
import org.teiid.translator.infinispan.hotrod.InfinispanUpdateExecution;
import org.teiid.translator.infinispan.hotrod.ProtobufMetadataProcessor;
import org.teiid.translator.infinispan.hotrod.SchemaToProtobufProcessor;

@Translator(name="infinispan-hotrod", description="The Infinispan Translator Using Protobuf & Hotrod")
public class InfinispanExecutionFactory
extends ExecutionFactory<ConnectionFactory, InfinispanConnection> {
    public static final int MAX_SET_SIZE = 1024;
    public static final String TEIID_ALIAS_NAMING_CACHE = PropertiesUtils.getHierarchicalProperty((String)"org.teiid.aliasCacheName", (String)"teiid-alias-naming-cache");
    private boolean supportsCompareCriteriaOrdered = true;
    private boolean supportsUpsert = true;
    private boolean supportsBulkUpdates = false;

    public InfinispanExecutionFactory() {
        this.setMaxInCriteriaSize(1024);
        this.setMaxDependentInPredicates(1024);
        this.setSupportsOrderBy(true);
        this.setSupportsSelectDistinct(false);
        this.setSupportsInnerJoins(true);
        this.setSupportsFullOuterJoins(true);
        this.setSupportsOuterJoins(true);
        this.setSupportedJoinCriteria(ExecutionFactory.SupportedJoinCriteria.KEY);
        this.setTransactionSupport(ExecutionFactory.TransactionSupport.NONE);
        this.setSourceRequiredForMetadata(true);
    }

    public void start() throws TranslatorException {
        super.start();
    }

    public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, InfinispanConnection connection) throws TranslatorException {
        return new InfinispanQueryExecution(this, command, executionContext, metadata, connection, this.supportsDirectQueryProcedure());
    }

    public UpdateExecution createUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, InfinispanConnection connection) throws TranslatorException {
        return new InfinispanUpdateExecution(command, executionContext, metadata, connection, this.supportsDirectQueryProcedure());
    }

    public ProcedureExecution createDirectExecution(List<Argument> arguments, Command command, ExecutionContext executionContext, RuntimeMetadata metadata, InfinispanConnection connection) throws TranslatorException {
        return new InfinispanDirectQueryExecution(arguments, command, executionContext, metadata, connection);
    }

    public void getMetadata(MetadataFactory metadataFactory, InfinispanConnection conn) throws TranslatorException {
        Object stpp;
        ProtobufMetadataProcessor metadataProcessor = (ProtobufMetadataProcessor)this.getMetadataProcessor();
        PropertiesUtils.setBeanProperties((Object)metadataProcessor, (Properties)metadataFactory.getModelProperties(), (String)"importer");
        Schema schema = metadataFactory.getSchema();
        ProtobufResource resource = null;
        ArrayList<Table> removedTables = new ArrayList<Table>();
        if (schema.getTables() != null && !schema.getTables().isEmpty()) {
            stpp = new SchemaToProtobufProcessor();
            ((SchemaToProtobufProcessor)stpp).setIndexMessages(true);
            resource = ((SchemaToProtobufProcessor)stpp).process(metadataFactory, conn);
            metadataProcessor.setProtobufResource(resource);
            ArrayList tables = new ArrayList(schema.getTables().values());
            for (Table t : tables) {
                removedTables.add(schema.removeTable(t.getName()));
            }
        }
        metadataProcessor.process(metadataFactory, conn);
        for (Table oldT : removedTables) {
            Table newT = schema.getTable(oldT.getName());
            Map properties = oldT.getProperties();
            for (Map.Entry entry : properties.entrySet()) {
                newT.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
            newT.setSupportsUpdate(oldT.supportsUpdate());
            if (oldT.getAnnotation() != null) {
                newT.setAnnotation(oldT.getAnnotation());
            }
            List columns = oldT.getColumns();
            for (Column c : columns) {
                Column newCol = newT.getColumnByName(c.getName());
                if (newCol == null) continue;
                Map colProperties = c.getProperties();
                for (Map.Entry entry : colProperties.entrySet()) {
                    newCol.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
                newCol.setUpdatable(c.isUpdatable());
                if (c.getAnnotation() == null) continue;
                newCol.setAnnotation(c.getAnnotation());
            }
        }
        resource = metadataProcessor.getProtobufResource();
        if (resource == null) {
            stpp = new SchemaToProtobufProcessor();
            resource = ((SchemaToProtobufProcessor)stpp).process(metadataFactory, conn);
        }
        if (resource != null) {
            conn.registerProtobufFile(resource);
        }
    }

    public MetadataProcessor<InfinispanConnection> getMetadataProcessor() {
        return new ProtobufMetadataProcessor();
    }

    public boolean isSourceRequiredForCapabilities() {
        return true;
    }

    public boolean supportsAliasedTable() {
        return true;
    }

    public boolean supportsInCriteria() {
        return true;
    }

    public boolean supportsIsNullCriteria() {
        return false;
    }

    public boolean supportsOrCriteria() {
        return true;
    }

    public boolean supportsCompareCriteriaEquals() {
        return true;
    }

    @TranslatorProperty(display="CompareCriteriaOrdered", description="If true, translator can support comparison criteria with the operator '=>' or '<=' ", advanced=true)
    public boolean supportsCompareCriteriaOrdered() {
        return this.supportsCompareCriteriaOrdered;
    }

    public boolean setSupportsCompareCriteriaOrdered(boolean supports) {
        this.supportsCompareCriteriaOrdered = supports;
        return this.supportsCompareCriteriaOrdered;
    }

    @TranslatorProperty(display="Upsert", description="If true, translator can support Upsert command", advanced=true)
    public boolean supportsUpsert() {
        return this.supportsUpsert;
    }

    public boolean setSupportsUpsert(boolean supports) {
        this.supportsUpsert = supports;
        return this.supportsUpsert;
    }

    public boolean supportsLikeCriteria() {
        return true;
    }

    public boolean supportsLikeCriteriaEscapeCharacter() {
        return true;
    }

    public boolean supportsNotCriteria() {
        return false;
    }

    public boolean supportsGroupBy() {
        return true;
    }

    public boolean supportsRowLimit() {
        return true;
    }

    public boolean supportsRowOffset() {
        return true;
    }

    public boolean useAnsiJoin() {
        return true;
    }

    public boolean supportsOnlyLiteralComparison() {
        return true;
    }

    public boolean supportsAggregatesSum() {
        return false;
    }

    public boolean supportsAggregatesAvg() {
        return true;
    }

    public boolean supportsAggregatesMin() {
        return true;
    }

    public boolean supportsAggregatesMax() {
        return true;
    }

    public boolean supportsAggregatesCount() {
        return true;
    }

    public boolean supportsHaving() {
        return true;
    }

    @TranslatorProperty(display="Supports Bulk Update", description="If true, translator can support Bulk Updates", advanced=true)
    public boolean supportsBulkUpdate() {
        return this.supportsBulkUpdates;
    }

    public boolean setSupportsBulkUpdate(boolean supports) {
        this.supportsBulkUpdates = supports;
        return this.supportsBulkUpdates;
    }
}

