/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.infinispan.hotrod;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.protostream.BaseMarshaller;
import org.teiid.core.BundleUtil;
import org.teiid.infinispan.api.DocumentFilter;
import org.teiid.infinispan.api.InfinispanConnection;
import org.teiid.infinispan.api.TeiidTableMarsheller;
import org.teiid.language.Command;
import org.teiid.language.LanguageObject;
import org.teiid.language.QueryExpression;
import org.teiid.language.Select;
import org.teiid.language.visitor.CollectorVisitor;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.logging.LogManager;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.infinispan.hotrod.ComplexDocumentFilter;
import org.teiid.translator.infinispan.hotrod.IckleConversionVisitor;
import org.teiid.translator.infinispan.hotrod.InfinispanDirectQueryExecution;
import org.teiid.translator.infinispan.hotrod.InfinispanExecutionFactory;
import org.teiid.translator.infinispan.hotrod.InfinispanPlugin;
import org.teiid.translator.infinispan.hotrod.InfinispanResponse;
import org.teiid.translator.infinispan.hotrod.MarshallerBuilder;

public class InfinispanQueryExecution
implements ResultSetExecution {
    private Select command;
    private InfinispanConnection connection;
    private RuntimeMetadata metadata;
    private ExecutionContext executionContext;
    private InfinispanResponse results;
    private TeiidTableMarsheller marshaller;
    private boolean useAliasCache;

    public InfinispanQueryExecution(InfinispanExecutionFactory translator, QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, InfinispanConnection connection, boolean useAliasCache) throws TranslatorException {
        this.command = (Select)command;
        this.connection = connection;
        this.metadata = metadata;
        this.executionContext = executionContext;
        this.useAliasCache = useAliasCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws TranslatorException {
        try {
            if (this.useAliasCache) {
                InfinispanQueryExecution.useModifiedGroups(this.connection, this.executionContext, this.metadata, (Command)this.command);
            }
            IckleConversionVisitor visitor = new IckleConversionVisitor(this.metadata, false);
            visitor.append((LanguageObject)this.command);
            Table table = visitor.getParentTable();
            String queryStr = visitor.getQuery();
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)"SourceQuery:", (Object)queryStr);
            ComplexDocumentFilter docFilter = null;
            if (queryStr.startsWith("FROM ") && this.command.getWhere() != null) {
                SQLStringVisitor ssv = new SQLStringVisitor(){

                    public String getName(AbstractMetadataRecord object) {
                        return object.getName();
                    }
                };
                ssv.append((LanguageObject)this.command.getWhere());
                docFilter = new ComplexDocumentFilter(visitor.getParentNamedTable(), visitor.getQueryNamedTable(), this.metadata, ssv.toString(), DocumentFilter.Action.ADD);
            }
            this.marshaller = MarshallerBuilder.getMarshaller(table, this.metadata, docFilter);
            this.connection.registerMarshaller((BaseMarshaller)this.marshaller);
            RemoteCache<Object, Object> cache = InfinispanQueryExecution.getCache(table, this.connection);
            this.results = new InfinispanResponse(cache, queryStr, this.executionContext.getBatchSize(), visitor.getRowLimit(), visitor.getRowOffset(), visitor.getProjectedDocumentAttributes(), visitor.getDocumentNode());
        }
        finally {
            this.connection.unRegisterMarshaller((BaseMarshaller)this.marshaller);
        }
    }

    static void useModifiedGroups(InfinispanConnection connection, ExecutionContext context, RuntimeMetadata metadata, Command command) throws TranslatorException {
        BasicCache<String, String> aliasCache = InfinispanDirectQueryExecution.getAliasCache(connection);
        CollectorVisitor.collectGroups((LanguageObject)command).forEach(namedTable -> {
            try {
                Table table = InfinispanDirectQueryExecution.getAliasTable(context, metadata, aliasCache, namedTable.getMetadataObject());
                Collection columns = CollectorVisitor.collectElements((LanguageObject)command);
                columns.forEach(reference -> {
                    if (reference.getTable().getMetadataObject().equals((Object)namedTable.getMetadataObject())) {
                        Column column = table.getColumnByName(reference.getMetadataObject().getName());
                        reference.getTable().setMetadataObject(table);
                        reference.setMetadataObject(column);
                    }
                });
                namedTable.setMetadataObject(table);
            }
            catch (TranslatorException e) {
                LogManager.logError((String)"org.teiid.CONNECTOR", (Throwable)e, (Object)e.getMessage());
            }
        });
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        try {
            this.connection.registerMarshaller((BaseMarshaller)this.marshaller);
            List<Object> list = this.results.getNextRow();
            return list;
        }
        catch (IOException e) {
            throw new TranslatorException((Throwable)e);
        }
        finally {
            this.connection.unRegisterMarshaller((BaseMarshaller)this.marshaller);
        }
    }

    public void close() {
    }

    public void cancel() throws TranslatorException {
    }

    static RemoteCache<Object, Object> getCache(Table table, InfinispanConnection connection) throws TranslatorException {
        RemoteCache cache = (RemoteCache)connection.getCache();
        String cacheName = table.getProperty("{http://www.teiid.org/translator/infinispan/2017}CACHE", false);
        if (cacheName != null && !cacheName.equals(connection.getCache().getName()) && (cache = (RemoteCache)connection.getCache(cacheName, true)) == null) {
            throw new TranslatorException(InfinispanPlugin.Util.gs((BundleUtil.Event)InfinispanPlugin.Event.TEIID25020, new Object[]{cacheName}));
        }
        return cache;
    }
}

