/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.infinispan.hotrod;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.teiid.infinispan.api.InfinispanDocument;
import org.teiid.infinispan.api.ProtobufDataManager;
import org.teiid.translator.document.Document;
import org.teiid.translator.document.DocumentNode;

public class InfinispanResponse {
    private Query query;
    private int batchSize;
    private Integer offset;
    private Integer limit;
    private boolean lastBatch = false;
    private Iterator<Object> responseIter;
    private Map<String, Class<?>> projected;
    private DocumentNode documentNode;
    private List<Map<String, Object>> currentDocumentRows;

    public InfinispanResponse(RemoteCache<Object, Object> cache, String queryStr, int batchSize, Integer limit, Integer offset, Map<String, Class<?>> projected, DocumentNode documentNode) {
        this.batchSize = batchSize;
        this.offset = offset == null ? 0 : offset;
        this.limit = limit;
        this.projected = projected;
        this.documentNode = documentNode;
        QueryFactory qf = Search.getQueryFactory(cache);
        this.query = qf.create(queryStr);
    }

    private void fetchNextBatch() {
        this.query.startOffset((long)this.offset.intValue());
        int nextBatch = this.batchSize;
        if (this.limit != null) {
            if (this.limit > nextBatch) {
                this.limit = this.limit - nextBatch;
            } else {
                nextBatch = this.limit;
                this.limit = 0;
                this.lastBatch = true;
            }
        }
        this.query.maxResults(nextBatch);
        List values = this.query.list();
        if (values == null || values.isEmpty()) {
            this.lastBatch = true;
            this.responseIter = null;
        } else if (values.size() < nextBatch) {
            this.lastBatch = true;
            this.responseIter = values.iterator();
            nextBatch = values.size();
        } else {
            this.responseIter = values.iterator();
        }
        this.offset = this.offset + nextBatch;
    }

    public List<Object> getNextRow() throws IOException {
        if (this.currentDocumentRows != null && !this.currentDocumentRows.isEmpty()) {
            return this.buildRow(this.currentDocumentRows.remove(0));
        }
        if (this.responseIter == null) {
            this.fetchNextBatch();
        }
        if (this.responseIter != null && this.responseIter.hasNext()) {
            Object row = this.responseIter.next();
            if (row instanceof Object[]) {
                return this.buildRow((Object[])row);
            }
            this.currentDocumentRows = this.documentNode.tuples((Document)((InfinispanDocument)row));
        } else {
            if (this.lastBatch) {
                return null;
            }
            this.fetchNextBatch();
            if (this.responseIter == null) {
                return null;
            }
            Object row = this.responseIter.next();
            if (row instanceof Object[]) {
                return Arrays.asList((Object[])row);
            }
            this.currentDocumentRows = this.documentNode.tuples((Document)((InfinispanDocument)row));
        }
        return this.getNextRow();
    }

    private List<Object> buildRow(Map<String, Object> row) throws IOException {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Map.Entry<String, Class<?>> attr : this.projected.entrySet()) {
            result.add(ProtobufDataManager.convertToRuntime(attr.getValue(), (Object)row.get(attr.getKey())));
        }
        return result;
    }

    private List<Object> buildRow(Object[] values) throws IOException {
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        for (Map.Entry<String, Class<?>> attr : this.projected.entrySet()) {
            result.add(ProtobufDataManager.convertToRuntime(attr.getValue(), (Object)values[i]));
            ++i;
        }
        return result;
    }
}

