/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.infinispan.hotrod;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.teiid.core.BundleUtil;
import org.teiid.infinispan.api.DocumentFilter;
import org.teiid.infinispan.api.InfinispanConnection;
import org.teiid.infinispan.api.InfinispanDocument;
import org.teiid.infinispan.api.TeiidTableMarsheller;
import org.teiid.language.ColumnReference;
import org.teiid.language.Command;
import org.teiid.language.Delete;
import org.teiid.language.Insert;
import org.teiid.language.LanguageObject;
import org.teiid.language.NamedTable;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.document.Document;
import org.teiid.translator.infinispan.hotrod.ComplexDocumentFilter;
import org.teiid.translator.infinispan.hotrod.InfinispanPlugin;
import org.teiid.translator.infinispan.hotrod.InfinispanQueryExecution;
import org.teiid.translator.infinispan.hotrod.InfinispanUpdateVisitor;
import org.teiid.translator.infinispan.hotrod.MarshallerBuilder;
import org.teiid.translator.infinispan.hotrod.ProtobufMetadataProcessor;

public class InfinispanUpdateExecution
implements UpdateExecution {
    private int updateCount = 0;
    private Command command;
    private InfinispanConnection connection;
    private ExecutionContext executionContext;
    private RuntimeMetadata metadata;
    private boolean useAliasCache;

    public InfinispanUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, InfinispanConnection connection, boolean useAliasCache) throws TranslatorException {
        this.command = command;
        this.executionContext = executionContext;
        this.metadata = metadata;
        this.connection = connection;
        this.useAliasCache = useAliasCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws TranslatorException {
        if (this.useAliasCache && this.useAliasCache) {
            InfinispanQueryExecution.useModifiedGroups(this.connection, this.executionContext, this.metadata, this.command);
        }
        final InfinispanUpdateVisitor visitor = new InfinispanUpdateVisitor(this.metadata);
        visitor.append((LanguageObject)this.command);
        if (!visitor.exceptions.isEmpty()) {
            throw visitor.exceptions.get(0);
        }
        TeiidTableMarsheller marshaller = null;
        try {
            Table table = visitor.getParentTable();
            Column pkColumn = visitor.getPrimaryKey();
            if (pkColumn == null) {
                throw new TranslatorException(InfinispanPlugin.Util.gs((BundleUtil.Event)InfinispanPlugin.Event.TEIID25013, new Object[]{table.getName()}));
            }
            final String PK = MarshallerBuilder.getDocumentAttributeName(pkColumn, false, this.metadata);
            ComplexDocumentFilter docFilter = null;
            if (visitor.isNestedOperation() && visitor.getWhereClause() != null) {
                DocumentFilter.Action action = DocumentFilter.Action.ALWAYSADD;
                if (this.command instanceof Delete) {
                    action = DocumentFilter.Action.REMOVE;
                }
                SQLStringVisitor ssv = new SQLStringVisitor(){

                    public void visit(ColumnReference obj) {
                        Table groupID;
                        String groupName = null;
                        NamedTable group = obj.getTable();
                        groupName = group.getCorrelationName() != null ? group.getCorrelationName() : ((groupID = group.getMetadataObject()).getFullName().equals(visitor.getParentTable().getFullName()) ? visitor.getParentNamedTable().getCorrelationName() : visitor.getQueryNamedTable().getCorrelationName());
                        this.buffer.append(groupName).append(".").append(this.getName((AbstractMetadataRecord)obj.getMetadataObject()));
                    }

                    public String getName(AbstractMetadataRecord object) {
                        return object.getName();
                    }
                };
                ssv.append((LanguageObject)visitor.getWhereClause());
                docFilter = new ComplexDocumentFilter(visitor.getParentNamedTable(), visitor.getQueryNamedTable(), this.metadata, ssv.toString(), action);
            }
            marshaller = MarshallerBuilder.getMarshaller(table, this.metadata, docFilter);
            this.connection.registerMarshaller((BaseMarshaller)marshaller);
            final RemoteCache<Object, Object> cache = InfinispanQueryExecution.getCache(table, this.connection);
            if (visitor.getOperationType() == InfinispanUpdateVisitor.OperationType.DELETE) {
                InfinispanUpdateExecution.paginateDeleteResults(cache, visitor.getDeleteQuery(), new Task(){

                    @Override
                    public void run(Object row) throws TranslatorException {
                        if (visitor.isNestedOperation()) {
                            String childName = ProtobufMetadataProcessor.getMessageName(visitor.getQueryTable());
                            InfinispanDocument document = (InfinispanDocument)row;
                            cache.replace(document.getProperties().get(PK), (Object)document);
                            InfinispanUpdateExecution.this.updateCount = InfinispanUpdateExecution.this.updateCount + document.getUpdateCount(childName, false);
                        } else {
                            Object key = ((Object[])row)[0];
                            cache.remove(key);
                            InfinispanUpdateExecution.this.updateCount++;
                        }
                    }
                }, this.executionContext.getBatchSize());
            } else if (visitor.getOperationType() == InfinispanUpdateVisitor.OperationType.UPDATE) {
                InfinispanUpdateExecution.paginateUpdateResults(cache, visitor.getUpdateQuery(), new Task(){

                    @Override
                    public void run(Object row) throws TranslatorException {
                        InfinispanDocument previous = (InfinispanDocument)row;
                        Object key = previous.getProperties().get(PK);
                        int count = previous.merge(visitor.getInsertPayload());
                        cache.replace(key, (Object)previous);
                        InfinispanUpdateExecution.this.updateCount = InfinispanUpdateExecution.this.updateCount + count;
                    }
                }, this.executionContext.getBatchSize());
            } else if (visitor.getOperationType() == InfinispanUpdateVisitor.OperationType.INSERT) {
                this.performInsert(visitor, table, cache, false, marshaller);
            } else if (visitor.getOperationType() == InfinispanUpdateVisitor.OperationType.UPSERT) {
                this.performInsert(visitor, table, cache, true, marshaller);
            }
            if (marshaller == null) return;
        }
        catch (Throwable throwable) {
            if (marshaller == null) throw throwable;
            this.connection.unRegisterMarshaller(marshaller);
            throw throwable;
        }
        this.connection.unRegisterMarshaller((BaseMarshaller)marshaller);
    }

    private void performInsert(InfinispanUpdateVisitor visitor, Table table, RemoteCache<Object, Object> cache, boolean upsert, TeiidTableMarsheller marshaller) throws TranslatorException {
        Insert insert = (Insert)this.command;
        if (visitor.isNestedOperation()) {
            InfinispanDocument previous = null;
            if (visitor.getIdentity() != null) {
                previous = (InfinispanDocument)cache.get(visitor.getIdentity());
            }
            if (insert.getParameterValues() != null) {
                throw new TranslatorException(InfinispanPlugin.Util.gs((BundleUtil.Event)InfinispanPlugin.Event.TEIID25017, new Object[]{table.getName(), visitor.getParentTable().getName()}));
            }
            if (previous == null) {
                throw new TranslatorException(InfinispanPlugin.Util.gs((BundleUtil.Event)InfinispanPlugin.Event.TEIID25009, new Object[]{table.getName(), visitor.getIdentity()}));
            }
            String childName = ProtobufMetadataProcessor.getMessageName(visitor.getQueryTable());
            previous.addChildDocument(childName, (Document)visitor.getInsertPayload().getChildDocuments(childName).get(0));
            previous = upsert ? (InfinispanDocument)cache.replace(visitor.getIdentity(), (Object)previous) : (InfinispanDocument)cache.put(visitor.getIdentity(), (Object)previous);
            ++this.updateCount;
        } else if (insert.getParameterValues() == null) {
            this.insertRow(cache, visitor.getIdentity(), visitor.getInsertPayload(), upsert);
            ++this.updateCount;
        } else {
            Map<Object, InfinispanDocument> rows;
            boolean putAll = false;
            if (this.executionContext.getSourceHint() != null) {
                putAll = this.executionContext.getSourceHint().indexOf("use-putall") != -1;
            }
            int batchSize = this.executionContext.getBatchSize();
            Iterator args = insert.getParameterValues();
            while (!(rows = visitor.getBulkInsertPayload(insert, batchSize, args)).isEmpty()) {
                BulkInsert bi;
                if (putAll) {
                    bi = new UsePutAll(cache);
                    bi.run(rows, false);
                } else {
                    bi = new OneAtATime(cache);
                    bi.run(rows, upsert);
                }
                this.updateCount += rows.size();
            }
        }
    }

    private void insertRow(RemoteCache<Object, Object> cache, Object rowKey, InfinispanDocument row, boolean upsert) throws TranslatorException {
        InfinispanDocument previous = (InfinispanDocument)cache.get(rowKey);
        if (previous != null && !upsert) {
            throw new TranslatorException(InfinispanPlugin.Util.gs((BundleUtil.Event)InfinispanPlugin.Event.TEIID25005, new Object[]{previous.getName(), rowKey}));
        }
        if (upsert && previous != null) {
            previous.merge(row);
            previous = (InfinispanDocument)cache.replace(rowKey, (Object)previous);
        } else {
            previous = row;
            previous = (InfinispanDocument)cache.put(rowKey, (Object)previous);
        }
    }

    static void paginateDeleteResults(RemoteCache<Object, Object> cache, String queryStr, Task task, int batchSize) throws TranslatorException {
        if (cache.isEmpty()) {
            return;
        }
        QueryFactory qf = Search.getQueryFactory(cache);
        Query query = qf.create(queryStr);
        try {
            int offset = 0;
            block2: while (true) {
                query.startOffset((long)offset);
                query.maxResults(batchSize);
                List values = query.list();
                if (values != null && !values.isEmpty()) {
                    Iterator iterator = values.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block2;
                        Object doc = iterator.next();
                        task.run(doc);
                    }
                }
                break;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static void paginateUpdateResults(RemoteCache<Object, Object> cache, String queryStr, Task task, int batchSize) throws TranslatorException {
        QueryFactory qf = Search.getQueryFactory(cache);
        Query query = qf.create(queryStr);
        int offset = 0;
        query.startOffset(0L);
        query.maxResults(batchSize);
        List values = query.list();
        while (true) {
            for (Object doc : values) {
                task.run(doc);
            }
            if (query.getResultSize() < batchSize) break;
            query.startOffset((long)(offset += batchSize));
            values = query.list();
        }
    }

    public int[] getUpdateCounts() throws DataNotAvailableException, TranslatorException {
        return new int[]{this.updateCount};
    }

    public void close() {
    }

    public void cancel() throws TranslatorException {
    }

    private class UsePutAll
    implements BulkInsert {
        private RemoteCache<Object, Object> cache;

        public UsePutAll(RemoteCache<Object, Object> cache) {
            this.cache = cache;
        }

        @Override
        public long run(Map<Object, InfinispanDocument> rows, boolean upsert) throws TranslatorException {
            this.cache.putAll(rows);
            return rows.size();
        }
    }

    private class OneAtATime
    implements BulkInsert {
        private RemoteCache<Object, Object> cache;

        public OneAtATime(RemoteCache<Object, Object> cache) {
            this.cache = cache;
        }

        @Override
        public long run(Map<Object, InfinispanDocument> rows, boolean upsert) throws TranslatorException {
            long updateCount = 0L;
            for (Map.Entry<Object, InfinispanDocument> row : rows.entrySet()) {
                InfinispanUpdateExecution.this.insertRow((RemoteCache<Object, Object>)this.cache, row.getKey(), row.getValue(), upsert);
                ++updateCount;
            }
            return updateCount;
        }
    }

    static interface Task {
        public void run(Object var1) throws TranslatorException;
    }

    static interface BulkInsert {
        public long run(Map<Object, InfinispanDocument> var1, boolean var2) throws TranslatorException;
    }
}

