/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.infinispan.hotrod;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.teiid.core.BundleUtil;
import org.teiid.infinispan.api.InfinispanDocument;
import org.teiid.infinispan.api.TableWireFormat;
import org.teiid.language.Array;
import org.teiid.language.ColumnReference;
import org.teiid.language.Condition;
import org.teiid.language.Delete;
import org.teiid.language.Expression;
import org.teiid.language.ExpressionValueSource;
import org.teiid.language.Insert;
import org.teiid.language.LanguageObject;
import org.teiid.language.Literal;
import org.teiid.language.SetClause;
import org.teiid.language.Update;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.document.Document;
import org.teiid.translator.infinispan.hotrod.IckleConversionVisitor;
import org.teiid.translator.infinispan.hotrod.InfinispanPlugin;
import org.teiid.translator.infinispan.hotrod.MarshallerBuilder;
import org.teiid.translator.infinispan.hotrod.ProtobufMetadataProcessor;

public class InfinispanUpdateVisitor
extends IckleConversionVisitor {
    protected ArrayList<TranslatorException> exceptions = new ArrayList();
    private OperationType operationType;
    private InfinispanDocument insertPayload;
    private Map<String, Object> updatePayload = new HashMap<String, Object>();
    private Object identity;
    private Condition whereClause;

    public InfinispanUpdateVisitor(RuntimeMetadata metadata) {
        super(metadata, true);
    }

    public Object getIdentity() {
        return this.identity;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public InfinispanDocument getInsertPayload() {
        return this.insertPayload;
    }

    public Map<String, Object> getUpdatePayload() {
        return this.updatePayload;
    }

    public void visit(Insert obj) {
        this.operationType = OperationType.INSERT;
        if (obj.isUpsert()) {
            this.operationType = OperationType.UPSERT;
        }
        this.visitNode((LanguageObject)obj.getTable());
        Column pkColumn = this.getPrimaryKey();
        if (pkColumn == null) {
            this.exceptions.add(new TranslatorException(InfinispanPlugin.Util.gs((BundleUtil.Event)InfinispanPlugin.Event.TEIID25013, new Object[]{this.getParentTable().getName()})));
            return;
        }
        if (obj.getParameterValues() == null) {
            List values = ((ExpressionValueSource)obj.getValueSource()).getValues();
            this.insertPayload = this.buildInsertPayload(obj, values);
            if (this.insertPayload != null) {
                this.identity = this.insertPayload.getIdentifier();
            }
        }
    }

    Map<Object, InfinispanDocument> getBulkInsertPayload(Insert obj, int batchSize, Iterator<? extends List<Expression>> iter) {
        TreeMap<Object, InfinispanDocument> updates = new TreeMap<Object, InfinispanDocument>();
        int count = 0;
        while (iter.hasNext()) {
            InfinispanDocument doc = this.buildInsertPayload(obj, iter.next());
            updates.put(doc.getIdentifier(), doc);
            if (count++ != batchSize) continue;
            break;
        }
        return updates;
    }

    private InfinispanDocument buildInsertPayload(Insert obj, List<Expression> values) {
        InfinispanDocument targetDocument = null;
        try {
            Table table = obj.getTable().getMetadataObject();
            Column pkColumn = this.getPrimaryKey();
            targetDocument = this.buildTargetDocument(table, true);
            int elementCount = obj.getColumns().size();
            for (int i = 0; i < elementCount; ++i) {
                ColumnReference columnReference = (ColumnReference)obj.getColumns().get(i);
                Column column = columnReference.getMetadataObject();
                Object value = null;
                if (values.get(i) instanceof Expression) {
                    Expression expr = values.get(i);
                    value = this.resolveExpressionValue(expr);
                } else {
                    value = values.get(i);
                }
                this.updateDocument(targetDocument, column, value);
                if (!column.equals((Object)pkColumn) && !pkColumn.equals((Object)InfinispanUpdateVisitor.normalizePseudoColumn(column, this.metadata))) continue;
                targetDocument.setIdentifier(value);
            }
            if (targetDocument.getIdentifier() == null) {
                this.exceptions.add(new TranslatorException(InfinispanPlugin.Util.gs((BundleUtil.Event)InfinispanPlugin.Event.TEIID25004, new Object[]{this.getParentTable().getName()})));
            }
        }
        catch (NumberFormatException e) {
            this.exceptions.add(new TranslatorException((Throwable)e));
        }
        catch (TranslatorException e) {
            this.exceptions.add(new TranslatorException((Throwable)e));
        }
        return targetDocument;
    }

    private void updateDocument(InfinispanDocument parentDocument, Column column, Object value) throws TranslatorException {
        boolean complexObject = this.nested;
        InfinispanDocument targetDocument = parentDocument;
        int parentTag = ProtobufMetadataProcessor.getParentTag(column);
        if (parentTag != -1) {
            InfinispanDocument child;
            String messageName = ProtobufMetadataProcessor.getMessageName(column);
            targetDocument = child = (InfinispanDocument)parentDocument.getChildDocuments(messageName).get(0);
            complexObject = true;
        } else if (this.nested) {
            InfinispanDocument child;
            Table table = (Table)column.getParent();
            String messageName = ProtobufMetadataProcessor.getMessageName(table);
            targetDocument = child = (InfinispanDocument)parentDocument.getChildDocuments(messageName).get(0);
            complexObject = true;
        }
        if (!ProtobufMetadataProcessor.isPseudo(column)) {
            if (value instanceof List) {
                List l = (List)value;
                for (Object o : l) {
                    targetDocument.addArrayProperty(this.getName((AbstractMetadataRecord)column), o);
                }
            } else {
                targetDocument.addProperty(this.getName((AbstractMetadataRecord)column), value);
            }
            String attrName = MarshallerBuilder.getDocumentAttributeName(column, complexObject, this.metadata);
            this.updatePayload.put(attrName, value);
        }
    }

    private InfinispanDocument buildTargetDocument(Table table, boolean addDefaults) throws TranslatorException {
        TreeMap<Integer, TableWireFormat> wireMap = MarshallerBuilder.getWireMap(this.getParentTable(), this.metadata);
        String messageName = ProtobufMetadataProcessor.getMessageName(this.getParentTable());
        InfinispanDocument parentDocument = new InfinispanDocument(messageName, wireMap, null);
        this.addDefaults(parentDocument, this.getParentTable(), addDefaults);
        if (!table.equals((Object)this.getParentTable())) {
            messageName = ProtobufMetadataProcessor.getMessageName(table);
            int parentTag = ProtobufMetadataProcessor.getParentTag(table);
            TableWireFormat twf = wireMap.get(TableWireFormat.buildNestedTag((int)parentTag));
            this.nested = true;
            InfinispanDocument child = new InfinispanDocument(messageName, twf.getNestedWireMap(), parentDocument);
            this.addDefaults(child, table, addDefaults);
            parentDocument.addChildDocument(messageName, (Document)child);
        }
        return parentDocument;
    }

    private void addDefaults(InfinispanDocument parentDocument, Table table, boolean addDefaults) throws TranslatorException {
        for (Column column : table.getColumns()) {
            int parentTag = ProtobufMetadataProcessor.getParentTag(column);
            if (parentTag != -1) {
                String messageName = ProtobufMetadataProcessor.getMessageName(column);
                List children = parentDocument.getChildDocuments(messageName);
                InfinispanDocument child = null;
                if (children == null || children.isEmpty()) {
                    TableWireFormat twf = (TableWireFormat)parentDocument.getWireMap().get(TableWireFormat.buildNestedTag((int)parentTag));
                    child = new InfinispanDocument(messageName, twf.getNestedWireMap(), parentDocument);
                    parentDocument.addChildDocument(messageName, (Document)child);
                } else {
                    child = (InfinispanDocument)children.get(0);
                }
                if (!addDefaults || column.getDefaultValue() == null) continue;
                child.addProperty(this.getName((AbstractMetadataRecord)column), (Object)column.getDefaultValue());
                continue;
            }
            if (!addDefaults || column.getDefaultValue() == null) continue;
            parentDocument.addProperty(this.getName((AbstractMetadataRecord)column), (Object)column.getDefaultValue());
        }
    }

    public Column getPrimaryKey() {
        Column pkColumn = null;
        if (this.getParentTable().getPrimaryKey() != null) {
            pkColumn = (Column)this.getParentTable().getPrimaryKey().getColumns().get(0);
        }
        return pkColumn;
    }

    private Object resolveExpressionValue(Expression expr) {
        ArrayList<Object> value = null;
        if (expr instanceof Literal) {
            value = ((Literal)expr).getValue();
        } else if (expr instanceof Array) {
            Array contents = (Array)expr;
            List arrayExprs = contents.getExpressions();
            ArrayList<Object> values = new ArrayList<Object>();
            for (Expression exp : arrayExprs) {
                if (exp instanceof Literal) {
                    values.add(((Literal)exp).getValue());
                    continue;
                }
                this.exceptions.add(new TranslatorException(InfinispanPlugin.Util.gs((BundleUtil.Event)InfinispanPlugin.Event.TEIID25003, new Object[0])));
            }
            value = values;
        } else {
            this.exceptions.add(new TranslatorException(InfinispanPlugin.Util.gs((BundleUtil.Event)InfinispanPlugin.Event.TEIID25003, new Object[0])));
        }
        return value;
    }

    public void visit(Update obj) {
        Table table;
        this.operationType = OperationType.UPDATE;
        this.append((LanguageObject)obj.getTable());
        if (obj.getWhere() != null) {
            this.buffer.append(" ").append("WHERE").append(" ");
            this.append((LanguageObject)obj.getWhere());
            this.whereClause = obj.getWhere();
        }
        if (!(table = obj.getTable().getMetadataObject()).equals((Object)this.getParentTable())) {
            this.nested = true;
        }
        try {
            InfinispanDocument targetDocument = this.buildTargetDocument(table, false);
            int elementCount = obj.getChanges().size();
            for (int i = 0; i < elementCount; ++i) {
                Column column = ((SetClause)obj.getChanges().get(i)).getSymbol().getMetadataObject();
                if (this.isPartOfPrimaryKey(column.getName())) {
                    throw new TranslatorException((BundleUtil.Event)InfinispanPlugin.Event.TEIID25019, InfinispanPlugin.Util.gs((BundleUtil.Event)InfinispanPlugin.Event.TEIID25019, new Object[]{column.getName()}));
                }
                Expression expr = ((SetClause)obj.getChanges().get(i)).getValue();
                Object value = this.resolveExpressionValue(expr);
                this.updateDocument(targetDocument, column, value);
            }
            this.insertPayload = targetDocument;
        }
        catch (TranslatorException e) {
            this.exceptions.add(e);
        }
    }

    public void visit(Delete obj) {
        this.operationType = OperationType.DELETE;
        this.append((LanguageObject)obj.getTable());
        Table table = obj.getTable().getMetadataObject();
        if (!table.equals((Object)this.getParentTable())) {
            this.nested = true;
        }
        if (obj.getWhere() != null) {
            this.buffer.append(" ").append("WHERE").append(" ");
            this.append((LanguageObject)obj.getWhere());
            this.whereClause = obj.getWhere();
        }
    }

    public String getUpdateQuery() {
        StringBuilder sb = new StringBuilder();
        sb.append("FROM");
        sb.append(" ").append(super.toString());
        return sb.toString();
    }

    public String getDeleteQuery() {
        StringBuilder sb = new StringBuilder();
        if (!this.isNestedOperation()) {
            this.addSelectedColumns(sb);
            sb.append(" ");
        }
        sb.append("FROM");
        sb.append(" ").append(super.toString());
        return sb.toString();
    }

    Condition getWhereClause() {
        return this.whereClause;
    }

    protected static enum OperationType {
        INSERT,
        UPDATE,
        DELETE,
        UPSERT;

    }
}

