/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.infinispan.hotrod;

import java.util.TreeMap;
import org.teiid.infinispan.api.DocumentFilter;
import org.teiid.infinispan.api.TableWireFormat;
import org.teiid.infinispan.api.TeiidTableMarsheller;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.infinispan.hotrod.ProtobufMetadataProcessor;

public class MarshallerBuilder {
    public static TreeMap<Integer, TableWireFormat> getWireMap(Table parentTbl, RuntimeMetadata metadata) throws TranslatorException {
        TreeMap<Integer, TableWireFormat> wireMap = MarshallerBuilder.buildWireMap(parentTbl, false, metadata);
        Schema schema = (Schema)parentTbl.getParent();
        for (Table table : schema.getTables().values()) {
            String mergeName;
            if (table.equals((Object)parentTbl) || (mergeName = ProtobufMetadataProcessor.getMerge(table)) == null || !mergeName.equals(parentTbl.getFullName())) continue;
            int parentTag = ProtobufMetadataProcessor.getParentTag(table);
            String childName = ProtobufMetadataProcessor.getMessageName(table);
            TableWireFormat child = new TableWireFormat(childName, parentTag);
            wireMap.put(child.getReadTag(), child);
            TreeMap<Integer, TableWireFormat> childWireMap = MarshallerBuilder.buildWireMap(table, true, metadata);
            for (TableWireFormat twf : childWireMap.values()) {
                child.addNested(twf);
            }
        }
        return wireMap;
    }

    private static TreeMap<Integer, TableWireFormat> buildWireMap(Table table, boolean nested, RuntimeMetadata metadata) throws TranslatorException {
        TreeMap<Integer, TableWireFormat> wireMap = new TreeMap<Integer, TableWireFormat>();
        for (Column column : table.getColumns()) {
            String name;
            int tag;
            if (ProtobufMetadataProcessor.getPseudo(column) != null) continue;
            int parentTag = ProtobufMetadataProcessor.getParentTag(column);
            if (parentTag == -1) {
                tag = ProtobufMetadataProcessor.getTag(column);
                name = MarshallerBuilder.getDocumentAttributeName(column, nested, metadata);
                TableWireFormat twf = new TableWireFormat(name, tag, column);
                wireMap.put(twf.getReadTag(), twf);
                continue;
            }
            tag = ProtobufMetadataProcessor.getTag(column);
            name = MarshallerBuilder.getDocumentAttributeName(column, true, metadata);
            TableWireFormat child = new TableWireFormat(name, tag, column);
            String parentName = ProtobufMetadataProcessor.getMessageName(column);
            TableWireFormat parent = null;
            TableWireFormat existing = wireMap.get(TableWireFormat.buildNestedTag((int)parentTag));
            if (existing == null) {
                parent = new TableWireFormat(parentName, parentTag);
                wireMap.put(parent.getReadTag(), parent);
            } else {
                parent = existing;
            }
            parent.addNested(child);
        }
        return wireMap;
    }

    private static String getName(AbstractMetadataRecord record) {
        if (record.getNameInSource() != null && record.getNameInSource().length() > 0) {
            return record.getNameInSource();
        }
        return record.getName();
    }

    public static String getDocumentAttributeName(Column column, boolean nested, RuntimeMetadata metadata) throws TranslatorException {
        String mergeName;
        String nis = MarshallerBuilder.getName((AbstractMetadataRecord)column);
        String parentMessageName = ProtobufMetadataProcessor.getMessageName((Table)column.getParent());
        String messageName = ProtobufMetadataProcessor.getMessageName(column);
        if (messageName == null && (mergeName = ProtobufMetadataProcessor.getMerge((Table)column.getParent())) != null) {
            messageName = ProtobufMetadataProcessor.getMessageName((Table)column.getParent());
            parentMessageName = ProtobufMetadataProcessor.getMessageName(metadata.getTable(mergeName));
        }
        if (messageName != null) {
            nis = messageName + "/" + nis;
        }
        if (nested) {
            return parentMessageName + "/" + nis;
        }
        return nis;
    }

    public static TeiidTableMarsheller getMarshaller(Table table, RuntimeMetadata metadata) throws TranslatorException {
        return new TeiidTableMarsheller(ProtobufMetadataProcessor.getMessageName(table), MarshallerBuilder.getWireMap(table, metadata));
    }

    public static TeiidTableMarsheller getMarshaller(Table table, RuntimeMetadata metadata, DocumentFilter filter) throws TranslatorException {
        return new TeiidTableMarsheller(ProtobufMetadataProcessor.getMessageName(table), MarshallerBuilder.getWireMap(table, metadata), filter);
    }
}

