/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.infinispan.hotrod;

import com.squareup.protoparser.DataType;
import com.squareup.protoparser.EnumConstantElement;
import com.squareup.protoparser.EnumElement;
import com.squareup.protoparser.FieldElement;
import com.squareup.protoparser.MessageElement;
import com.squareup.protoparser.ProtoFile;
import com.squareup.protoparser.ProtoParser;
import com.squareup.protoparser.TypeElement;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.infinispan.commons.api.BasicCache;
import org.teiid.core.BundleUtil;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.infinispan.api.InfinispanConnection;
import org.teiid.infinispan.api.ProtobufDataManager;
import org.teiid.infinispan.api.ProtobufResource;
import org.teiid.logging.LogManager;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.ExtensionMetadataProperty;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Table;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.infinispan.hotrod.InfinispanPlugin;

public class ProtobufMetadataProcessor
implements MetadataProcessor<InfinispanConnection> {
    @ExtensionMetadataProperty(applicable={Table.class}, datatype=String.class, display="Merge Into Table", description="Declare the name of parent table that this table needs to be merged into.")
    public static final String MERGE = "{http://www.teiid.org/translator/infinispan/2017}MERGE";
    @ExtensionMetadataProperty(applicable={Table.class}, datatype=String.class, display="Cache Name", description="Cache name to store the contents into")
    public static final String CACHE = "{http://www.teiid.org/translator/infinispan/2017}CACHE";
    @ExtensionMetadataProperty(applicable={Table.class, Column.class}, datatype=String.class, display="Message Name", description="Message name this table or column represents")
    public static final String MESSAGE_NAME = "{http://www.teiid.org/translator/infinispan/2017}MESSAGE_NAME";
    @ExtensionMetadataProperty(applicable={Column.class}, datatype=String.class, display="Protobuf Tag Number", description="Protobuf field tag number")
    public static final String TAG = "{http://www.teiid.org/translator/infinispan/2017}TAG";
    @ExtensionMetadataProperty(applicable={Table.class, Column.class}, datatype=String.class, display="Protobuf Parent Tag Number", description="Protobuf field parent tag number in the case of complex document")
    public static final String PARENT_TAG = "{http://www.teiid.org/translator/infinispan/2017}PARENT_TAG";
    @ExtensionMetadataProperty(applicable={Table.class, Column.class}, datatype=String.class, display="column's parent column name", description="Protobuf field parent column name in the case of complex document")
    public static final String PARENT_COLUMN_NAME = "{http://www.teiid.org/translator/infinispan/2017}PARENT_COLUMN_NAME";
    @ExtensionMetadataProperty(applicable={Column.class}, datatype=String.class, display="Pseudo Column", description="Pseudo column for join purposes")
    public static final String PSEUDO = "{http://www.teiid.org/translator/infinispan/2017}PSEUDO";
    private String protoFilePath;
    private ProtobufResource protoResource;
    private String protobufName;
    private static final String AT_TEIID = "@Teiid(";
    private static final String AT_CACHE = "@Cache(";
    private static final String AT_INDEXEDFIELD = "@IndexedField(";
    private static final String AT_FIELD = "@Field(";

    @TranslatorProperty(display="Protobuf file path", category=TranslatorProperty.PropertyType.IMPORT, description="Protobuf file path to load as the schema of this model")
    public String getProtoFilePath() {
        return this.protoFilePath;
    }

    public void setProtoFilePath(String path) {
        this.protoFilePath = path;
    }

    @TranslatorProperty(display="Protobuf Name", category=TranslatorProperty.PropertyType.IMPORT, description="When loading the Protobuf contents from Infinispan, limit the import to this given protobuf name")
    public String getProtobufName() {
        return this.protobufName;
    }

    public void setProtobufName(String name) {
        this.protobufName = name;
    }

    public void process(MetadataFactory metadataFactory, InfinispanConnection connection) throws TranslatorException {
        String protobufFile = this.getProtoFilePath();
        String cacheName = null;
        if (connection != null) {
            cacheName = connection.getCache().getName();
        }
        String protoContents = null;
        if (protobufFile != null && !protobufFile.isEmpty()) {
            File f = new File(protobufFile);
            if (!f.exists() || !f.isFile()) {
                throw new TranslatorException((BundleUtil.Event)InfinispanPlugin.Event.TEIID25000, InfinispanPlugin.Util.gs((BundleUtil.Event)InfinispanPlugin.Event.TEIID25000, new Object[]{protobufFile}));
            }
            try {
                protoContents = ObjectConverterUtil.convertFileToString((File)f);
            }
            catch (IOException e) {
                throw new TranslatorException((Throwable)e);
            }
            this.protoResource = new ProtobufResource(this.protobufName != null ? this.protobufName : protobufFile, protoContents);
            this.toTeiidSchema(protobufFile, protoContents, metadataFactory, cacheName);
        } else if (this.protobufName != null) {
            boolean added = false;
            BasicCache metadataCache = connection.getCache("___protobuf_metadata", false);
            for (Object key : metadataCache.keySet()) {
                if (!this.protobufName.equalsIgnoreCase((String)key)) continue;
                protobufFile = (String)key;
                protoContents = (String)metadataCache.get(key);
                this.toTeiidSchema(protobufFile, protoContents, metadataFactory, cacheName);
                this.protoResource = new ProtobufResource(protobufFile, protoContents);
                added = true;
                break;
            }
            if (!added) {
                throw new TranslatorException((BundleUtil.Event)InfinispanPlugin.Event.TEIID25012, InfinispanPlugin.Util.gs((BundleUtil.Event)InfinispanPlugin.Event.TEIID25012, new Object[]{this.protobufName}));
            }
        } else if (this.protoResource != null) {
            this.toTeiidSchema(this.protoResource.getIdentifier(), this.protoResource.getContents(), metadataFactory, cacheName);
        } else {
            throw new TranslatorException((BundleUtil.Event)InfinispanPlugin.Event.TEIID25011, InfinispanPlugin.Util.gs((BundleUtil.Event)InfinispanPlugin.Event.TEIID25011, new Object[0]));
        }
    }

    static <T> List<T> filter(List<? super TypeElement> input, Class<T> ofType) {
        LinkedList<TypeElement> ts = new LinkedList<TypeElement>();
        for (TypeElement typeElement : input) {
            if (!ofType.isAssignableFrom(typeElement.getClass())) continue;
            ts.add(typeElement);
        }
        return ts;
    }

    private void toTeiidSchema(String name, String contents, MetadataFactory mf, String cacheName) throws TranslatorException {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Processing Proto file:", name, "  with contents\n", contents});
        ProtoFile protoFile = ProtoParser.parse((String)name, (String)contents);
        List<MessageElement> messageTypes = ProtobufMetadataProcessor.filter(protoFile.typeElements(), MessageElement.class);
        List<EnumElement> enumTypes = ProtobufMetadataProcessor.filter(protoFile.typeElements(), EnumElement.class);
        HashSet<String> deleteTables = new HashSet<String>();
        for (MessageElement messageElement : messageTypes) {
            Table t = this.addTable(mf, messageTypes, enumTypes, messageElement, null, deleteTables);
            if (t == null) continue;
            if (t.getAnnotation() != null && this.findFromAnnotation(AT_CACHE, t.getAnnotation(), "name") != null) {
                t.setProperty(CACHE, this.findFromAnnotation(AT_CACHE, t.getAnnotation(), "name"));
                continue;
            }
            if (ProtobufMetadataProcessor.getParentTag(t) != -1) continue;
            t.setProperty(CACHE, cacheName == null ? t.getName() : cacheName);
        }
        for (String tableName : deleteTables) {
            mf.getSchema().removeTable(tableName);
        }
    }

    private Table addTable(MetadataFactory mf, List<MessageElement> messageTypes, List<EnumElement> enumTypes, MessageElement messageElement, String columnPrefix, HashSet<String> ignoreTables) throws TranslatorException {
        String tableName = messageElement.name();
        if (mf.getSchema().getTable(tableName) != null) {
            return mf.getSchema().getTable(tableName);
        }
        if (ignoreTables.contains(tableName)) {
            return null;
        }
        Table table = mf.addTable(tableName);
        table.setSupportsUpdate(true);
        table.setNameInSource(messageElement.qualifiedName());
        table.setAnnotation(messageElement.documentation());
        for (FieldElement fieldElement : messageElement.fields()) {
            this.addColumn(mf, messageTypes, enumTypes, columnPrefix, table, fieldElement, ignoreTables, false);
        }
        return table;
    }

    private Column addColumn(MetadataFactory mf, List<MessageElement> messageTypes, List<EnumElement> enumTypes, String parentTableColumn, Table table, FieldElement fieldElement, HashSet<String> ignoreTables, boolean nested) throws TranslatorException {
        String scale;
        String precision;
        DataType type = fieldElement.type();
        String annotation = fieldElement.documentation();
        String columnName = fieldElement.name();
        String teiidType = null;
        boolean searchable = true;
        if (this.isEnum(messageTypes, enumTypes, type)) {
            teiidType = ProtobufDataManager.teiidType((DataType)type, (boolean)this.isCollection(fieldElement), (boolean)true);
        } else {
            if (this.isMessage(messageTypes, type)) {
                String nestedName = ((DataType.NamedType)type).name();
                MessageElement nestedMessageElement = this.getMessage(messageTypes, nestedName);
                if (nestedMessageElement == null) {
                    throw new TranslatorException((BundleUtil.Event)InfinispanPlugin.Event.TEIID25001, InfinispanPlugin.Util.gs((BundleUtil.Event)InfinispanPlugin.Event.TEIID25001, new Object[]{nestedName, columnName}));
                }
                if (this.isCollection(fieldElement)) {
                    Table nestedTable = this.addTable(mf, messageTypes, enumTypes, nestedMessageElement, parentTableColumn == null ? columnName : parentTableColumn + "." + columnName, ignoreTables);
                    if (table.getPrimaryKey() != null) {
                        Column parentColumn = (Column)table.getPrimaryKey().getColumns().get(0);
                        String psedoColumnName = table.getName() + "_" + parentColumn.getName();
                        Column addedColumn = mf.addColumn(psedoColumnName, parentColumn.getRuntimeType(), (ColumnSet)nestedTable);
                        addedColumn.setNameInSource(parentColumn.getName());
                        addedColumn.setUpdatable(true);
                        addedColumn.setProperty(PSEUDO, columnName);
                        addedColumn.setSearchType(Column.SearchType.Searchable);
                        ArrayList<String> keyColumns = new ArrayList<String>();
                        keyColumns.add(addedColumn.getName());
                        ArrayList<String> refColumns = new ArrayList<String>();
                        refColumns.add(parentColumn.getName());
                        mf.addForeignKey("FK_" + table.getName().toUpperCase(), keyColumns, refColumns, table.getName(), nestedTable);
                        nestedTable.setProperty(MERGE, table.getFullName());
                        nestedTable.setProperty(PARENT_TAG, Integer.toString(fieldElement.tag()));
                        nestedTable.setProperty(PARENT_COLUMN_NAME, columnName);
                    } else {
                        ignoreTables.add(nestedName);
                        LogManager.logInfo((String)"org.teiid.CONNECTOR", (Object)InfinispanPlugin.Util.gs((BundleUtil.Event)InfinispanPlugin.Event.TEIID25006, new Object[]{nestedName}));
                    }
                } else {
                    ignoreTables.add(nestedMessageElement.name());
                    for (FieldElement nestedElement : nestedMessageElement.fields()) {
                        Column nestedColumn = this.addColumn(mf, messageTypes, enumTypes, columnName, table, nestedElement, ignoreTables, true);
                        nestedColumn.setNameInSource(nestedElement.name());
                        nestedColumn.setProperty(MESSAGE_NAME, nestedMessageElement.qualifiedName());
                        nestedColumn.setProperty(PARENT_TAG, Integer.toString(fieldElement.tag()));
                        nestedColumn.setProperty(PARENT_COLUMN_NAME, columnName);
                    }
                }
                return null;
            }
            teiidType = this.findFromAnnotation(AT_TEIID, annotation, "type");
            if (teiidType == null) {
                teiidType = ProtobufDataManager.teiidType((DataType)type, (boolean)this.isCollection(fieldElement), (boolean)false);
            } else {
                searchable = false;
            }
        }
        Column c = null;
        c = nested ? mf.addColumn(parentTableColumn + "_" + columnName, teiidType, (ColumnSet)table) : mf.addColumn(columnName, teiidType, (ColumnSet)table);
        c.setNativeType(fieldElement.type().toString());
        c.setUpdatable(true);
        c.setNullType(fieldElement.label() == FieldElement.Label.REQUIRED ? BaseColumn.NullType.No_Nulls : BaseColumn.NullType.Nullable);
        c.setProperty(TAG, Integer.toString(fieldElement.tag()));
        String length = this.findFromAnnotation(AT_TEIID, annotation, "length");
        if (length != null) {
            c.setLength(Integer.parseInt(length));
        }
        if ((precision = this.findFromAnnotation(AT_TEIID, annotation, "precision")) != null) {
            c.setPrecision(Integer.parseInt(precision));
        }
        if ((scale = this.findFromAnnotation(AT_TEIID, annotation, "scale")) != null) {
            c.setScale(Integer.parseInt(scale));
        }
        if (fieldElement.getDefault() != null) {
            if (this.isEnum(messageTypes, enumTypes, type)) {
                String ordinal = this.getEnumOrdinal(messageTypes, enumTypes, ((DataType.NamedType)type).name(), fieldElement.getDefault().value().toString());
                if (ordinal != null) {
                    c.setDefaultValue(ordinal);
                }
            } else {
                c.setDefaultValue(fieldElement.getDefault().value().toString());
            }
        }
        if (table.getAnnotation() != null && table.getAnnotation().contains("@Indexed")) {
            c.setSearchType(Column.SearchType.Searchable);
        }
        if (annotation != null && !annotation.isEmpty()) {
            String index;
            if (annotation.contains(AT_TEIID)) {
                int start = annotation.indexOf(AT_TEIID);
                int end = annotation.indexOf(")", start + 7);
                annotation = annotation.substring(0, start) + annotation.substring(end + 1);
            }
            if (!annotation.isEmpty()) {
                c.setAnnotation(annotation);
            }
            if ((index = this.findFromAnnotation(AT_INDEXEDFIELD, annotation, "index")) != null && (index.equalsIgnoreCase("false") || index.equalsIgnoreCase("no"))) {
                c.setSearchType(Column.SearchType.Unsearchable);
            }
            if ((index = this.findFromAnnotation(AT_FIELD, annotation, "index")) != null && (index.equalsIgnoreCase("Index.NO") || index.equalsIgnoreCase("no"))) {
                c.setSearchType(Column.SearchType.Unsearchable);
            }
            if (annotation.contains("@Id")) {
                ArrayList<String> pkNames = new ArrayList<String>();
                pkNames.add(fieldElement.name());
                mf.addPrimaryKey("PK_" + fieldElement.name().toUpperCase(), pkNames, table);
            }
        }
        if (!searchable) {
            c.setSearchType(Column.SearchType.Unsearchable);
        }
        return c;
    }

    private String findFromAnnotation(String rootProperty, String annotation, String verb) {
        if (annotation != null && !annotation.isEmpty() && annotation.contains(rootProperty)) {
            int length = rootProperty.length();
            int start = annotation.indexOf(rootProperty);
            int end = annotation.indexOf(")", start + length);
            String teiidMetadata = annotation.substring(start + length, end);
            StringTokenizer st = new StringTokenizer(teiidMetadata, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                String[] values = token.split("=");
                if (!values[0].equals(verb)) continue;
                return values[1];
            }
        }
        return null;
    }

    private boolean isCollection(FieldElement fieldElement) {
        return fieldElement.label() == FieldElement.Label.REPEATED;
    }

    private String getEnumOrdinal(List<MessageElement> messageTypes, List<EnumElement> enumTypes, String name, String value) {
        for (EnumElement enumElement : enumTypes) {
            if (!enumElement.name().equals(name)) continue;
            for (EnumConstantElement constant : enumElement.constants()) {
                if (!constant.name().equals(value)) continue;
                return String.valueOf(constant.tag());
            }
        }
        for (MessageElement messageElement : messageTypes) {
            List<EnumElement> childEnumTypes;
            List<MessageElement> childMessageTypes = ProtobufMetadataProcessor.filter(messageElement.nestedElements(), MessageElement.class);
            String child = this.getEnumOrdinal(childMessageTypes, childEnumTypes = ProtobufMetadataProcessor.filter(messageElement.nestedElements(), EnumElement.class), name, value);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    private boolean isEnum(List<MessageElement> messageTypes, List<EnumElement> enumTypes, DataType type) {
        if (type instanceof DataType.NamedType) {
            for (EnumElement enumElement : enumTypes) {
                if (!enumElement.name().equals(((DataType.NamedType)type).name())) continue;
                return true;
            }
            for (MessageElement messageElement : messageTypes) {
                List<EnumElement> childEnumTypes;
                List<MessageElement> childMessageTypes = ProtobufMetadataProcessor.filter(messageElement.nestedElements(), MessageElement.class);
                if (!this.isEnum(childMessageTypes, childEnumTypes = ProtobufMetadataProcessor.filter(messageElement.nestedElements(), EnumElement.class), type)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isMessage(List<MessageElement> messageTypes, DataType type) {
        if (type instanceof DataType.NamedType) {
            for (MessageElement element : messageTypes) {
                if (element.name().equals(((DataType.NamedType)type).name())) {
                    return true;
                }
                List<MessageElement> childMessageTypes = ProtobufMetadataProcessor.filter(element.nestedElements(), MessageElement.class);
                if (!this.isMessage(childMessageTypes, type)) continue;
                return true;
            }
        }
        return false;
    }

    private MessageElement getMessage(List<MessageElement> messageTypes, String name) {
        for (MessageElement element : messageTypes) {
            if (element.name().equals(name)) {
                return element;
            }
            List<MessageElement> childMessageTypes = ProtobufMetadataProcessor.filter(element.nestedElements(), MessageElement.class);
            MessageElement child = this.getMessage(childMessageTypes, name);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    public ProtobufResource getProtobufResource() {
        return this.protoResource;
    }

    public void setProtobufResource(ProtobufResource resource) {
        this.protoResource = resource;
    }

    static String getPseudo(Column column) {
        return column.getProperty(PSEUDO, false);
    }

    static boolean isPseudo(Column column) {
        return column.getProperty(PSEUDO, false) != null;
    }

    static String getMessageName(Table table) {
        if (table.getNameInSource() != null) {
            return table.getNameInSource();
        }
        return table.getName();
    }

    static String getMessageName(Column column) {
        return column.getProperty(MESSAGE_NAME, false);
    }

    static String getMerge(Table table) {
        return table.getProperty(MERGE, false);
    }

    static int getTag(Column column) {
        if (column.getProperty(TAG, false) != null) {
            return Integer.parseInt(column.getProperty(TAG, false));
        }
        return -1;
    }

    static int getParentTag(Column column) {
        if (column.getProperty(PARENT_TAG, false) != null) {
            return Integer.parseInt(column.getProperty(PARENT_TAG, false));
        }
        return -1;
    }

    static int getParentTag(Table table) {
        if (table.getProperty(PARENT_TAG, false) != null) {
            return Integer.parseInt(table.getProperty(PARENT_TAG, false));
        }
        return -1;
    }

    static String getParentColumnName(Column column) {
        return column.getProperty(PARENT_COLUMN_NAME, false);
    }

    static String getParentColumnName(Table table) {
        return table.getProperty(PARENT_COLUMN_NAME, false);
    }

    static String getCacheName(Table table) {
        return table.getProperty(CACHE, false);
    }
}

