/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.infinispan.hotrod;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.teiid.infinispan.api.InfinispanConnection;
import org.teiid.infinispan.api.ProtobufDataManager;
import org.teiid.infinispan.api.ProtobufResource;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.infinispan.hotrod.ProtobufMetadataProcessor;

public class SchemaToProtobufProcessor {
    private static final String NL = "\n";
    private static final String OPEN_CURLY = "{";
    private static final String CLOSE_CURLY = "}";
    private static final String TAB = "    ";
    private StringBuilder buffer = new StringBuilder();
    private TreeMap<String, List<Column>> processLater = new TreeMap();
    private Schema schema;
    private boolean indexMessages = false;

    public ProtobufResource process(MetadataFactory metadataFactory, InfinispanConnection connection) throws TranslatorException {
        String defaultCacheName = "default";
        if (connection != null) {
            defaultCacheName = connection.getCache().getName();
        }
        this.schema = metadataFactory.getSchema();
        this.buffer.append("package ").append(this.schema.getName()).append(";");
        this.buffer.append(NL);
        this.buffer.append(NL);
        for (Table table : this.schema.getTables().values()) {
            this.visit(table, defaultCacheName);
            this.buffer.append(NL);
            this.buffer.append(NL);
        }
        for (String name : this.processLater.keySet()) {
            this.visitTable(name, this.processLater.get(name));
        }
        return new ProtobufResource(this.schema.getName() + ".proto", this.buffer.toString());
    }

    private void addTab() {
        this.buffer.append(TAB);
    }

    private void visit(Table table, String defaultCacheName) {
        if (table.getAnnotation() != null) {
            this.buffer.append("/* ").append(table.getAnnotation()).append(" */").append(NL);
        } else if (this.isIndexMessages()) {
            this.buffer.append("/* @Indexed");
            String cacheName = ProtobufMetadataProcessor.getCacheName(table);
            if (cacheName != null && !cacheName.equals(defaultCacheName)) {
                this.buffer.append("@Cache(name=").append(cacheName).append(")");
            }
            this.buffer.append(" */").append(NL);
        }
        this.buffer.append("message ").append(table.getName()).append(" ").append(OPEN_CURLY).append(NL);
        for (Column column : table.getColumns()) {
            this.visit(column);
        }
        this.processFKTable(table);
        this.buffer.append(CLOSE_CURLY);
    }

    private void visitTable(String name, List<Column> columns) {
        if (this.isIndexMessages()) {
            this.buffer.append("/* @Indexed */").append(NL);
        }
        this.buffer.append("message ").append(name).append(" ").append(OPEN_CURLY).append(NL);
        for (Column column : columns) {
            this.visitColumn(column);
        }
        this.buffer.append(CLOSE_CURLY);
    }

    private void visit(Column column) {
        String messageName = ProtobufMetadataProcessor.getMessageName(column);
        if (messageName != null) {
            if (this.processLater.get(messageName) == null) {
                this.addTab();
                int tag = ProtobufMetadataProcessor.getParentTag(column);
                String name = ProtobufMetadataProcessor.getParentColumnName(column);
                this.buffer.append("optional ");
                this.buffer.append(messageName.substring(messageName.lastIndexOf(46) + 1)).append(" ").append(name);
                this.buffer.append(" = ").append(tag).append(";").append(NL);
            }
            this.processLater(column);
            return;
        }
        this.visitColumn(column);
    }

    private void visitColumn(Column column) {
        this.addTab();
        boolean array = column.getJavaType().isArray();
        String type = this.getType(column, array);
        if (column.getAnnotation() != null) {
            this.buffer.append("/* ").append(column.getAnnotation().replace('\n', ' ')).append(" */").append(NL);
            this.addTab();
        } else {
            boolean needId = this.isPartOfPrimaryKey(column) || this.isPartOfUniqueKey(column);
            boolean needType = ProtobufDataManager.shouldPreserveType((String)type, (String)column.getRuntimeType());
            if (needId || needType) {
                this.buffer.append("/* ");
                if (needId) {
                    this.buffer.append("@Id ");
                }
                if (needType) {
                    this.buffer.append("@Teiid(type=").append(column.getRuntimeType());
                    if (column.getLength() != 0 && (column.getRuntimeType().equalsIgnoreCase("string") || column.getRuntimeType().equalsIgnoreCase("char"))) {
                        this.buffer.append(", length=").append(column.getLength());
                    }
                    if (column.getScale() != column.getDatatype().getScale() && column.getScale() != 16383 || column.getPrecision() != column.getDatatype().getPrecision() && column.getPrecision() != Short.MAX_VALUE) {
                        this.buffer.append(", precision=").append(column.getPrecision());
                        this.buffer.append(", scale=").append(column.getScale());
                    }
                    this.buffer.append(") ");
                }
                this.buffer.append("*/").append(NL);
                this.addTab();
            }
        }
        if (column.getNullType().equals((Object)BaseColumn.NullType.No_Nulls)) {
            this.buffer.append("required ");
        } else if (array) {
            this.buffer.append("repeated ");
        } else {
            this.buffer.append("optional ");
        }
        this.buffer.append(type).append(" ");
        if (column.getNameInSource() != null) {
            this.buffer.append(column.getNameInSource()).append(" ");
        } else {
            this.buffer.append(column.getName()).append(" ");
        }
        int tag = ProtobufMetadataProcessor.getTag(column);
        if (tag == -1) {
            tag = column.getPosition();
        }
        this.buffer.append("= ").append(tag).append(";").append(NL);
    }

    private String getType(Column column, boolean array) {
        if (column.getNativeType() != null) {
            return column.getNativeType();
        }
        Class<?> clazz = column.getJavaType();
        if (array) {
            clazz = clazz.getComponentType();
        }
        return ProtobufDataManager.getCompatibleProtobufType((Class)clazz).toString().toLowerCase();
    }

    private void processLater(Column column) {
        String messageName = ProtobufMetadataProcessor.getMessageName(column);
        List<Column> columns = this.processLater.get(messageName);
        if (columns == null) {
            columns = new ArrayList<Column>();
            this.processLater.put(messageName, columns);
        }
        columns.add(column);
    }

    public boolean isPartOfPrimaryKey(Column column) {
        KeyRecord pk = ((Table)column.getParent()).getPrimaryKey();
        if (pk != null) {
            for (Column c : pk.getColumns()) {
                if (!c.getName().equals(column.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPartOfUniqueKey(Column column) {
        List list = ((Table)column.getParent()).getUniqueKeys();
        for (KeyRecord uk : list) {
            for (Column c : uk.getColumns()) {
                if (!c.getName().equals(column.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private void processFKTable(Table table) {
        int increment = 1;
        for (Table t : this.schema.getTables().values()) {
            if (table == t || t.getForeignKeys().isEmpty()) continue;
            List fks = t.getForeignKeys();
            for (ForeignKey fk : fks) {
                int tag;
                if (!fk.getReferenceTableName().equals(table.getName())) continue;
                this.addTab();
                String messageName = ProtobufMetadataProcessor.getMessageName(t);
                messageName = messageName == null ? table.getName() : messageName.substring(messageName.lastIndexOf(46) + 1);
                String columnName = ProtobufMetadataProcessor.getParentColumnName(t);
                if (columnName == null) {
                    columnName = t.getName().toLowerCase();
                }
                if ((tag = ProtobufMetadataProcessor.getParentTag(t)) == -1) {
                    tag = table.getColumns().size() + increment;
                    ++increment;
                }
                this.buffer.append("repeated ");
                this.buffer.append(messageName).append(" ").append(columnName);
                this.buffer.append(" = ").append(tag).append(";").append(NL);
            }
        }
    }

    boolean isIndexMessages() {
        return this.indexMessages;
    }

    void setIndexMessages(boolean indexMessages) {
        this.indexMessages = indexMessages;
    }
}

