/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dataquality;

import java.util.ArrayList;
import java.util.HashSet;
import org.arrah.framework.analytics.PIIValidator;
import org.arrah.framework.datagen.ShuffleRTM;
import org.arrah.framework.util.StringCaseFormatUtil;
import org.simmetrics.metrics.CosineSimilarity;
import org.simmetrics.metrics.JaccardSimilarity;
import org.simmetrics.metrics.JaroWinkler;
import org.simmetrics.metrics.Levenshtein;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.function.TeiidFunction;

public class OSDQFunctions {
    @TeiidFunction(category="Miscellaneous", determinism=FunctionMethod.Determinism.COMMAND_DETERMINISTIC)
    public static String random(String sourceValue) {
        return ShuffleRTM.shuffleString((String)sourceValue);
    }

    @TeiidFunction(category="Miscellaneous")
    public static String digit(String sourceValue) {
        return StringCaseFormatUtil.digitString((String)sourceValue);
    }

    @TeiidFunction(category="Miscellaneous")
    public static int whitespaceIndex(String val) {
        return StringCaseFormatUtil.whitespaceIndex((String)val);
    }

    @TeiidFunction(category="Miscellaneous")
    public static boolean validCreditCard(String cc) {
        return new PIIValidator().isCreditCard(cc);
    }

    @TeiidFunction(category="Miscellaneous")
    public static boolean validSSN(String ssn) {
        return new PIIValidator().isSSN(ssn);
    }

    @TeiidFunction(category="Miscellaneous")
    public static boolean validPhone(String phone) {
        return new PIIValidator().isPhone(phone);
    }

    @TeiidFunction(category="Miscellaneous")
    public static boolean validEmail(String email) {
        return new PIIValidator().isEmail(email);
    }

    @TeiidFunction(category="Miscellaneous")
    public static float cosineDistance(String a, String b) {
        ArrayList alist = StringCaseFormatUtil.toArrayListChar((String)a);
        ArrayList blist = StringCaseFormatUtil.toArrayListChar((String)b);
        HashSet aset = new HashSet(alist);
        HashSet bset = new HashSet(blist);
        return new CosineSimilarity().compare(aset, bset);
    }

    @TeiidFunction(category="Miscellaneous")
    public static float jaccardDistance(String a, String b) {
        ArrayList alist = StringCaseFormatUtil.toArrayListChar((String)a);
        ArrayList blist = StringCaseFormatUtil.toArrayListChar((String)b);
        HashSet aset = new HashSet(alist);
        HashSet bset = new HashSet(blist);
        return new JaccardSimilarity().compare(aset, bset);
    }

    @TeiidFunction(category="Miscellaneous")
    public static float jaroWinklerDistance(String a, String b) {
        return new JaroWinkler().compare(a, b);
    }

    @TeiidFunction(category="Miscellaneous")
    public static float levenshteinDistance(String a, String b) {
        return new Levenshtein().compare(a, b);
    }
}

