/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.UUID;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.EdmTypeDefinition;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;

public class EdmTypeInfo {
    private final boolean collection;
    private final FullQualifiedName fullQualifiedName;
    private EdmPrimitiveTypeKind primitiveType;
    private EdmTypeDefinition typeDefinition;
    private EdmEnumType enumType;
    private EdmComplexType complexType;
    private EdmEntityType entityType;

    private EdmTypeInfo(Edm edm, String typeExpression) {
        String typeName;
        String namespace;
        int lastDotIdx;
        String baseType;
        int collStartIdx = typeExpression.indexOf("Collection(");
        int collEndIdx = typeExpression.lastIndexOf(41);
        if (collStartIdx == -1) {
            baseType = typeExpression;
            this.collection = false;
        } else {
            if (collEndIdx == -1) {
                throw new IllegalArgumentException("Malformed type: " + typeExpression);
            }
            this.collection = true;
            baseType = typeExpression.substring(collStartIdx + 11, collEndIdx);
        }
        if (baseType.startsWith("#")) {
            baseType = baseType.substring(1);
        }
        if ((lastDotIdx = baseType.lastIndexOf(46)) == -1) {
            namespace = "Edm";
            typeName = baseType;
        } else {
            namespace = baseType.substring(0, lastDotIdx);
            typeName = baseType.substring(lastDotIdx + 1);
        }
        if (typeName == null || typeName.isEmpty()) {
            throw new IllegalArgumentException("Null or empty type name in " + typeExpression);
        }
        this.fullQualifiedName = new FullQualifiedName(namespace, typeName);
        try {
            this.primitiveType = EdmPrimitiveTypeKind.valueOf((String)typeName);
        }
        catch (IllegalArgumentException e) {
            this.primitiveType = null;
        }
        if (this.primitiveType == null && edm != null) {
            this.typeDefinition = edm.getTypeDefinition(this.fullQualifiedName);
            if (this.typeDefinition == null) {
                this.enumType = edm.getEnumType(this.fullQualifiedName);
                if (this.enumType == null) {
                    this.complexType = edm.getComplexType(this.fullQualifiedName);
                    if (this.complexType == null) {
                        this.entityType = edm.getEntityType(this.fullQualifiedName);
                    }
                }
            }
        }
    }

    public String internal() {
        return this.serialize(false);
    }

    public String external() {
        return this.serialize(true);
    }

    private String serialize(boolean external) {
        StringBuilder serialize = new StringBuilder();
        if (external && (!this.isPrimitiveType() || this.isCollection())) {
            serialize.append('#');
        }
        if (this.isCollection()) {
            serialize.append("Collection(");
        }
        serialize.append(external && this.isPrimitiveType() ? this.getFullQualifiedName().getName() : this.getFullQualifiedName().getFullQualifiedNameAsString());
        if (this.isCollection()) {
            serialize.append(')');
        }
        return serialize.toString();
    }

    public boolean isCollection() {
        return this.collection;
    }

    public FullQualifiedName getFullQualifiedName() {
        return this.fullQualifiedName;
    }

    public boolean isPrimitiveType() {
        return this.primitiveType != null;
    }

    public EdmPrimitiveTypeKind getPrimitiveTypeKind() {
        return this.primitiveType;
    }

    public boolean isTypeDefinition() {
        return this.typeDefinition != null;
    }

    public EdmTypeDefinition getTypeDefinition() {
        return this.typeDefinition;
    }

    public boolean isEnumType() {
        return this.enumType != null;
    }

    public EdmEnumType getEnumType() {
        return this.enumType;
    }

    public boolean isComplexType() {
        return this.complexType != null;
    }

    public EdmComplexType getComplexType() {
        return this.complexType;
    }

    public boolean isEntityType() {
        return this.entityType != null;
    }

    public EdmEntityType getEntityType() {
        return this.entityType;
    }

    public EdmType getType() {
        return this.isPrimitiveType() ? EdmPrimitiveTypeFactory.getInstance(this.getPrimitiveTypeKind()) : (this.isTypeDefinition() ? this.getTypeDefinition() : (this.isEnumType() ? this.getEnumType() : (this.isComplexType() ? this.getComplexType() : (this.isEntityType() ? this.getEntityType() : null))));
    }

    public static EdmPrimitiveTypeKind determineTypeKind(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return EdmPrimitiveTypeKind.Boolean;
        }
        if (value instanceof String) {
            return EdmPrimitiveTypeKind.String;
        }
        if (value instanceof UUID) {
            return EdmPrimitiveTypeKind.Guid;
        }
        if (value instanceof Long || value instanceof BigInteger) {
            return EdmPrimitiveTypeKind.Int64;
        }
        if (value instanceof Integer) {
            return EdmPrimitiveTypeKind.Int32;
        }
        if (value instanceof Short) {
            return EdmPrimitiveTypeKind.Int16;
        }
        if (value instanceof Byte) {
            return EdmPrimitiveTypeKind.SByte;
        }
        if (value instanceof BigDecimal) {
            return EdmPrimitiveTypeKind.Decimal;
        }
        if (value instanceof Double) {
            return EdmPrimitiveTypeKind.Double;
        }
        if (value instanceof Float) {
            return EdmPrimitiveTypeKind.Single;
        }
        if (value instanceof Calendar || value instanceof java.util.Date || value instanceof Timestamp) {
            return EdmPrimitiveTypeKind.DateTimeOffset;
        }
        if (value instanceof Date) {
            return EdmPrimitiveTypeKind.Date;
        }
        if (value instanceof Time) {
            return EdmPrimitiveTypeKind.TimeOfDay;
        }
        if (value instanceof byte[] || value instanceof Byte[]) {
            return EdmPrimitiveTypeKind.Binary;
        }
        return null;
    }

    public static class Builder {
        private String typeExpression;
        private Edm edm;

        public Builder setTypeExpression(String typeExpression) {
            this.typeExpression = typeExpression;
            return this;
        }

        public Builder setEdm(Edm edm) {
            this.edm = edm;
            return this;
        }

        public EdmTypeInfo build() {
            return new EdmTypeInfo(this.edm, this.typeExpression);
        }
    }
}

