/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.net.SocketAddress;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.consistenthash.SegmentConsistentHash;
import org.infinispan.client.hotrod.impl.operations.IterationStartResponse;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;

public class IterationStartOperation
extends RetryOnFailureOperation<IterationStartResponse> {
    private final String filterConverterFactory;
    private final byte[][] filterParameters;
    private final Set<Integer> segments;
    private final int batchSize;
    private final TransportFactory transportFactory;
    private final boolean metadata;

    IterationStartOperation(Codec codec, int flags, Configuration cfg, byte[] cacheName, AtomicInteger topologyId, String filterConverterFactory, byte[][] filterParameters, Set<Integer> segments, int batchSize, TransportFactory transportFactory, boolean metadata) {
        super(codec, transportFactory, cacheName, topologyId, flags, cfg);
        this.filterConverterFactory = filterConverterFactory;
        this.filterParameters = filterParameters;
        this.segments = segments;
        this.batchSize = batchSize;
        this.transportFactory = transportFactory;
        this.metadata = metadata;
    }

    @Override
    protected Transport getTransport(int retryCount, Set<SocketAddress> failedServers) {
        return this.transportFactory.getTransport(failedServers, this.cacheName);
    }

    @Override
    protected IterationStartResponse executeOperation(Transport transport) {
        HeaderParams params = this.writeHeader(transport, (short)49);
        if (this.segments == null) {
            transport.writeSignedVInt(-1);
        } else {
            BitSet bitSet = new BitSet();
            this.segments.stream().forEach(bitSet::set);
            transport.writeOptionalArray(bitSet.toByteArray());
        }
        transport.writeOptionalString(this.filterConverterFactory);
        if (this.filterConverterFactory != null) {
            if (this.filterParameters != null && this.filterParameters.length > 0) {
                transport.writeByte((short)this.filterParameters.length);
                Arrays.stream(this.filterParameters).forEach(transport::writeArray);
            } else {
                transport.writeByte((short)0);
            }
        }
        transport.writeVInt(this.batchSize);
        transport.writeByte((short)(this.metadata ? 1 : 0));
        transport.flush();
        this.readHeaderAndValidate(transport, params);
        return new IterationStartResponse(transport.readString(), (SegmentConsistentHash)this.transportFactory.getConsistentHash(this.cacheName), this.topologyId.get(), transport);
    }

    @Override
    protected void releaseTransport(Transport transport) {
    }
}

