/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Properties;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.teiid.common.buffer.StorageManager;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.NamedThreadFactory;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.logging.LogManager;
import org.teiid.net.socket.ObjectChannel;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.transport.ChannelListener;
import org.teiid.transport.ClientServiceRegistryImpl;
import org.teiid.transport.ObjectDecoder;
import org.teiid.transport.ObjectEncoder;
import org.teiid.transport.SSLAwareChannelHandler;
import org.teiid.transport.SSLConfiguration;
import org.teiid.transport.SocketClientInstance;
import org.teiid.transport.SocketConfiguration;
import org.teiid.transport.SocketListenerStats;

public class SocketListener
implements ChannelListener.ChannelListenerFactory {
    private static final int DEFAULT_MAX_MESSAGE_SIZE = 0x200000;
    protected SSLAwareChannelHandler channelHandler;
    private Channel serverChannel;
    private boolean isClientEncryptionEnabled;
    private ClientServiceRegistryImpl csr;
    private ServerBootstrap bootstrap;
    private int maxMessageSize = (Integer)PropertiesUtils.getHierarchicalProperty((String)"org.teiid.maxMessageSize", (Object)0x200000, Integer.class);
    private long maxLobSize = (Long)PropertiesUtils.getHierarchicalProperty((String)"org.teiid.maxStreamingLobSize", (Object)0x100000000L, Long.class);

    public SocketListener(InetSocketAddress address, SocketConfiguration config, ClientServiceRegistryImpl csr, StorageManager storageManager) {
        this(address, config.getInputBufferSize(), config.getOutputBufferSize(), config.getMaxSocketThreads(), config.getSSLConfiguration(), csr, storageManager);
        LogManager.logDetail((String)"org.teiid.TRANSPORT", (Object)RuntimePlugin.Util.getString("SocketTransport.1", new Object[]{address.getHostName(), String.valueOf(config.getPortNumber())}));
    }

    public SocketListener(InetSocketAddress address, int inputBufferSize, int outputBufferSize, int maxWorkers, final SSLConfiguration config, ClientServiceRegistryImpl csr, final StorageManager storageManager) {
        if (config != null) {
            this.isClientEncryptionEnabled = config.isClientEncryptionEnabled();
        }
        this.csr = csr;
        NamedThreadFactory nettyPool = new NamedThreadFactory("NIO");
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.TRANSPORT", (int)5)) {
            LogManager.logDetail((String)"org.teiid.TRANSPORT", (Object)("server = " + address.getAddress() + "binding to port:" + address.getPort()));
        }
        if (maxWorkers == 0) {
            maxWorkers = Math.max(4, PropertiesUtils.getIntProperty((Properties)System.getProperties(), (String)"io.netty.eventLoopThreads", (int)(2 * Runtime.getRuntime().availableProcessors())));
        }
        NioEventLoopGroup workers = new NioEventLoopGroup(maxWorkers, (ThreadFactory)nettyPool);
        this.bootstrap = new ServerBootstrap();
        this.bootstrap.group((EventLoopGroup)workers).channel(NioServerSocketChannel.class);
        this.channelHandler = this.createChannelHandler();
        this.bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                SocketListener.this.configureChannelPipeline(pipeline, config, storageManager);
            }
        });
        if (inputBufferSize != 0) {
            this.bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)new Integer(inputBufferSize));
        }
        if (outputBufferSize != 0) {
            this.bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)new Integer(outputBufferSize));
        }
        this.bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)Boolean.TRUE);
        this.bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)Boolean.TRUE);
        ChannelFuture future = this.bootstrap.bind((SocketAddress)address);
        future.syncUninterruptibly();
        this.serverChannel = future.channel();
    }

    protected void configureChannelPipeline(ChannelPipeline pipeline, SSLConfiguration config, StorageManager storageManager) throws Exception {
        SSLEngine engine;
        if (config != null && (engine = config.getServerSSLEngine()) != null) {
            pipeline.addLast("ssl", (ChannelHandler)new SslHandler(engine));
        }
        pipeline.addLast("decoder", (ChannelHandler)new ObjectDecoder(this.maxMessageSize, this.maxLobSize, Thread.currentThread().getContextClassLoader(), storageManager));
        pipeline.addLast("chunker", (ChannelHandler)new ChunkedWriteHandler());
        pipeline.addLast("encoder", (ChannelHandler)new ObjectEncoder());
        pipeline.addLast("handler", (ChannelHandler)this.channelHandler);
    }

    public int getPort() {
        return ((InetSocketAddress)this.serverChannel.localAddress()).getPort();
    }

    public Future<?> stop() {
        ChannelFuture future = this.serverChannel.closeFuture();
        Future shutdown = null;
        if (this.bootstrap != null) {
            shutdown = this.bootstrap.group().shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
            this.bootstrap = null;
        }
        try {
            future.await();
        }
        catch (InterruptedException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
        return shutdown;
    }

    public SocketListenerStats getStats() {
        SocketListenerStats stats = new SocketListenerStats();
        stats.objectsRead = this.channelHandler.getObjectsRead();
        stats.objectsWritten = this.channelHandler.getObjectsWritten();
        stats.sockets = this.channelHandler.getConnectedChannels();
        stats.maxSockets = this.channelHandler.getMaxConnectedChannels();
        return stats;
    }

    protected SSLAwareChannelHandler createChannelHandler() {
        return new SSLAwareChannelHandler(this);
    }

    @Override
    public ChannelListener createChannelListener(ObjectChannel channel) {
        return new SocketClientInstance(channel, this.csr, this.isClientEncryptionEnabled);
    }

    SSLAwareChannelHandler getChannelHandler() {
        return this.channelHandler;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public void setMaxLobSize(long maxLobSize) {
        this.maxLobSize = maxLobSize;
    }
}

