/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.google.gdata;

import com.google.gdata.client.Query;
import com.google.gdata.client.spreadsheet.FeedURLFactory;
import com.google.gdata.client.spreadsheet.SpreadsheetQuery;
import com.google.gdata.client.spreadsheet.SpreadsheetService;
import com.google.gdata.data.BaseFeed;
import com.google.gdata.data.IEntry;
import com.google.gdata.data.spreadsheet.ListEntry;
import com.google.gdata.data.spreadsheet.ListFeed;
import com.google.gdata.data.spreadsheet.SpreadsheetEntry;
import com.google.gdata.data.spreadsheet.SpreadsheetFeed;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.teiid.core.types.DataTypeManager;
import org.teiid.logging.LogManager;
import org.teiid.resource.adapter.google.auth.AuthHeaderFactory;
import org.teiid.translator.google.api.SpreadsheetOperationException;
import org.teiid.translator.google.api.UpdateSet;
import org.teiid.translator.google.api.metadata.Column;
import org.teiid.translator.google.api.metadata.SpreadsheetColumnType;
import org.teiid.translator.google.api.result.UpdateResult;

public class GDataClientLoginAPI {
    private static final int RETRY_DELAY = 3000;
    private SpreadsheetService service = new SpreadsheetService("GdataSpreadsheetBrowser");
    private FeedURLFactory factory = FeedURLFactory.getDefault();
    private AuthHeaderFactory headerFactory = null;

    public void setHeaderFactory(AuthHeaderFactory headerFactory) {
        this.headerFactory = headerFactory;
        this.service.setHeader("Authorization", headerFactory.getAuthHeader());
    }

    public SpreadsheetEntry getSpreadsheetEntry(String sheetName, boolean key) {
        if (key) {
            try {
                return this.getSpreadsheetEntry(new URL(this.factory.getSpreadsheetsFeedUrl(), "full/" + sheetName), SpreadsheetEntry.class);
            }
            catch (MalformedURLException e) {
                throw new SpreadsheetOperationException((Throwable)e);
            }
        }
        SpreadsheetQuery squery = new SpreadsheetQuery(this.factory.getSpreadsheetsFeedUrl());
        squery.setTitleExact(true);
        squery.setTitleQuery(sheetName);
        SpreadsheetFeed feed = (SpreadsheetFeed)this.getSpreadsheetFeedQuery(squery, SpreadsheetFeed.class);
        List entry = feed.getEntries();
        if (entry.size() == 0) {
            throw new SpreadsheetOperationException("Couldn't find spreadsheet:" + sheetName);
        }
        if (entry.size() > 1) {
            throw new SpreadsheetOperationException("Multiple worksheets with the given title:" + sheetName + ".  Consider using a sheet key instead.");
        }
        return (SpreadsheetEntry)entry.get(0);
    }

    protected BaseFeed<?, ?> getSpreadsheetFeedQuery(SpreadsheetQuery squery, Class<? extends BaseFeed<?, ?>> feedClass) {
        try {
            return (BaseFeed)this.service.getFeed((Query)squery, feedClass);
        }
        catch (Exception ex) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.reauthenticate();
            try {
                return (BaseFeed)this.service.getFeed((Query)squery, SpreadsheetFeed.class);
            }
            catch (Exception ex2) {
                throw new SpreadsheetOperationException("Error getting spreadsheet feed. Possibly bad authentication or connection problems. " + ex2);
            }
        }
    }

    private <E extends IEntry> E getSpreadsheetEntry(URL entryUrl, Class<E> entryClass) {
        try {
            return (E)this.service.getEntry(entryUrl, entryClass);
        }
        catch (Exception ex) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.reauthenticate();
            try {
                return (E)this.service.getEntry(entryUrl, entryClass);
            }
            catch (Exception ex2) {
                throw new SpreadsheetOperationException("Error getting spreadsheet feed. Possibly bad authentication or connection problems. " + ex2);
            }
        }
    }

    private void reauthenticate() {
        this.headerFactory.refreshToken();
        this.service.setHeader("Authorization", this.headerFactory.getAuthHeader());
    }

    public UpdateResult listFeedUpdate(String spreadsheetKey, String worksheetID, String criteria, List<UpdateSet> updateSet, List<Column> allColumns) {
        SpreadsheetQuery query = null;
        try {
            query = new SpreadsheetQuery(this.factory.getListFeedUrl(spreadsheetKey, worksheetID, "private", "full"));
            if (criteria != null) {
                query.setStringCustomParameter("sq", criteria);
            }
        }
        catch (MalformedURLException e) {
            throw new SpreadsheetOperationException("Error getting spreadsheet URL: " + e);
        }
        ListFeed listfeed = (ListFeed)this.getSpreadsheetFeedQuery(query, ListFeed.class);
        int counter = 0;
        ArrayList<Column> stringColumns = new ArrayList<Column>();
        for (Column c : allColumns) {
            if (c.getLabel() == null || c.getDataType() != SpreadsheetColumnType.STRING) continue;
            stringColumns.add(c);
        }
        for (ListEntry row : listfeed.getEntries()) {
            for (int i = 0; i < stringColumns.size(); ++i) {
                Column c = (Column)stringColumns.get(i);
                String value = row.getCustomElements().getValue(c.getLabel());
                if (value == null || value.isEmpty()) continue;
                row.getCustomElements().setValueLocal(c.getLabel(), "'" + value);
            }
            for (UpdateSet set : updateSet) {
                row.getCustomElements().setValueLocal(set.getColumnID(), set.getValue());
            }
            try {
                row.update();
            }
            catch (IOException e) {
                LogManager.logWarning((String)this.getClass().getName(), (Throwable)e, (Object)"Error occured when updating spreadsheet row");
                continue;
            }
            catch (ServiceException e2) {
                LogManager.logWarning((String)this.getClass().getName(), (Throwable)e2, (Object)"Error occured when updating spreadsheet row");
                continue;
            }
            ++counter;
        }
        return new UpdateResult(listfeed.getEntries().size(), counter);
    }

    public UpdateResult listFeedDelete(String spreadsheetKey, String worksheetID, String criteria) {
        SpreadsheetQuery query = null;
        try {
            query = new SpreadsheetQuery(this.factory.getListFeedUrl(spreadsheetKey, worksheetID, "private", "full"));
            if (criteria != null) {
                query.setStringCustomParameter("sq", criteria);
            }
        }
        catch (MalformedURLException e) {
            throw new SpreadsheetOperationException("Error getting spreadsheet URL: " + e);
        }
        ListFeed listfeed = (ListFeed)this.getSpreadsheetFeedQuery(query, ListFeed.class);
        int counter = 0;
        for (int i = listfeed.getEntries().size() - 1; i > -1; --i) {
            ListEntry row = (ListEntry)listfeed.getEntries().get(i);
            try {
                row.delete();
            }
            catch (IOException e) {
                LogManager.logWarning((String)this.getClass().getName(), (Throwable)e, (Object)"Error occured when deleting spreadsheet row");
                continue;
            }
            catch (ServiceException e2) {
                LogManager.logWarning((String)this.getClass().getName(), (Throwable)e2, (Object)"Error occured when deleting spreadsheet row");
                continue;
            }
            ++counter;
        }
        return new UpdateResult(listfeed.getEntries().size(), counter);
    }

    public UpdateResult listFeedInsert(String spreadsheetKey, String worksheetID, Map<String, Object> pair) {
        SpreadsheetQuery query = null;
        try {
            query = new SpreadsheetQuery(this.factory.getListFeedUrl(spreadsheetKey, worksheetID, "private", "full"));
        }
        catch (MalformedURLException e) {
            throw new SpreadsheetOperationException("Error getting spreadsheet URL: " + e);
        }
        ListEntry row = new ListEntry();
        for (Map.Entry<String, Object> entry : pair.entrySet()) {
            Object value = entry.getValue();
            Class<?> type = value.getClass();
            String valString = null;
            valString = type.equals(DataTypeManager.DefaultDataClasses.STRING) ? "'" + value : value.toString();
            row.getCustomElements().setValueLocal(entry.getKey(), valString);
        }
        try {
            this.service.insert(query.getFeedUrl(), (IEntry)row);
        }
        catch (Exception e) {
            throw new SpreadsheetOperationException("Error inserting spreadsheet row: " + e);
        }
        return new UpdateResult(1, 1);
    }
}

