/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata;

import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;
import org.odata4j.core.ODataVersion;
import org.odata4j.core.OSimpleObject;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.format.FormatParser;
import org.odata4j.format.FormatParserFactory;
import org.odata4j.format.FormatType;
import org.odata4j.format.Settings;
import org.teiid.language.Call;
import org.teiid.language.LanguageObject;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Schema;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.odata.BaseQueryExecution;
import org.teiid.translator.odata.ODataEntitySchemaBuilder;
import org.teiid.translator.odata.ODataExecutionFactory;
import org.teiid.translator.odata.ODataProcedureVisitor;
import org.teiid.translator.odata.ODataTypeManager;
import org.teiid.translator.odata.TeiidEdmMetadata;
import org.teiid.translator.ws.BinaryWSProcedureExecution;
import org.teiid.translator.ws.WSConnection;

public class ODataProcedureExecution
extends BaseQueryExecution
implements ProcedureExecution {
    private ODataProcedureVisitor visitor;
    private Object returnValue;
    private BaseQueryExecution.ODataEntitiesResponse response;
    private Class<?>[] expectedColumnTypes;

    public ODataProcedureExecution(Call command, ODataExecutionFactory translator, ExecutionContext executionContext, RuntimeMetadata metadata, WSConnection connection) throws TranslatorException {
        super(translator, executionContext, metadata, connection);
        this.visitor = new ODataProcedureVisitor(translator, metadata);
        this.visitor.visitNode((LanguageObject)command);
        if (!this.visitor.exceptions.isEmpty()) {
            throw this.visitor.exceptions.get(0);
        }
        this.expectedColumnTypes = command.getResultSetColumnTypes();
    }

    public void execute() throws TranslatorException {
        String URI = this.visitor.buildURL();
        Schema schema = this.visitor.getProcedure().getParent();
        TeiidEdmMetadata edm = new TeiidEdmMetadata(schema.getName(), ODataEntitySchemaBuilder.buildMetadata(schema));
        if (this.visitor.hasCollectionReturn()) {
            this.response = this.visitor.isReturnComplexType() ? this.executeWithComplexReturn(this.visitor.getMethod(), URI, null, this.visitor.getReturnEntityTypeName(), (EdmDataServices)edm, null, Response.Status.OK, Response.Status.NO_CONTENT) : this.executeWithReturnEntity(this.visitor.getMethod(), URI, null, this.visitor.getTable().getName(), (EdmDataServices)edm, null, Response.Status.OK, Response.Status.NO_CONTENT);
            if (this.response != null && this.response.hasError()) {
                throw this.response.getError();
            }
        } else {
            try {
                BinaryWSProcedureExecution execution = this.executeDirect(this.visitor.getMethod(), URI, null, this.getDefaultHeaders());
                if (execution.getResponseCode() != Response.Status.OK.getStatusCode()) {
                    throw this.buildError(execution);
                }
                Blob blob = (Blob)execution.getOutputParameterValues().get(0);
                ODataVersion version = this.getODataVersion(execution);
                if (this.visitor.getReturnType() != null) {
                    FormatParser parser = FormatParserFactory.getParser(OSimpleObject.class, (FormatType)FormatType.ATOM, (Settings)new Settings(version, (EdmDataServices)edm, this.visitor.getProcedure().getName(), null, true, ODataTypeManager.odataType(this.visitor.getReturnType())));
                    OSimpleObject object = (OSimpleObject)parser.parse((Reader)new InputStreamReader(blob.getBinaryStream()));
                    this.returnValue = this.translator.retrieveValue(object.getValue(), this.visitor.getReturnTypeClass());
                }
            }
            catch (SQLException e) {
                throw new TranslatorException((Throwable)e);
            }
        }
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        if (this.visitor.hasCollectionReturn() && this.response != null) {
            return this.response.getNextRow(this.visitor.getReturnColumns(), this.expectedColumnTypes);
        }
        return null;
    }

    public List<?> getOutputParameterValues() throws TranslatorException {
        return Arrays.asList(this.returnValue);
    }

    public void close() {
    }

    public void cancel() throws TranslatorException {
    }
}

