/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata;

import java.util.ArrayList;
import java.util.List;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.language.visitor.HierarchyVisitor;
import org.teiid.metadata.Column;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.odata.ODataExecutionFactory;
import org.teiid.util.WSUtil;

public class ODataProcedureVisitor
extends HierarchyVisitor {
    protected ODataExecutionFactory executionFactory;
    protected RuntimeMetadata metadata;
    protected ArrayList<TranslatorException> exceptions = new ArrayList();
    private StringBuilder buffer = new StringBuilder();
    private String method = "GET";
    private String returnEntityTypeName;
    private boolean returnsTable;
    private Procedure procedure;
    private String returnType;
    private Class<?> returnTypeClass;
    private boolean isComplexReturnType;
    private Table entity;
    private List<Column> returnColumns;

    public ODataProcedureVisitor(ODataExecutionFactory executionFactory, RuntimeMetadata metadata) {
        this.executionFactory = executionFactory;
        this.metadata = metadata;
    }

    public void visit(Call obj) {
        Procedure proc = obj.getMetadataObject();
        this.method = proc.getProperty("{http://www.jboss.org/teiiddesigner/ext/odata/2012}HttpMethod", false);
        this.procedure = proc;
        this.buffer.append(obj.getProcedureName());
        List params = obj.getArguments();
        if (params != null && params.size() != 0) {
            this.buffer.append("?");
            Argument param = null;
            StringBuilder temp = new StringBuilder();
            for (int i = 0; i < params.size(); ++i) {
                param = (Argument)params.get(i);
                if (param.getDirection() != Argument.Direction.IN && param.getDirection() != Argument.Direction.INOUT) continue;
                if (i != 0) {
                    this.buffer.append("&");
                }
                this.buffer.append(WSUtil.httpURLEncode((String)param.getMetadataObject().getName()));
                this.buffer.append("=");
                this.executionFactory.convertToODataInput(param.getArgumentValue(), temp);
                this.buffer.append(WSUtil.httpURLEncode((String)temp.toString()));
                temp.setLength(0);
            }
        }
        if (proc.getResultSet() != null) {
            this.returnsTable = true;
            this.returnEntityTypeName = proc.getProperty("{http://www.jboss.org/teiiddesigner/ext/odata/2012}EntityType", false);
            this.entity = this.getTableWithEntityType(proc.getParent(), this.returnEntityTypeName);
            this.isComplexReturnType = this.entity == null;
            this.returnColumns = proc.getResultSet().getColumns();
        } else {
            for (ProcedureParameter param : proc.getParameters()) {
                if (!param.getType().equals((Object)ProcedureParameter.Type.ReturnValue)) continue;
                this.returnType = param.getRuntimeType();
                this.returnTypeClass = param.getJavaType();
            }
        }
    }

    Table getTableWithEntityType(Schema schema, String entityType) {
        for (Table t : schema.getTables().values()) {
            if (!entityType.equals(t.getProperty("{http://www.jboss.org/teiiddesigner/ext/odata/2012}EntityType", false))) continue;
            return t;
        }
        return null;
    }

    public String buildURL() {
        return this.buffer.toString();
    }

    public String getMethod() {
        return this.method;
    }

    public String getReturnEntityTypeName() {
        return this.returnEntityTypeName;
    }

    public Table getTable() {
        return this.entity;
    }

    public boolean hasCollectionReturn() {
        return this.returnsTable;
    }

    public Column[] getReturnColumns() {
        return this.returnColumns.toArray(new Column[this.returnColumns.size()]);
    }

    public boolean isReturnComplexType() {
        return this.isComplexReturnType;
    }

    public Procedure getProcedure() {
        return this.procedure;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public Class<?> getReturnTypeClass() {
        return this.returnTypeClass;
    }
}

