/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import javax.ws.rs.core.Response;
import org.odata4j.edm.EdmDataServices;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.language.LanguageObject;
import org.teiid.language.QueryExpression;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Schema;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.odata.BaseQueryExecution;
import org.teiid.translator.odata.ODataEntitySchemaBuilder;
import org.teiid.translator.odata.ODataExecutionFactory;
import org.teiid.translator.odata.ODataSQLVisitor;
import org.teiid.translator.odata.TeiidEdmMetadata;
import org.teiid.translator.ws.BinaryWSProcedureExecution;
import org.teiid.translator.ws.WSConnection;

public class ODataQueryExecution
extends BaseQueryExecution
implements ResultSetExecution {
    private ODataSQLVisitor visitor;
    private int countResponse = -1;
    private Class<?>[] expectedColumnTypes;
    private BaseQueryExecution.ODataEntitiesResponse response;

    public ODataQueryExecution(ODataExecutionFactory translator, QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, WSConnection connection) throws TranslatorException {
        super(translator, executionContext, metadata, connection);
        this.visitor = new ODataSQLVisitor(this.translator, metadata);
        this.visitor.visitNode((LanguageObject)command);
        if (!this.visitor.exceptions.isEmpty()) {
            throw this.visitor.exceptions.get(0);
        }
        this.expectedColumnTypes = command.getColumnTypes();
    }

    public void execute() throws TranslatorException {
        String URI2 = this.visitor.buildURL();
        if (this.visitor.isCount()) {
            TreeMap<String, List<String>> headers = new TreeMap<String, List<String>>();
            headers.put("Accept", Arrays.asList("text/xml", "text/plain"));
            BinaryWSProcedureExecution execution = this.executeDirect("GET", URI2, null, headers);
            if (execution.getResponseCode() != Response.Status.OK.getStatusCode()) {
                throw this.buildError(execution);
            }
            Blob blob = (Blob)execution.getOutputParameterValues().get(0);
            try {
                this.countResponse = Integer.parseInt(ObjectConverterUtil.convertToString((InputStream)blob.getBinaryStream()));
            }
            catch (IOException e) {
                throw new TranslatorException((Throwable)e);
            }
            catch (SQLException e) {
                throw new TranslatorException((Throwable)e);
            }
        } else {
            Schema schema = (Schema)this.visitor.getEnityTable().getParent();
            TeiidEdmMetadata edm = new TeiidEdmMetadata(schema.getName(), ODataEntitySchemaBuilder.buildMetadata(schema));
            this.response = this.executeWithReturnEntity("GET", URI2, null, this.visitor.getEnityTable().getName(), (EdmDataServices)edm, null, Response.Status.OK, Response.Status.NO_CONTENT, Response.Status.NOT_FOUND);
            if (this.response != null && this.response.hasError()) {
                throw this.response.getError();
            }
        }
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        if (this.visitor.isCount() && this.countResponse != -1) {
            int count = this.countResponse;
            this.countResponse = -1;
            return Arrays.asList(count);
        }
        if (this.response != null && !this.response.hasError()) {
            return this.response.getNextRow(this.visitor.getSelect(), this.expectedColumnTypes);
        }
        return null;
    }

    public void close() {
    }

    public void cancel() throws TranslatorException {
    }
}

