/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.odata4j.core.OEntities;
import org.odata4j.core.OEntity;
import org.odata4j.core.OProperty;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.format.Entry;
import org.odata4j.format.FormatWriter;
import org.odata4j.format.FormatWriterFactory;
import org.teiid.GeneratedKeys;
import org.teiid.language.Command;
import org.teiid.language.LanguageObject;
import org.teiid.metadata.Column;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.odata.BaseQueryExecution;
import org.teiid.translator.odata.ODataEntitySchemaBuilder;
import org.teiid.translator.odata.ODataExecutionFactory;
import org.teiid.translator.odata.ODataUpdateVisitor;
import org.teiid.translator.odata.TeiidEdmMetadata;
import org.teiid.translator.ws.BinaryWSProcedureExecution;
import org.teiid.translator.ws.WSConnection;

public class ODataUpdateExecution
extends BaseQueryExecution
implements UpdateExecution {
    private ODataUpdateVisitor visitor;
    private BaseQueryExecution.ODataEntitiesResponse response;

    public ODataUpdateExecution(Command command, ODataExecutionFactory translator, ExecutionContext executionContext, RuntimeMetadata metadata, WSConnection connection) throws TranslatorException {
        super(translator, executionContext, metadata, connection);
        this.visitor = new ODataUpdateVisitor(translator, metadata);
        this.visitor.visitNode((LanguageObject)command);
        if (!this.visitor.exceptions.isEmpty()) {
            throw this.visitor.exceptions.get(0);
        }
    }

    public void close() {
    }

    public void cancel() throws TranslatorException {
    }

    public void execute() throws TranslatorException {
        if (this.visitor.getMethod().equals("DELETE")) {
            BinaryWSProcedureExecution execution = this.executeDirect(this.visitor.getMethod(), this.visitor.buildURL(), null, this.getDefaultHeaders());
            if (execution.getResponseCode() != Response.Status.OK.getStatusCode() && execution.getResponseCode() != Response.Status.NO_CONTENT.getStatusCode()) {
                throw this.buildError(execution);
            }
        } else if (this.visitor.getMethod().equals("PUT")) {
            Schema schema = (Schema)this.visitor.getTable().getParent();
            TeiidEdmMetadata edm = new TeiidEdmMetadata(schema.getName(), ODataEntitySchemaBuilder.buildMetadata(schema));
            BinaryWSProcedureExecution execution = this.executeDirect("GET", this.visitor.buildURL(), null, this.getDefaultHeaders());
            if (execution.getResponseCode() == Response.Status.OK.getStatusCode()) {
                String etag = this.getHeader(execution, "ETag");
                String payload = this.buildPayload(this.visitor.getTable().getName(), this.visitor.getPayload(), (EdmDataServices)edm);
                this.response = this.executeWithReturnEntity(this.visitor.getMethod(), this.visitor.buildURL(), payload, this.visitor.getTable().getName(), (EdmDataServices)edm, etag, Response.Status.OK, Response.Status.NO_CONTENT);
                if (this.response != null && this.response.hasError()) {
                    throw this.response.getError();
                }
            }
        } else if (this.visitor.getMethod().equals("POST")) {
            Schema schema = (Schema)this.visitor.getTable().getParent();
            TeiidEdmMetadata edm = new TeiidEdmMetadata(schema.getName(), ODataEntitySchemaBuilder.buildMetadata(schema));
            String payload = this.buildPayload(this.visitor.getTable().getName(), this.visitor.getPayload(), (EdmDataServices)edm);
            this.response = this.executeWithReturnEntity(this.visitor.getMethod(), this.visitor.buildURL(), payload, this.visitor.getTable().getName(), (EdmDataServices)edm, null, Response.Status.CREATED);
            if (this.response != null && this.response.hasError()) {
                throw this.response.getError();
            }
        }
    }

    private String buildPayload(String entitySet, final List<OProperty<?>> props, EdmDataServices edm) {
        final EdmEntitySet ees = ODataEntitySchemaBuilder.removeModelName(edm.getEdmEntitySet(entitySet));
        Entry entry = new Entry(){

            public String getUri() {
                return null;
            }

            public OEntity getEntity() {
                return OEntities.createRequest((EdmEntitySet)ees, (List)props, null);
            }
        };
        StringWriter sw = new StringWriter();
        FormatWriter fw = FormatWriterFactory.getFormatWriter(Entry.class, null, (String)"ATOM", null);
        fw.write(null, (Writer)sw, (Object)entry);
        return sw.toString();
    }

    public int[] getUpdateCounts() throws DataNotAvailableException, TranslatorException {
        if (this.visitor.getMethod().equals("DELETE")) {
            int[] nArray;
            if (this.response != null) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 1;
            } else {
                int[] nArray3 = new int[1];
                nArray = nArray3;
                nArray3[0] = 0;
            }
            return nArray;
        }
        if (this.visitor.getMethod().equals("PUT")) {
            int[] nArray;
            if (this.response != null) {
                int[] nArray4 = new int[1];
                nArray = nArray4;
                nArray4[0] = 1;
            } else {
                int[] nArray5 = new int[1];
                nArray = nArray5;
                nArray5[0] = 0;
            }
            return nArray;
        }
        if (this.visitor.getMethod().equals("POST") && this.response != null && this.response.hasRow()) {
            if (this.executionContext.getCommandContext().isReturnAutoGeneratedKeys()) {
                this.addAutoGeneretedKeys();
            }
            return new int[]{1};
        }
        return new int[]{0};
    }

    private void addAutoGeneretedKeys() {
        OEntity entity = this.response.getResultsIter().next().getEntity();
        Table table = this.visitor.getEnityTable();
        int cols = table.getPrimaryKey().getColumns().size();
        Class[] columnDataTypes = new Class[cols];
        String[] columnNames = new String[cols];
        for (int i = 0; i < cols; ++i) {
            columnDataTypes[i] = ((Column)table.getPrimaryKey().getColumns().get(i)).getJavaType();
            columnNames[i] = ((Column)table.getPrimaryKey().getColumns().get(i)).getName();
        }
        GeneratedKeys generatedKeys = this.executionContext.getCommandContext().returnGeneratedKeys(columnNames, columnDataTypes);
        ArrayList<Object> vals = new ArrayList<Object>(columnDataTypes.length);
        for (int i = 0; i < columnDataTypes.length; ++i) {
            OProperty prop = entity.getProperty(columnNames[i]);
            Object value = this.translator.retrieveValue(prop.getValue(), columnDataTypes[i]);
            vals.add(value);
        }
        generatedKeys.addKey(vals);
    }
}

