/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata;

import java.util.ArrayList;
import java.util.List;
import org.odata4j.core.OCollection;
import org.odata4j.core.OCollections;
import org.odata4j.core.OObject;
import org.odata4j.core.OProperties;
import org.odata4j.core.OProperty;
import org.odata4j.core.OSimpleObjects;
import org.odata4j.edm.EdmCollectionType;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.edm.EdmType;
import org.teiid.core.BundleUtil;
import org.teiid.language.Array;
import org.teiid.language.ColumnReference;
import org.teiid.language.Delete;
import org.teiid.language.ExpressionValueSource;
import org.teiid.language.Insert;
import org.teiid.language.LanguageObject;
import org.teiid.language.Literal;
import org.teiid.language.SetClause;
import org.teiid.language.Update;
import org.teiid.metadata.Column;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.odata.ODataExecutionFactory;
import org.teiid.translator.odata.ODataPlugin;
import org.teiid.translator.odata.ODataSQLVisitor;
import org.teiid.translator.odata.ODataTypeManager;

public class ODataUpdateVisitor
extends ODataSQLVisitor {
    protected ODataExecutionFactory executionFactory;
    protected RuntimeMetadata metadata;
    protected ArrayList<TranslatorException> exceptions = new ArrayList();
    private String method = "POST";
    private Table entity;
    private List<OProperty<?>> payload;
    private String uri;

    public ODataUpdateVisitor(ODataExecutionFactory executionFactory, RuntimeMetadata metadata) {
        super(executionFactory, metadata);
    }

    public void visit(Insert obj) {
        this.method = "POST";
        this.entity = obj.getTable().getMetadataObject();
        this.uri = this.entity.getName();
        ArrayList props = new ArrayList();
        int elementCount = obj.getColumns().size();
        for (int i = 0; i < elementCount; ++i) {
            Column column = ((ColumnReference)obj.getColumns().get(i)).getMetadataObject();
            List values = ((ExpressionValueSource)obj.getValueSource()).getValues();
            OProperty<?> property = this.readProperty(column, values.get(i));
            props.add(property);
        }
        this.payload = props;
    }

    public void visit(Update obj) {
        this.method = "PUT";
        this.entity = obj.getTable().getMetadataObject();
        this.visitNode((LanguageObject)obj.getTable());
        obj.setWhere(this.buildEntityKey(obj.getWhere()));
        this.uri = this.getEnitityURL();
        if (this.uri.indexOf(40) == -1) {
            this.exceptions.add(new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17011, new Object[]{this.filter.toString()})));
        }
        if (this.filter.length() > 0) {
            this.exceptions.add(new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17009, new Object[]{this.filter.toString()})));
        }
        ArrayList props = new ArrayList();
        int elementCount = obj.getChanges().size();
        for (int i = 0; i < elementCount; ++i) {
            Column column = ((SetClause)obj.getChanges().get(i)).getSymbol().getMetadataObject();
            OProperty<?> property = this.readProperty(column, ((SetClause)obj.getChanges().get(i)).getValue());
            props.add(property);
        }
        this.payload = props;
    }

    private OProperty<?> readProperty(Column column, Object value) {
        if (value instanceof Array) {
            EdmType componentType = ODataTypeManager.odataType(column.getRuntimeType());
            if (componentType instanceof EdmCollectionType) {
                componentType = ((EdmCollectionType)componentType).getItemType();
            }
            OCollection.Builder b = OCollections.newBuilder((EdmType)componentType);
            List values = ((Array)value).getExpressions();
            for (int i = 0; i < values.size(); ++i) {
                Literal literal = (Literal)values.get(i);
                b.add((OObject)OSimpleObjects.create((EdmSimpleType)((EdmSimpleType)componentType), (Object)literal.getValue()));
            }
            return OProperties.collection((String)column.getName(), (EdmCollectionType)new EdmCollectionType(EdmProperty.CollectionKind.Collection, componentType), (OCollection)b.build());
        }
        Literal literal = (Literal)value;
        return OProperties.simple((String)column.getName(), (Object)literal.getValue());
    }

    public void visit(Delete obj) {
        this.method = "DELETE";
        this.entity = obj.getTable().getMetadataObject();
        this.visitNode((LanguageObject)obj.getTable());
        obj.setWhere(this.buildEntityKey(obj.getWhere()));
        this.uri = this.getEnitityURL();
        if (this.uri.indexOf(40) == -1) {
            this.exceptions.add(new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17011, new Object[]{this.filter.toString()})));
        }
        if (this.filter.length() > 0) {
            this.exceptions.add(new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17009, new Object[]{this.filter.toString()})));
        }
    }

    public Table getTable() {
        return this.entity;
    }

    @Override
    public String buildURL() {
        return this.uri;
    }

    public String getMethod() {
        return this.method;
    }

    public List<OProperty<?>> getPayload() {
        return this.payload;
    }
}

