/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.cassandra;

import java.util.List;
import org.teiid.language.Argument;
import org.teiid.language.Command;
import org.teiid.language.Literal;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.cassandra.CassandraConnection;
import org.teiid.translator.cassandra.CassandraQueryExecution;

public class CassandraDirectQueryExecution
extends CassandraQueryExecution
implements ProcedureExecution {
    private String cql;
    private List<Argument> arguments;

    public CassandraDirectQueryExecution(String cql, List<Argument> arguments, Command command, CassandraConnection connection, ExecutionContext context, boolean returnsArray) {
        super(command, connection, context);
        this.arguments = arguments;
        this.cql = cql;
        this.returnsArray = returnsArray;
    }

    @Override
    public void execute() throws TranslatorException {
        StringBuilder buffer = new StringBuilder();
        SQLStringVisitor.parseNativeQueryParts((String)this.cql, this.arguments, (StringBuilder)buffer, (SQLStringVisitor.Substitutor)new SQLStringVisitor.Substitutor(){

            public void substitute(Argument arg, StringBuilder builder, int index) {
                Literal argumentValue = arg.getArgumentValue();
                builder.append(argumentValue);
            }
        });
        String source_cql = buffer.toString();
        this.execute(source_cql);
    }

    public List<?> getOutputParameterValues() throws TranslatorException {
        return null;
    }
}

