/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.cassandra;

import com.datastax.driver.core.GuavaCompatibility;
import com.datastax.driver.core.ResultSetFuture;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.teiid.core.types.BinaryType;
import org.teiid.language.BatchedUpdates;
import org.teiid.language.BulkCommand;
import org.teiid.language.Command;
import org.teiid.language.LanguageObject;
import org.teiid.logging.LogManager;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.cassandra.CassandraConnection;
import org.teiid.translator.cassandra.CassandraSQLVisitor;

public class CassandraUpdateExecution
implements UpdateExecution {
    private CassandraConnection connection;
    private ExecutionContext executionContext;
    private RuntimeMetadata metadata;
    private Command command;
    private int updateCount = 1;
    private ResultSetFuture resultSetFuture;

    public CassandraUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, CassandraConnection connection) {
        this.command = command;
        this.executionContext = executionContext;
        this.metadata = metadata;
        this.connection = connection;
    }

    public void close() {
        this.resultSetFuture = null;
    }

    public void cancel() throws TranslatorException {
        if (this.resultSetFuture != null) {
            this.resultSetFuture.cancel(true);
        }
    }

    public void execute() throws TranslatorException {
        this.internalExecute();
        this.resultSetFuture.addListener(new Runnable(){

            @Override
            public void run() {
                CassandraUpdateExecution.this.executionContext.dataAvailable();
            }
        }, GuavaCompatibility.INSTANCE.sameThreadExecutor());
    }

    private void internalExecute() throws TranslatorException {
        BulkCommand bc;
        if (this.command instanceof BatchedUpdates) {
            this.handleBatchedUpdates();
            return;
        }
        CassandraSQLVisitor visitor = new CassandraSQLVisitor();
        visitor.translateSQL((LanguageObject)this.command);
        String cql = visitor.getTranslatedSQL();
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)"Source-Query:", (Object)cql);
        this.executionContext.logCommand(new Object[]{cql});
        if (this.command instanceof BulkCommand && (bc = (BulkCommand)this.command).getParameterValues() != null) {
            int count = 0;
            ArrayList<Object[]> newValues = new ArrayList<Object[]>();
            Iterator values = bc.getParameterValues();
            while (values.hasNext()) {
                Object[] bindValues = ((List)values.next()).toArray();
                for (int i = 0; i < bindValues.length; ++i) {
                    if (bindValues[i] instanceof Blob) {
                        Blob blob = (Blob)bindValues[i];
                        try {
                            if (blob.length() > Integer.MAX_VALUE) {
                                throw new AssertionError((Object)"Blob is too large");
                            }
                            byte[] bytes = ((Blob)bindValues[i]).getBytes(0L, (int)blob.length());
                            bindValues[i] = ByteBuffer.wrap(bytes);
                            continue;
                        }
                        catch (SQLException e) {
                            throw new TranslatorException((Throwable)e);
                        }
                    }
                    if (!(bindValues[i] instanceof BinaryType)) continue;
                    bindValues[i] = ByteBuffer.wrap(((BinaryType)bindValues[i]).getBytesDirect());
                }
                newValues.add(bindValues);
                ++count;
            }
            this.updateCount = count;
            this.resultSetFuture = this.connection.executeBatch(cql, newValues);
            return;
        }
        this.resultSetFuture = this.connection.executeQuery(cql);
    }

    private void handleBatchedUpdates() {
        BatchedUpdates updates = (BatchedUpdates)this.command;
        ArrayList<String> cqlUpdates = new ArrayList<String>();
        for (Command update : updates.getUpdateCommands()) {
            CassandraSQLVisitor visitor = new CassandraSQLVisitor();
            visitor.translateSQL((LanguageObject)update);
            String cql = visitor.getTranslatedSQL();
            cqlUpdates.add(cql);
        }
        this.updateCount = cqlUpdates.size();
        this.resultSetFuture = this.connection.executeBatch(cqlUpdates);
    }

    public int[] getUpdateCounts() throws DataNotAvailableException, TranslatorException {
        if (!this.resultSetFuture.isDone()) {
            throw DataNotAvailableException.NO_POLLING;
        }
        this.resultSetFuture.getUninterruptibly();
        return new int[]{this.updateCount};
    }
}

