/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.phoenix;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.Assertion;
import org.teiid.language.ColumnReference;
import org.teiid.language.Command;
import org.teiid.language.Comparison;
import org.teiid.language.DerivedColumn;
import org.teiid.language.DerivedTable;
import org.teiid.language.Expression;
import org.teiid.language.LanguageObject;
import org.teiid.language.Limit;
import org.teiid.language.Literal;
import org.teiid.language.QueryExpression;
import org.teiid.language.Select;
import org.teiid.language.SetQuery;
import org.teiid.language.SubqueryComparison;
import org.teiid.language.SubqueryIn;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.JDBCMetadataProcessor;
import org.teiid.translator.jdbc.JDBCUpdateExecution;
import org.teiid.translator.phoenix.PhoenixSQLConversionVisitor;
import org.teiid.translator.phoenix.PhoenixUpdateExecution;
import org.teiid.util.Version;

@Translator(name="phoenix", description="A translator for Phoenix/HBase")
public class PhoenixExecutionFactory
extends JDBCExecutionFactory {
    public static String PHOENIX = "phoenix";
    public static final Version V_4_8 = Version.getVersion((String)"4.8");

    public void start() throws TranslatorException {
        super.start();
        this.registerFunctionModifier("substring", (FunctionModifier)new AliasModifier("SUBSTR"));
        this.registerFunctionModifier("ucase", (FunctionModifier)new AliasModifier("UPPER"));
        this.registerFunctionModifier("lcase", (FunctionModifier)new AliasModifier("LOWER"));
        this.registerFunctionModifier("locate", (FunctionModifier)new AliasModifier("INSTR"));
        this.registerFunctionModifier("parsetimestamp", (FunctionModifier)new AliasModifier("TO_TIMESTAMP"));
        this.registerFunctionModifier("curtime", (FunctionModifier)new AliasModifier("CURRENT_TIME"));
        this.registerFunctionModifier("log", (FunctionModifier)new AliasModifier("LN"));
        this.registerFunctionModifier("log10", (FunctionModifier)new AliasModifier("LOG"));
        this.registerFunctionModifier("parsebigdecimal", (FunctionModifier)new AliasModifier("TO_NUMBER"));
        this.addPushDownFunction(PHOENIX, "REVERSE", "string", new String[]{"string"});
        this.addPushDownFunction(PHOENIX, "REGEXP_SUBSTR", "string", new String[]{"string", "string", "integer"});
        this.addPushDownFunction(PHOENIX, "REGEXP_REPLACE", "string", new String[]{"string", "string", "string"});
        this.addPushDownFunction(PHOENIX, "REGEXP_SPLIT", "object", new String[]{"string", "string"});
        this.addPushDownFunction(PHOENIX, "TO_DATE", "date", new String[]{"string", "string", "string"});
        this.addPushDownFunction(PHOENIX, "TO_TIME", "time", new String[]{"string", "string", "string"});
        this.addPushDownFunction(PHOENIX, "TIMEZONE_OFFSET", "integer", new String[]{"string", "date"});
        this.addPushDownFunction(PHOENIX, "TIMEZONE_OFFSET", "integer", new String[]{"string", "time"});
        this.addPushDownFunction(PHOENIX, "TIMEZONE_OFFSET", "integer", new String[]{"string", "timestamp"});
        this.addPushDownFunction(PHOENIX, "CONVERT_TZ", "date", new String[]{"date", "string", "string"});
        this.addPushDownFunction(PHOENIX, "CONVERT_TZ", "time", new String[]{"time", "string", "string"});
    }

    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getSupportedFunctions());
        supportedFunctions.add("substring");
        supportedFunctions.add("locate");
        supportedFunctions.add("trim");
        supportedFunctions.add("ltrim");
        supportedFunctions.add("rtrim");
        supportedFunctions.add("lpad");
        supportedFunctions.add("length");
        supportedFunctions.add("ucase");
        supportedFunctions.add("lcase");
        supportedFunctions.add("parsetimestamp");
        supportedFunctions.add("curtime");
        supportedFunctions.add("now");
        supportedFunctions.add("year");
        supportedFunctions.add("month");
        supportedFunctions.add("week");
        supportedFunctions.add("dayofmonth");
        supportedFunctions.add("hour");
        supportedFunctions.add("minute");
        supportedFunctions.add("second");
        supportedFunctions.add("sign");
        supportedFunctions.add("abs");
        supportedFunctions.add("sqrt");
        supportedFunctions.add("exp");
        supportedFunctions.add("power");
        supportedFunctions.add("log");
        supportedFunctions.add("log10");
        supportedFunctions.add("rand");
        supportedFunctions.add("round");
        supportedFunctions.add("floor");
        supportedFunctions.add("parsebigdecimal");
        return supportedFunctions;
    }

    public void initCapabilities(Connection connection) throws TranslatorException {
        super.initCapabilities(connection);
        if (this.getVersion().compareTo(V_4_8) >= 0) {
            this.setSupportsInnerJoins(true);
            this.setSupportsOuterJoins(true);
            this.setSupportsFullOuterJoins(true);
        }
    }

    public JDBCUpdateExecution createUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, Connection conn) throws TranslatorException {
        return new PhoenixUpdateExecution(command, executionContext, metadata, conn, this);
    }

    public PhoenixSQLConversionVisitor getSQLConversionVisitor() {
        return new PhoenixSQLConversionVisitor(this);
    }

    public void bindValue(PreparedStatement pstmt, Object param, Class<?> paramType, int i) throws SQLException {
        int type = TypeFacility.getSQLTypeFromRuntimeType(paramType);
        if (param == null) {
            pstmt.setNull(i, type);
            return;
        }
        if (paramType.equals(TypeFacility.RUNTIME_TYPES.STRING)) {
            pstmt.setString(i, String.valueOf(param));
            return;
        }
        if (paramType.equals(TypeFacility.RUNTIME_TYPES.VARBINARY)) {
            byte[] bytes = param instanceof BinaryType ? ((BinaryType)param).getBytesDirect() : (byte[])param;
            pstmt.setBytes(i, bytes);
            return;
        }
        if (paramType.equals(TypeFacility.RUNTIME_TYPES.CHAR)) {
            pstmt.setString(i, String.valueOf(param));
            return;
        }
        if (paramType.equals(TypeFacility.RUNTIME_TYPES.BOOLEAN)) {
            pstmt.setBoolean(i, (Boolean)param);
            return;
        }
        if (paramType.equals(TypeFacility.RUNTIME_TYPES.BYTE)) {
            pstmt.setByte(i, (Byte)param);
            return;
        }
        if (paramType.equals(TypeFacility.RUNTIME_TYPES.SHORT)) {
            pstmt.setShort(i, (Short)param);
            return;
        }
        if (paramType.equals(TypeFacility.RUNTIME_TYPES.INTEGER)) {
            pstmt.setInt(i, (Integer)param);
            return;
        }
        if (paramType.equals(TypeFacility.RUNTIME_TYPES.LONG)) {
            pstmt.setLong(i, (Long)param);
            return;
        }
        if (paramType.equals(TypeFacility.RUNTIME_TYPES.FLOAT)) {
            pstmt.setFloat(i, ((Float)param).floatValue());
            return;
        }
        if (paramType.equals(TypeFacility.RUNTIME_TYPES.DOUBLE)) {
            pstmt.setDouble(i, (Double)param);
            return;
        }
        if (paramType.equals(TypeFacility.RUNTIME_TYPES.BIG_DECIMAL)) {
            pstmt.setBigDecimal(i, (BigDecimal)param);
            return;
        }
        if (paramType.equals(TypeFacility.RUNTIME_TYPES.DATE)) {
            pstmt.setDate(i, (Date)param, this.getDatabaseCalendar());
            return;
        }
        if (paramType.equals(TypeFacility.RUNTIME_TYPES.TIME)) {
            pstmt.setTime(i, (Time)param, this.getDatabaseCalendar());
            return;
        }
        if (paramType.equals(TypeFacility.RUNTIME_TYPES.TIMESTAMP)) {
            pstmt.setTimestamp(i, (Timestamp)param, this.getDatabaseCalendar());
            return;
        }
        if (this.useStreamsForLobs()) {
            // empty if block
        }
        pstmt.setObject(i, param, type);
    }

    public boolean supportsInsertWithQueryExpression() {
        return true;
    }

    public String translateLiteralBoolean(Boolean booleanValue) {
        if (booleanValue.booleanValue()) {
            return "true";
        }
        return "false";
    }

    public List<?> translate(LanguageObject obj, ExecutionContext context) {
        if (obj instanceof SubqueryIn) {
            SubqueryIn in = (SubqueryIn)obj;
            return Arrays.asList(new SubqueryComparison(in.getLeftExpression(), in.isNegated() ? Comparison.Operator.NE : Comparison.Operator.EQ, in.isNegated() ? SubqueryComparison.Quantifier.ALL : SubqueryComparison.Quantifier.SOME, in.getSubquery()));
        }
        if (!(obj instanceof Literal)) {
            return super.translate(obj, context);
        }
        Literal l = (Literal)obj;
        if (l.isBindEligible() || l.getType() != TypeFacility.RUNTIME_TYPES.BIG_DECIMAL) {
            return super.translate(obj, context);
        }
        BigDecimal bd = (BigDecimal)l.getValue();
        if (bd.scale() == 0) {
            l.setValue((Object)bd.setScale(1));
        }
        return null;
    }

    public String translateLiteralDate(Date dateValue) {
        return "DATE '" + this.formatDateValue(new Timestamp(dateValue.getTime())) + "'";
    }

    public String translateLiteralTime(Time timeValue) {
        return "TIME '" + this.formatDateValue(new Timestamp(timeValue.getTime())) + "'";
    }

    public String translateLiteralTimestamp(Timestamp timestampValue) {
        return "TIMESTAMP '" + this.formatDateValue(timestampValue) + "'";
    }

    public Object retrieveValue(ResultSet results, int columnIndex, Class<?> expectedType) throws SQLException {
        Integer code = DataTypeManager.getTypeCode(expectedType);
        if (code != null) {
            switch (code) {
                case 12: {
                    return results.getTime(columnIndex);
                }
                case 11: {
                    return results.getDate(columnIndex);
                }
                case 13: {
                    return results.getTimestamp(columnIndex);
                }
            }
        }
        return super.retrieveValue(results, columnIndex, expectedType);
    }

    protected JDBCMetadataProcessor createMetadataProcessor() {
        JDBCMetadataProcessor processor = new JDBCMetadataProcessor(){

            protected boolean getIndexInfoForTable(String catalogName, String schemaName, String tableName, boolean uniqueOnly, boolean approximateIndexes, String tableType) {
                return !uniqueOnly;
            }
        };
        processor.setImportForeignKeys(false);
        return processor;
    }

    public Character getRequiredLikeEscape() {
        return Character.valueOf('\\');
    }

    public List<?> translateCommand(Command command, ExecutionContext context) {
        SetQuery set;
        if (command instanceof SetQuery && !(set = (SetQuery)command).isAll()) {
            Select s = new Select();
            s.setDistinct(true);
            s.setDerivedColumns(new ArrayList());
            s.setOrderBy(set.getOrderBy());
            for (DerivedColumn dc : set.getProjectedQuery().getDerivedColumns()) {
                Assertion.assertTrue((dc.getAlias() != null ? 1 : 0) != 0);
                ColumnReference cr = new ColumnReference(null, dc.getAlias(), null, dc.getExpression().getType());
                s.getDerivedColumns().add(new DerivedColumn(null, (Expression)cr));
            }
            set.setOrderBy(null);
            s.setLimit(set.getLimit());
            set.setLimit(null);
            set.setAll(true);
            s.setFrom(Arrays.asList(new DerivedTable((QueryExpression)set, "x")));
            return Arrays.asList(s);
        }
        return super.translateCommand(command, context);
    }

    public List<?> translateLimit(Limit limit, ExecutionContext context) {
        if (limit.getRowOffset() > 0) {
            return Arrays.asList("LIMIT ", limit.getRowLimit(), " OFFSET ", limit.getRowOffset());
        }
        return super.translateLimit(limit, context);
    }

    public boolean supportsRowLimit() {
        return true;
    }

    public boolean supportsScalarSubqueryProjection() {
        return false;
    }

    public boolean supportsUpsert() {
        return true;
    }

    protected boolean usesDatabaseVersion() {
        return true;
    }

    public boolean supportsRowOffset() {
        return this.getVersion().compareTo(V_4_8) >= 0;
    }
}

