/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.phoenix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.teiid.language.ColumnReference;
import org.teiid.language.DerivedColumn;
import org.teiid.language.Expression;
import org.teiid.language.ExpressionValueSource;
import org.teiid.language.Insert;
import org.teiid.language.InsertValueSource;
import org.teiid.language.LanguageObject;
import org.teiid.language.Like;
import org.teiid.language.Select;
import org.teiid.language.SetClause;
import org.teiid.language.Update;
import org.teiid.metadata.Column;
import org.teiid.metadata.KeyRecord;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.SQLConversionVisitor;
import org.teiid.translator.phoenix.PhoenixExecutionFactory;

public class PhoenixSQLConversionVisitor
extends SQLConversionVisitor {
    private PhoenixExecutionFactory executionFactory;

    public PhoenixSQLConversionVisitor(PhoenixExecutionFactory ef) {
        super((JDBCExecutionFactory)ef);
        this.executionFactory = ef;
    }

    protected String getInsertKeyword() {
        return "UPSERT";
    }

    public void visit(Like obj) {
        obj.setEscapeCharacter(null);
        super.visit(obj);
    }

    public void visit(Update update) {
        ArrayList<ColumnReference> cols = new ArrayList<ColumnReference>();
        ArrayList<Expression> vals = new ArrayList<Expression>();
        for (SetClause set : update.getChanges()) {
            cols.add(set.getSymbol());
            vals.add(set.getValue());
        }
        Insert insert = null;
        if (update.getWhere() == null) {
            insert = new Insert(update.getTable(), cols, (InsertValueSource)new ExpressionValueSource(vals));
        } else {
            ArrayList<DerivedColumn> select = new ArrayList<DerivedColumn>();
            HashSet<Column> columns = new HashSet<Column>();
            for (ColumnReference columnReference : cols) {
                columns.add(columnReference.getMetadataObject());
            }
            for (Expression expression : vals) {
                select.add(new DerivedColumn(null, expression));
            }
            KeyRecord pk = update.getTable().getMetadataObject().getPrimaryKey();
            if (pk != null) {
                for (Column c : pk.getColumns()) {
                    if (columns.contains(c)) continue;
                    ColumnReference cr = new ColumnReference(update.getTable(), c.getName(), c, c.getJavaType());
                    select.add(new DerivedColumn(null, (Expression)cr));
                    cols.add(cr);
                }
            }
            Select select2 = new Select(select, false, Arrays.asList(update.getTable()), update.getWhere(), null, null, null);
            insert = new Insert(update.getTable(), cols, (InsertValueSource)select2);
        }
        this.append((LanguageObject)insert);
    }

    public String getSQL() {
        return this.buffer.toString();
    }
}

