/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.phoenix;

import java.sql.Connection;
import java.sql.SQLException;
import org.teiid.core.BundleUtil;
import org.teiid.language.Command;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.JDBCExecutionException;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.JDBCUpdateExecution;
import org.teiid.translator.jdbc.TranslatedCommand;
import org.teiid.translator.phoenix.PhoenixExecutionFactory;
import org.teiid.translator.phoenix.PhoenixPlugin;

public class PhoenixUpdateExecution
extends JDBCUpdateExecution {
    private TranslatedCommand translatedComm = null;

    public PhoenixUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, Connection conn, PhoenixExecutionFactory executionFactory) throws TranslatorException {
        super(command, conn, executionContext, (JDBCExecutionFactory)executionFactory);
        this.setCommitMode(conn);
        this.translatedComm = this.translateCommand(command);
    }

    private void setCommitMode(Connection conn) throws JDBCExecutionException {
        try {
            if (!conn.getAutoCommit()) {
                conn.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            throw new JDBCExecutionException((BundleUtil.Event)PhoenixPlugin.Event.TEIID27003, e, this.command.toString());
        }
    }

    protected TranslatedCommand translateCommand(Command command) throws TranslatorException {
        if (null == this.translatedComm) {
            this.translatedComm = super.translateCommand(command);
        }
        return this.translatedComm;
    }
}

