/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.metrics;

import java.util.List;
import org.simmetrics.ListMetric;
import org.simmetrics.StringMetric;

public class MongeElkan
implements ListMetric<String> {
    private final StringMetric metric;

    public MongeElkan(StringMetric metric) {
        this.metric = metric;
    }

    @Override
    public float compare(List<String> a, List<String> b) {
        if (a.isEmpty() && b.isEmpty()) {
            return 1.0f;
        }
        if (a.isEmpty() || b.isEmpty()) {
            return 0.0f;
        }
        return (float)Math.sqrt(this.similarity(a, b) * this.similarity(b, a));
    }

    private float similarity(List<String> a, List<String> b) {
        float sum = 0.0f;
        for (String s : a) {
            float max = 0.0f;
            for (String q : b) {
                max = Math.max(max, this.metric.compare(s, q));
            }
            sum += max;
        }
        return sum / (float)a.size();
    }

    public String toString() {
        return "MongeElkan [metric=" + this.metric + "]";
    }
}

