/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.api.edm.provider.CsdlAction;
import org.apache.olingo.commons.api.edm.provider.CsdlActionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotatable;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotations;
import org.apache.olingo.commons.api.edm.provider.CsdlBindingTarget;
import org.apache.olingo.commons.api.edm.provider.CsdlComplexType;
import org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainer;
import org.apache.olingo.commons.api.edm.provider.CsdlEntitySet;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityType;
import org.apache.olingo.commons.api.edm.provider.CsdlEnumMember;
import org.apache.olingo.commons.api.edm.provider.CsdlEnumType;
import org.apache.olingo.commons.api.edm.provider.CsdlFunction;
import org.apache.olingo.commons.api.edm.provider.CsdlFunctionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlNavigationProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlNavigationPropertyBinding;
import org.apache.olingo.commons.api.edm.provider.CsdlOnDelete;
import org.apache.olingo.commons.api.edm.provider.CsdlOnDeleteAction;
import org.apache.olingo.commons.api.edm.provider.CsdlOperation;
import org.apache.olingo.commons.api.edm.provider.CsdlParameter;
import org.apache.olingo.commons.api.edm.provider.CsdlProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlPropertyRef;
import org.apache.olingo.commons.api.edm.provider.CsdlReferentialConstraint;
import org.apache.olingo.commons.api.edm.provider.CsdlReturnType;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;
import org.apache.olingo.commons.api.edm.provider.CsdlSingleton;
import org.apache.olingo.commons.api.edm.provider.CsdlTerm;
import org.apache.olingo.commons.api.edm.provider.CsdlTypeDefinition;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlAnnotationPath;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlApply;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlCast;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlCollection;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlConstantExpression;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlExpression;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlIf;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlIsOf;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlLabeledElement;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlLabeledElementReference;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlNavigationPropertyPath;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlNull;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlPath;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlPropertyPath;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlPropertyValue;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlRecord;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlUrlRef;
import org.apache.olingo.commons.api.edmx.EdmxReference;
import org.apache.olingo.commons.api.edmx.EdmxReferenceInclude;
import org.apache.olingo.commons.api.edmx.EdmxReferenceIncludeAnnotation;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.core.ReferenceResolver;
import org.apache.olingo.server.core.SchemaBasedEdmProvider;
import org.apache.olingo.server.core.ServiceMetadataImpl;

public class MetadataParser {
    private boolean parseAnnotations = false;
    private static final String XML_LINK_NS = "http://www.w3.org/1999/xlink";
    private ReferenceResolver referenceResolver = new DefaultReferenceResolver();
    private boolean useLocalCoreVocabularies = true;
    private boolean implicitlyLoadCoreVocabularies = false;
    private boolean recursivelyLoadReferences = false;
    private Map<String, SchemaBasedEdmProvider> globalReferenceMap = new HashMap<String, SchemaBasedEdmProvider>();

    public MetadataParser parseAnnotations(boolean parse) {
        this.parseAnnotations = parse;
        return this;
    }

    public MetadataParser referenceResolver(ReferenceResolver resolver) {
        this.referenceResolver = resolver;
        return this;
    }

    public MetadataParser useLocalCoreVocabularies(boolean load) {
        this.useLocalCoreVocabularies = load;
        return this;
    }

    public MetadataParser recursivelyLoadReferences(boolean load) {
        this.recursivelyLoadReferences = load;
        return this;
    }

    public MetadataParser implicitlyLoadCoreVocabularies(boolean load) {
        this.implicitlyLoadCoreVocabularies = load;
        return this;
    }

    public ServiceMetadata buildServiceMetadata(Reader csdl) throws XMLStreamException {
        SchemaBasedEdmProvider provider = this.buildEdmProvider(csdl, this.referenceResolver, this.implicitlyLoadCoreVocabularies, this.useLocalCoreVocabularies, true, null);
        return new ServiceMetadataImpl((CsdlEdmProvider)provider, provider.getReferences(), null);
    }

    public SchemaBasedEdmProvider buildEdmProvider(Reader csdl) throws XMLStreamException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        XMLEventReader reader = xmlInputFactory.createXMLEventReader(csdl);
        return this.buildEdmProvider(reader, this.referenceResolver, this.implicitlyLoadCoreVocabularies, this.useLocalCoreVocabularies, true, null);
    }

    protected SchemaBasedEdmProvider buildEdmProvider(Reader csdl, ReferenceResolver resolver, boolean loadCore, boolean useLocal, boolean loadReferenceSchemas, String namespace) throws XMLStreamException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        XMLEventReader reader = xmlInputFactory.createXMLEventReader(csdl);
        return this.buildEdmProvider(reader, resolver, loadCore, useLocal, loadReferenceSchemas, namespace);
    }

    protected SchemaBasedEdmProvider buildEdmProvider(InputStream csdl, ReferenceResolver resolver, boolean loadCore, boolean useLocal, boolean loadReferenceSchemas, String namespace) throws XMLStreamException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        XMLEventReader reader = xmlInputFactory.createXMLEventReader(csdl);
        return this.buildEdmProvider(reader, resolver, loadCore, useLocal, loadReferenceSchemas, namespace);
    }

    protected SchemaBasedEdmProvider buildEdmProvider(XMLEventReader reader, ReferenceResolver resolver, boolean loadCore, boolean useLocal, boolean loadReferenceSchemas, String namespace) throws XMLStreamException {
        SchemaBasedEdmProvider provider = new SchemaBasedEdmProvider();
        final StringBuilder xmlBase = new StringBuilder();
        new ElementReader<SchemaBasedEdmProvider>(){

            @Override
            void build(XMLEventReader reader, StartElement element, SchemaBasedEdmProvider provider, String name) throws XMLStreamException {
                String version;
                if (MetadataParser.attrNS(element, MetadataParser.XML_LINK_NS, "base") != null) {
                    xmlBase.append(MetadataParser.attrNS(element, MetadataParser.XML_LINK_NS, "base"));
                }
                if (!"4.0".equals(version = MetadataParser.attr(element, "Version"))) {
                    throw new XMLStreamException("Currently only V4 is supported.");
                }
                MetadataParser.this.readDataServicesAndReference(reader, element, provider);
            }
        }.read(reader, null, provider, "Edmx");
        if (reader.hasNext()) {
            XMLEvent event = reader.peek();
            throw new XMLStreamException("Failed to read complete metadata file. Failed at " + (event.isStartElement() ? event.asStartElement().getName().getLocalPart() : event.asEndElement().getName().getLocalPart()));
        }
        if (loadCore) {
            this.loadCoreVocabulary(provider, "Org.OData.Core.V1");
            this.loadCoreVocabulary(provider, "Org.OData.Capabilities.V1");
            this.loadCoreVocabulary(provider, "Org.OData.Measures.V1");
        }
        if (namespace != null && !namespace.equals("") && !this.globalReferenceMap.containsKey(namespace)) {
            this.globalReferenceMap.put(namespace, provider);
        }
        if (resolver != null && loadReferenceSchemas) {
            this.loadReferencesSchemas(provider, xmlBase.length() == 0 ? null : this.fixXmlBase(xmlBase.toString()), resolver, loadCore, useLocal);
        }
        return provider;
    }

    private void loadReferencesSchemas(SchemaBasedEdmProvider provider, String xmlBase, ReferenceResolver resolver, boolean loadCore, boolean useLocal) {
        for (EdmxReference reference : provider.getReferences()) {
            try {
                SchemaBasedEdmProvider refProvider = null;
                for (EdmxReferenceInclude include : reference.getIncludes()) {
                    if (provider.getSchemaDirectly(include.getNamespace()) != null) continue;
                    if (this.isCoreVocabulary(include.getNamespace()) && useLocal) {
                        this.loadCoreVocabulary(provider, include.getNamespace());
                        continue;
                    }
                    refProvider = this.globalReferenceMap.get(include.getNamespace());
                    if (refProvider == null) {
                        InputStream is = this.referenceResolver.resolveReference(reference.getUri(), xmlBase);
                        if (is == null) {
                            throw new EdmException("Failed to load Reference " + reference.getUri() + " loading failed");
                        }
                        refProvider = this.buildEdmProvider(is, resolver, false, useLocal, this.recursivelyLoadReferences, include.getNamespace());
                    }
                    if (refProvider == null) continue;
                    CsdlSchema refSchema = refProvider.getSchema(include.getNamespace(), false);
                    provider.addReferenceSchema(include.getNamespace(), refProvider);
                    if (include.getAlias() == null) continue;
                    refSchema.setAlias(include.getAlias());
                    provider.addReferenceSchema(include.getAlias(), refProvider);
                }
            }
            catch (XMLStreamException e) {
                throw new EdmException("Failed to load Reference " + reference.getUri() + " parsing failed");
            }
        }
    }

    private void loadCoreVocabulary(SchemaBasedEdmProvider provider, String namespace) throws XMLStreamException {
        if ("Org.OData.Core.V1".equalsIgnoreCase(namespace)) {
            this.loadLocalVocabularySchema(provider, "Org.OData.Core.V1", "Org.OData.Core.V1.xml");
        } else if ("Org.OData.Capabilities.V1".equalsIgnoreCase(namespace)) {
            this.loadLocalVocabularySchema(provider, "Org.OData.Capabilities.V1", "Org.OData.Capabilities.V1.xml");
        } else if ("Org.OData.Measures.V1".equalsIgnoreCase(namespace)) {
            this.loadLocalVocabularySchema(provider, "Org.OData.Measures.V1", "Org.OData.Measures.V1.xml");
        }
    }

    private boolean isCoreVocabulary(String namespace) {
        return "Org.OData.Core.V1".equalsIgnoreCase(namespace) || "Org.OData.Capabilities.V1".equalsIgnoreCase(namespace) || "Org.OData.Measures.V1".equalsIgnoreCase(namespace);
    }

    private String fixXmlBase(String base) {
        if (base.endsWith("/")) {
            return base;
        }
        return base + "/";
    }

    private void loadLocalVocabularySchema(SchemaBasedEdmProvider provider, String namespace, String resource) throws XMLStreamException {
        CsdlSchema schema = provider.getVocabularySchema(namespace);
        if (schema == null) {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(resource);
            if (is != null) {
                SchemaBasedEdmProvider childProvider = this.buildEdmProvider(is, null, false, false, true, "");
                provider.addVocabularySchema(namespace, childProvider);
            } else {
                throw new XMLStreamException("failed to load " + resource + " core vocabulary");
            }
        }
    }

    private void readDataServicesAndReference(XMLEventReader reader, StartElement element, SchemaBasedEdmProvider provider) throws XMLStreamException {
        new ElementReader<SchemaBasedEdmProvider>(){

            @Override
            void build(XMLEventReader reader, StartElement element, SchemaBasedEdmProvider provider, String name) throws XMLStreamException {
                if ("DataServices".equals(name)) {
                    MetadataParser.this.readSchema(reader, element, provider);
                } else if ("Reference".equals(name)) {
                    MetadataParser.this.readReference(reader, element, provider, "Reference");
                }
            }
        }.read(reader, element, provider, "DataServices", "Reference");
    }

    private void readReference(XMLEventReader reader, StartElement element, SchemaBasedEdmProvider provider, String name) throws XMLStreamException {
        EdmxReference reference;
        try {
            String uri = MetadataParser.attr(element, "Uri");
            reference = new EdmxReference(new URI(uri));
        }
        catch (URISyntaxException e) {
            throw new XMLStreamException(e);
        }
        new ElementReader<EdmxReference>(){

            @Override
            void build(XMLEventReader reader, StartElement element, EdmxReference reference, String name) throws XMLStreamException {
                if ("Include".equals(name)) {
                    EdmxReferenceInclude include = new EdmxReferenceInclude(MetadataParser.attr(element, "Namespace"), MetadataParser.attr(element, "Alias"));
                    reference.addInclude(include);
                } else if ("IncludeAnnotations".equals(name)) {
                    EdmxReferenceIncludeAnnotation annotation = new EdmxReferenceIncludeAnnotation(MetadataParser.attr(element, "TermNamespace"));
                    annotation.setTargetNamespace(MetadataParser.attr(element, "TargetNamespace"));
                    annotation.setQualifier(MetadataParser.attr(element, "Qualifier"));
                    reference.addIncludeAnnotation(annotation);
                } else if ("Annotation".equals(name)) {
                    MetadataParser.this.readAnnotations(reader, element, (CsdlAnnotatable)reference);
                }
            }
        }.read(reader, element, reference, "Include", "IncludeAnnotations", "Annotation");
        provider.addReference(reference);
    }

    private void readSchema(XMLEventReader reader, StartElement element, SchemaBasedEdmProvider provider) throws XMLStreamException {
        new ElementReader<SchemaBasedEdmProvider>(){

            @Override
            void build(XMLEventReader reader, StartElement element, SchemaBasedEdmProvider provider, String name) throws XMLStreamException {
                CsdlSchema schema = new CsdlSchema();
                schema.setComplexTypes(new ArrayList());
                schema.setActions(new ArrayList());
                schema.setEntityTypes(new ArrayList());
                schema.setEnumTypes(new ArrayList());
                schema.setFunctions(new ArrayList());
                schema.setTerms(new ArrayList());
                schema.setTypeDefinitions(new ArrayList());
                schema.setNamespace(MetadataParser.attr(element, "Namespace"));
                schema.setAlias(MetadataParser.attr(element, "Alias"));
                MetadataParser.this.readSchemaContents(reader, schema);
                provider.addSchema(schema);
            }
        }.read(reader, element, provider, "Schema");
    }

    private void readSchemaContents(XMLEventReader reader, CsdlSchema schema) throws XMLStreamException {
        new ElementReader<CsdlSchema>(){

            @Override
            void build(XMLEventReader reader, StartElement element, CsdlSchema schema, String name) throws XMLStreamException {
                if ("Action".equals(name)) {
                    MetadataParser.this.readAction(reader, element, schema);
                } else if ("Annotations".equals(name)) {
                    MetadataParser.this.readAnnotationGroup(reader, element, schema);
                } else if ("Annotation".equals(name)) {
                    MetadataParser.this.readAnnotations(reader, element, (CsdlAnnotatable)schema);
                } else if ("ComplexType".equals(name)) {
                    MetadataParser.this.readComplexType(reader, element, schema);
                } else if ("EntityContainer".equals(name)) {
                    MetadataParser.this.readEntityContainer(reader, element, schema);
                } else if ("EntityType".equals(name)) {
                    MetadataParser.this.readEntityType(reader, element, schema);
                } else if ("EnumType".equals(name)) {
                    MetadataParser.this.readEnumType(reader, element, schema);
                } else if ("Function".equals(name)) {
                    MetadataParser.this.readFunction(reader, element, schema);
                } else if ("Term".equals(name)) {
                    schema.getTerms().add(MetadataParser.this.readTerm(reader, element));
                } else if ("TypeDefinition".equals(name)) {
                    schema.getTypeDefinitions().add(MetadataParser.this.readTypeDefinition(reader, element));
                }
            }
        }.read(reader, null, schema, "Action", "Annotations", "Annotation", "ComplexType", "EntityContainer", "EntityType", "EnumType", "Function", "Term", "TypeDefinition");
    }

    private void readAction(XMLEventReader reader, StartElement element, CsdlSchema schema) throws XMLStreamException {
        CsdlAction action = new CsdlAction();
        action.setParameters(new ArrayList());
        action.setName(MetadataParser.attr(element, "Name"));
        action.setBound(Boolean.parseBoolean(MetadataParser.attr(element, "IsBound")));
        String entitySetPath = MetadataParser.attr(element, "EntitySetPath");
        if (entitySetPath != null) {
            action.setEntitySetPath(entitySetPath);
        }
        this.readOperationParameters(reader, (CsdlOperation)action);
        schema.getActions().add(action);
    }

    private FullQualifiedName readType(StartElement element) {
        String type = MetadataParser.attr(element, "Type");
        if (type != null && type.startsWith("Collection(") && type.endsWith(")")) {
            return new FullQualifiedName(type.substring(11, type.length() - 1));
        }
        return new FullQualifiedName(type);
    }

    private boolean isCollectionType(StartElement element) {
        String type = MetadataParser.attr(element, "Type");
        return type != null && type.startsWith("Collection(") && type.endsWith(")");
    }

    private void readReturnType(XMLEventReader reader, StartElement element, CsdlOperation operation) throws XMLStreamException {
        String srid;
        String scale;
        String precision;
        CsdlReturnType returnType = new CsdlReturnType();
        returnType.setType(this.readType(element));
        returnType.setCollection(this.isCollectionType(element));
        returnType.setNullable(Boolean.parseBoolean(MetadataParser.attr(element, "Nullable")));
        String maxLength = MetadataParser.attr(element, "MaxLength");
        if (maxLength != null) {
            returnType.setMaxLength(Integer.valueOf(Integer.parseInt(maxLength)));
        }
        if ((precision = MetadataParser.attr(element, "Precision")) != null) {
            returnType.setPrecision(Integer.valueOf(Integer.parseInt(precision)));
        }
        if ((scale = MetadataParser.attr(element, "Scale")) != null) {
            returnType.setScale(Integer.valueOf(Integer.parseInt(scale)));
        }
        if ((srid = MetadataParser.attr(element, "SRID")) != null) {
            returnType.setSrid(SRID.valueOf((String)srid));
        }
        this.peekAnnotations(reader, element.getName().getLocalPart(), (CsdlAnnotatable)returnType);
        operation.setReturnType(returnType);
    }

    private void readParameter(XMLEventReader reader, StartElement element, CsdlOperation operation) throws XMLStreamException {
        String srid;
        String scale;
        String precision;
        CsdlParameter parameter = new CsdlParameter();
        parameter.setName(MetadataParser.attr(element, "Name"));
        parameter.setType(this.readType(element));
        parameter.setCollection(this.isCollectionType(element));
        parameter.setNullable(Boolean.parseBoolean(MetadataParser.attr(element, "Nullable")));
        String maxLength = MetadataParser.attr(element, "MaxLength");
        if (maxLength != null) {
            parameter.setMaxLength(Integer.valueOf(Integer.parseInt(maxLength)));
        }
        if ((precision = MetadataParser.attr(element, "Precision")) != null) {
            parameter.setPrecision(Integer.valueOf(Integer.parseInt(precision)));
        }
        if ((scale = MetadataParser.attr(element, "Scale")) != null) {
            parameter.setScale(Integer.valueOf(Integer.parseInt(scale)));
        }
        if ((srid = MetadataParser.attr(element, "SRID")) != null) {
            parameter.setSrid(SRID.valueOf((String)srid));
        }
        this.peekAnnotations(reader, element.getName().getLocalPart(), (CsdlAnnotatable)parameter);
        operation.getParameters().add(parameter);
    }

    private CsdlTypeDefinition readTypeDefinition(XMLEventReader reader, StartElement element) throws XMLStreamException {
        String srid;
        String scale;
        String precision;
        String maxLength;
        CsdlTypeDefinition td = new CsdlTypeDefinition();
        td.setName(MetadataParser.attr(element, "Name"));
        td.setUnderlyingType(new FullQualifiedName(MetadataParser.attr(element, "UnderlyingType")));
        if (MetadataParser.attr(element, "Unicode") != null) {
            td.setUnicode(Boolean.parseBoolean(MetadataParser.attr(element, "Unicode")));
        }
        if ((maxLength = MetadataParser.attr(element, "MaxLength")) != null) {
            td.setMaxLength(Integer.valueOf(Integer.parseInt(maxLength)));
        }
        if ((precision = MetadataParser.attr(element, "Precision")) != null) {
            td.setPrecision(Integer.valueOf(Integer.parseInt(precision)));
        }
        if ((scale = MetadataParser.attr(element, "Scale")) != null) {
            td.setScale(Integer.valueOf(Integer.parseInt(scale)));
        }
        if ((srid = MetadataParser.attr(element, "SRID")) != null) {
            td.setSrid(SRID.valueOf((String)srid));
        }
        this.peekAnnotations(reader, element.getName().getLocalPart(), (CsdlAnnotatable)td);
        return td;
    }

    private CsdlTerm readTerm(XMLEventReader reader, StartElement element) throws XMLStreamException {
        String srid;
        String scale;
        String precision;
        CsdlTerm term = new CsdlTerm();
        term.setName(MetadataParser.attr(element, "Name"));
        term.setType(MetadataParser.attr(element, "Type"));
        if (MetadataParser.attr(element, "BaseTerm") != null) {
            term.setBaseTerm(MetadataParser.attr(element, "BaseTerm"));
        }
        if (MetadataParser.attr(element, "DefaultValue") != null) {
            term.setDefaultValue(MetadataParser.attr(element, "DefaultValue"));
        }
        if (MetadataParser.attr(element, "AppliesTo") != null) {
            String[] appliesTo = MetadataParser.attr(element, "AppliesTo").split("\\s+");
            term.setAppliesTo(Arrays.asList(appliesTo));
        }
        term.setNullable(Boolean.parseBoolean(MetadataParser.attr(element, "Nullable")));
        String maxLength = MetadataParser.attr(element, "MaxLength");
        if (maxLength != null) {
            term.setMaxLength(Integer.valueOf(Integer.parseInt(maxLength)));
        }
        if ((precision = MetadataParser.attr(element, "Precision")) != null) {
            term.setPrecision(Integer.valueOf(Integer.parseInt(precision)));
        }
        if ((scale = MetadataParser.attr(element, "Scale")) != null) {
            term.setScale(Integer.valueOf(Integer.parseInt(scale)));
        }
        if ((srid = MetadataParser.attr(element, "SRID")) != null) {
            term.setSrid(SRID.valueOf((String)srid));
        }
        this.peekAnnotations(reader, "Term", (CsdlAnnotatable)term);
        return term;
    }

    private void readAnnotationGroup(XMLEventReader reader, StartElement element, CsdlSchema schema) throws XMLStreamException {
        CsdlAnnotations annotations = new CsdlAnnotations();
        annotations.setTarget(MetadataParser.attr(element, "Target"));
        annotations.setQualifier(MetadataParser.attr(element, "Qualifier"));
        this.peekAnnotations(reader, element.getName().getLocalPart(), (CsdlAnnotatable)annotations);
        schema.getAnnotationGroups().add(annotations);
    }

    private void peekAnnotations(XMLEventReader reader, String endName, CsdlAnnotatable edmObject) throws XMLStreamException {
        if (!this.parseAnnotations) {
            return;
        }
        while (reader.hasNext()) {
            XMLEvent element;
            XMLEvent event = reader.peek();
            if (!event.isStartElement() && !event.isEndElement()) {
                reader.nextEvent();
                continue;
            }
            if (event.isStartElement() && "Annotation".equals((element = event.asStartElement()).getName().getLocalPart())) {
                reader.nextEvent();
                this.readAnnotations(reader, (StartElement)element, edmObject);
            }
            if (!event.isEndElement()) continue;
            element = event.asEndElement();
            if ("Annotation".equals(element.getName().getLocalPart())) {
                reader.nextEvent();
            }
            if (!element.getName().getLocalPart().equals(endName)) continue;
            return;
        }
    }

    private void readAnnotations(XMLEventReader reader, StartElement element, CsdlAnnotatable edmObject) throws XMLStreamException {
        if (!this.parseAnnotations) {
            return;
        }
        CsdlAnnotation annotation = new CsdlAnnotation();
        annotation.setTerm(MetadataParser.attr(element, "Term"));
        for (CsdlConstantExpression.ConstantExpressionType type : CsdlConstantExpression.ConstantExpressionType.values()) {
            if (MetadataParser.attr(element, type.name()) == null) continue;
            annotation.setExpression((CsdlExpression)new CsdlConstantExpression(type, MetadataParser.attr(element, type.name())));
        }
        this.readExpressions(reader, element, annotation);
        edmObject.getAnnotations().add(annotation);
    }

    private <T> void write(T t, CsdlExpression expr) throws XMLStreamException {
        if (t instanceof CsdlAnnotation) {
            ((CsdlAnnotation)t).setExpression(expr);
        } else if (t instanceof CsdlUrlRef) {
            ((CsdlUrlRef)t).setValue(expr);
        } else if (t instanceof CsdlCast) {
            ((CsdlCast)t).setValue(expr);
        } else if (t instanceof CsdlLabeledElement) {
            ((CsdlLabeledElement)t).setValue(expr);
        } else if (t instanceof CsdlIsOf) {
            ((CsdlIsOf)t).setValue(expr);
        } else if (t instanceof CsdlCollection) {
            ((CsdlCollection)t).getItems().add(((CsdlCollection)t).getItems().size(), expr);
        } else if (t instanceof CsdlApply) {
            ((CsdlApply)t).getParameters().add(expr);
        } else if (t instanceof CsdlIf) {
            if (((CsdlIf)t).getGuard() == null) {
                ((CsdlIf)t).setGuard(expr);
            } else if (((CsdlIf)t).getThen() == null) {
                ((CsdlIf)t).setThen(expr);
            } else {
                ((CsdlIf)t).setElse(expr);
            }
        } else if (t instanceof CsdlPropertyValue) {
            ((CsdlPropertyValue)t).setValue(expr);
        } else {
            throw new XMLStreamException("Unknown expression parent in Annoatation");
        }
    }

    private <T> void readExpressions(XMLEventReader reader, StartElement element, T target) throws XMLStreamException {
        new ElementReader<T>(){

            @Override
            void build(XMLEventReader reader, StartElement element, T target, String name) throws XMLStreamException {
                CsdlCollection expr;
                if (!"Annotation".equals(name)) {
                    MetadataParser.this.readAttributeExpressions(element, target);
                    for (CsdlConstantExpression.ConstantExpressionType type : CsdlConstantExpression.ConstantExpressionType.values()) {
                        if (!name.equals(type.name()) || !reader.peek().isCharacters()) continue;
                        CsdlConstantExpression expr2 = new CsdlConstantExpression(type, MetadataParser.this.elementValue(reader, element));
                        MetadataParser.this.write(target, (CsdlExpression)expr2);
                    }
                }
                if ("Collection".equals(name)) {
                    expr = new CsdlCollection();
                    MetadataParser.this.readExpressions(reader, element, expr);
                    MetadataParser.this.write(target, (CsdlExpression)expr);
                } else if ("AnnotationPath".equals(name)) {
                    MetadataParser.this.write(target, (CsdlExpression)new CsdlAnnotationPath().setValue(MetadataParser.this.elementValue(reader, element)));
                } else if ("NavigationPropertyPath".equals(name)) {
                    MetadataParser.this.write(target, (CsdlExpression)new CsdlNavigationPropertyPath().setValue(MetadataParser.this.elementValue(reader, element)));
                } else if ("Path".equals(name)) {
                    MetadataParser.this.write(target, (CsdlExpression)new CsdlPath().setValue(MetadataParser.this.elementValue(reader, element)));
                } else if ("PropertyPath".equals(name)) {
                    MetadataParser.this.write(target, (CsdlExpression)new CsdlPropertyPath().setValue(MetadataParser.this.elementValue(reader, element)));
                } else if ("UrlRef".equals(name)) {
                    expr = new CsdlUrlRef();
                    MetadataParser.this.readExpressions(reader, element, expr);
                    MetadataParser.this.write(target, (CsdlExpression)expr);
                } else if ("Apply".equals(name)) {
                    expr = new CsdlApply();
                    expr.setFunction(MetadataParser.attr(element, "Function"));
                    MetadataParser.this.readExpressions(reader, element, expr);
                    MetadataParser.this.write(target, (CsdlExpression)expr);
                } else if ("Cast".equals(name)) {
                    expr = new CsdlCast();
                    expr.setType(MetadataParser.attr(element, "Type"));
                    MetadataParser.this.readExpressions(reader, element, expr);
                    MetadataParser.this.write(target, (CsdlExpression)expr);
                } else if ("If".equals(name)) {
                    expr = new CsdlIf();
                    MetadataParser.this.readExpressions(reader, element, expr);
                    MetadataParser.this.write(target, (CsdlExpression)expr);
                } else if ("IsOf".equals(name)) {
                    expr = new CsdlIsOf();
                    expr.setType(MetadataParser.attr(element, "Type"));
                    MetadataParser.this.readExpressions(reader, element, expr);
                    MetadataParser.this.write(target, (CsdlExpression)expr);
                } else if ("LabeledElement".equals(name)) {
                    expr = new CsdlLabeledElement();
                    expr.setName(MetadataParser.attr(element, "Name"));
                    MetadataParser.this.readExpressions(reader, element, expr);
                    MetadataParser.this.write(target, (CsdlExpression)expr);
                } else if ("LabeledElementReference".equals(name)) {
                    expr = new CsdlLabeledElementReference();
                    expr.setValue(MetadataParser.this.elementValue(reader, element));
                    MetadataParser.this.write(target, (CsdlExpression)expr);
                } else if ("Null".equals(name)) {
                    MetadataParser.this.write(target, (CsdlExpression)new CsdlNull());
                } else if ("Record".equals(name)) {
                    expr = new CsdlRecord();
                    expr.setType(MetadataParser.attr(element, "Type"));
                    MetadataParser.this.readPropertyValues(reader, element, (CsdlRecord)expr);
                    MetadataParser.this.write(target, (CsdlExpression)expr);
                } else if ("Annotation".equals(name)) {
                    MetadataParser.this.readAnnotations(reader, element, (CsdlAnnotatable)target);
                }
            }
        }.read(reader, element, target, "Collection", "AnnotationPath", "NavigationPropertyPath", "Path", "PropertyPath", "UrlRef", "Apply", "Function", "Cast", "If", "IsOf", "LabeledElement", "LabeledElementReference", "Null", "Record", "Binary", "Bool", "Date", "DateTimeOffset", "Decimal", "Duration", "EnumMember", "Float", "Guid", "Int", "String", "TimeOfDay", "Annotation");
    }

    private <T> void readAttributeExpressions(StartElement element, T target) throws XMLStreamException {
        for (CsdlConstantExpression.ConstantExpressionType type : CsdlConstantExpression.ConstantExpressionType.values()) {
            if (MetadataParser.attr(element, type.name()) == null) continue;
            this.write(target, (CsdlExpression)new CsdlConstantExpression(type, MetadataParser.attr(element, type.name())));
        }
        if (MetadataParser.attr(element, "AnnotationPath") != null) {
            this.write(target, (CsdlExpression)new CsdlAnnotationPath().setValue(MetadataParser.attr(element, "AnnotationPath")));
        }
        if (MetadataParser.attr(element, "NavigationPropertyPath") != null) {
            this.write(target, (CsdlExpression)new CsdlNavigationPropertyPath().setValue(MetadataParser.attr(element, "NavigationPropertyPath")));
        }
        if (MetadataParser.attr(element, "Path") != null) {
            this.write(target, (CsdlExpression)new CsdlPath().setValue(MetadataParser.attr(element, "Path")));
        }
        if (MetadataParser.attr(element, "PropertyPath") != null) {
            this.write(target, (CsdlExpression)new CsdlPropertyPath().setValue(MetadataParser.attr(element, "PropertyPath")));
        }
        if (MetadataParser.attr(element, "UrlRef") != null) {
            this.write(target, (CsdlExpression)new CsdlUrlRef().setValue((CsdlExpression)new CsdlConstantExpression(CsdlConstantExpression.ConstantExpressionType.String, MetadataParser.attr(element, "UrlRef"))));
        }
    }

    private String elementValue(XMLEventReader reader, StartElement element) throws XMLStreamException {
        while (reader.hasNext()) {
            XMLEvent event = reader.peek();
            if (event.isStartElement() || event.isEndElement()) {
                return null;
            }
            if (!event.isCharacters()) continue;
            reader.nextEvent();
            String data = event.asCharacters().getData();
            if (data.trim().length() <= 0) continue;
            return data.trim();
        }
        return null;
    }

    private void readPropertyValues(XMLEventReader reader, StartElement element, CsdlRecord record) throws XMLStreamException {
        new ElementReader<CsdlRecord>(){

            @Override
            void build(XMLEventReader reader, StartElement element, CsdlRecord record, String name) throws XMLStreamException {
                if ("PropertyValue".equals(name)) {
                    CsdlPropertyValue value = new CsdlPropertyValue();
                    value.setProperty(MetadataParser.attr(element, "Property"));
                    MetadataParser.this.readAttributeExpressions(element, value);
                    MetadataParser.this.readExpressions(reader, element, value);
                    record.getPropertyValues().add(value);
                } else if ("Annotation".equals(name)) {
                    MetadataParser.this.readAnnotations(reader, element, (CsdlAnnotatable)record);
                }
            }
        }.read(reader, element, record, "PropertyValue", "Annotation");
    }

    private void readFunction(XMLEventReader reader, StartElement element, CsdlSchema schema) throws XMLStreamException {
        CsdlFunction function = new CsdlFunction();
        function.setParameters(new ArrayList());
        function.setName(MetadataParser.attr(element, "Name"));
        function.setBound(Boolean.parseBoolean(MetadataParser.attr(element, "IsBound")));
        function.setComposable(Boolean.parseBoolean(MetadataParser.attr(element, "IsComposable")));
        String entitySetPath = MetadataParser.attr(element, "EntitySetPath");
        if (entitySetPath != null) {
            function.setEntitySetPath(entitySetPath);
        }
        this.readOperationParameters(reader, (CsdlOperation)function);
        schema.getFunctions().add(function);
    }

    private void readOperationParameters(XMLEventReader reader, CsdlOperation operation) throws XMLStreamException {
        new ElementReader<CsdlOperation>(){

            @Override
            void build(XMLEventReader reader, StartElement element, CsdlOperation operation, String name) throws XMLStreamException {
                if ("Parameter".equals(name)) {
                    MetadataParser.this.readParameter(reader, element, operation);
                } else if ("ReturnType".equals(name)) {
                    MetadataParser.this.readReturnType(reader, element, operation);
                } else if ("Annotation".equals(name)) {
                    MetadataParser.this.readAnnotations(reader, element, (CsdlAnnotatable)operation);
                }
            }
        }.read(reader, null, operation, "Parameter", "ReturnType", "Annotation");
    }

    private void readEnumType(XMLEventReader reader, StartElement element, CsdlSchema schema) throws XMLStreamException {
        CsdlEnumType type = new CsdlEnumType();
        type.setMembers(new ArrayList());
        type.setName(MetadataParser.attr(element, "Name"));
        if (MetadataParser.attr(element, "UnderlyingType") != null) {
            type.setUnderlyingType(new FullQualifiedName(MetadataParser.attr(element, "UnderlyingType")));
        }
        type.setFlags(Boolean.parseBoolean(MetadataParser.attr(element, "IsFlags")));
        this.readEnumMembers(reader, element, type);
        schema.getEnumTypes().add(type);
    }

    private void readEnumMembers(XMLEventReader reader, StartElement element, CsdlEnumType type) throws XMLStreamException {
        new ElementReader<CsdlEnumType>(){

            @Override
            void build(XMLEventReader reader, StartElement element, CsdlEnumType type, String name) throws XMLStreamException {
                if ("Member".equals(name)) {
                    CsdlEnumMember member = new CsdlEnumMember();
                    member.setName(MetadataParser.attr(element, "Name"));
                    member.setValue(MetadataParser.attr(element, "Value"));
                    MetadataParser.this.peekAnnotations(reader, name, (CsdlAnnotatable)member);
                    type.getMembers().add(member);
                } else if ("Annotation".equals(name)) {
                    MetadataParser.this.readAnnotations(reader, element, (CsdlAnnotatable)type);
                }
            }
        }.read(reader, element, type, "Member", "Annotation");
    }

    private void readEntityType(XMLEventReader reader, StartElement element, CsdlSchema schema) throws XMLStreamException {
        CsdlEntityType entityType = new CsdlEntityType();
        entityType.setProperties(new ArrayList());
        entityType.setNavigationProperties(new ArrayList());
        entityType.setKey(new ArrayList());
        entityType.setName(MetadataParser.attr(element, "Name"));
        if (MetadataParser.attr(element, "BaseType") != null) {
            entityType.setBaseType(new FullQualifiedName(MetadataParser.attr(element, "BaseType")));
        }
        entityType.setAbstract(Boolean.parseBoolean(MetadataParser.attr(element, "Abstract")));
        entityType.setOpenType(Boolean.parseBoolean(MetadataParser.attr(element, "OpenType")));
        entityType.setHasStream(Boolean.parseBoolean(MetadataParser.attr(element, "HasStream")));
        this.readEntityProperties(reader, entityType);
        schema.getEntityTypes().add(entityType);
    }

    private void readEntityProperties(XMLEventReader reader, CsdlEntityType entityType) throws XMLStreamException {
        new ElementReader<CsdlEntityType>(){

            @Override
            void build(XMLEventReader reader, StartElement element, CsdlEntityType entityType, String name) throws XMLStreamException {
                if ("Property".equals(name)) {
                    entityType.getProperties().add(MetadataParser.this.readProperty(reader, element));
                } else if ("NavigationProperty".equals(name)) {
                    entityType.getNavigationProperties().add(MetadataParser.this.readNavigationProperty(reader, element));
                } else if ("Key".equals(name)) {
                    MetadataParser.this.readKey(reader, element, entityType);
                } else if ("Annotation".equals(name)) {
                    MetadataParser.this.readAnnotations(reader, element, (CsdlAnnotatable)entityType);
                }
            }
        }.read(reader, null, entityType, "Property", "NavigationProperty", "Key", "Annotation");
    }

    private void readKey(XMLEventReader reader, StartElement element, CsdlEntityType entityType) throws XMLStreamException {
        new ElementReader<CsdlEntityType>(){

            @Override
            void build(XMLEventReader reader, StartElement element, CsdlEntityType entityType, String name) throws XMLStreamException {
                CsdlPropertyRef ref = new CsdlPropertyRef();
                ref.setName(MetadataParser.attr(element, "Name"));
                ref.setAlias(MetadataParser.attr(element, "Alias"));
                entityType.getKey().add(ref);
            }
        }.read(reader, element, entityType, "PropertyRef");
    }

    private CsdlNavigationProperty readNavigationProperty(XMLEventReader reader, StartElement element) throws XMLStreamException {
        CsdlNavigationProperty property = new CsdlNavigationProperty();
        property.setReferentialConstraints(new ArrayList());
        property.setName(MetadataParser.attr(element, "Name"));
        property.setType(this.readType(element));
        property.setCollection(this.isCollectionType(element));
        property.setNullable(Boolean.valueOf(Boolean.parseBoolean(MetadataParser.attr(element, "Nullable") == null ? "true" : MetadataParser.attr(element, "Nullable"))));
        property.setPartner(MetadataParser.attr(element, "Partner"));
        property.setContainsTarget(Boolean.parseBoolean(MetadataParser.attr(element, "ContainsTarget")));
        new ElementReader<CsdlNavigationProperty>(){

            @Override
            void build(XMLEventReader reader, StartElement element, CsdlNavigationProperty property, String name) throws XMLStreamException {
                if ("ReferentialConstraint".equals(name)) {
                    CsdlReferentialConstraint constraint = new CsdlReferentialConstraint();
                    constraint.setProperty(MetadataParser.attr(element, "Property"));
                    constraint.setReferencedProperty(MetadataParser.attr(element, "ReferencedProperty"));
                    MetadataParser.this.peekAnnotations(reader, name, (CsdlAnnotatable)constraint);
                    property.getReferentialConstraints().add(constraint);
                } else if ("OnDelete".equals(name)) {
                    CsdlOnDelete delete = new CsdlOnDelete();
                    delete.setAction(CsdlOnDeleteAction.valueOf((String)MetadataParser.attr(element, "Action")));
                    property.setOnDelete(delete);
                    MetadataParser.this.peekAnnotations(reader, name, (CsdlAnnotatable)delete);
                } else if ("Annotation".equals(name)) {
                    MetadataParser.this.readAnnotations(reader, element, (CsdlAnnotatable)property);
                }
            }
        }.read(reader, element, property, "ReferentialConstraint", "OnDelete", "Annotation");
        return property;
    }

    private static String attr(StartElement element, String name) {
        Attribute attr = element.getAttributeByName(new QName(name));
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    private static String attrNS(StartElement element, String ns, String name) {
        Attribute attr = element.getAttributeByName(new QName(ns, name));
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    private CsdlProperty readProperty(XMLEventReader reader, StartElement element) throws XMLStreamException {
        String defaultValue;
        String srid;
        String scale;
        String precision;
        String maxLength;
        CsdlProperty property = new CsdlProperty();
        property.setName(MetadataParser.attr(element, "Name"));
        property.setType(this.readType(element));
        property.setCollection(this.isCollectionType(element));
        property.setNullable(Boolean.parseBoolean(MetadataParser.attr(element, "Nullable") == null ? "true" : MetadataParser.attr(element, "Nullable")));
        if (MetadataParser.attr(element, "Unicode") != null) {
            property.setUnicode(Boolean.parseBoolean(MetadataParser.attr(element, "Unicode")));
        }
        if ((maxLength = MetadataParser.attr(element, "MaxLength")) != null) {
            property.setMaxLength(Integer.valueOf(Integer.parseInt(maxLength)));
        }
        if ((precision = MetadataParser.attr(element, "Precision")) != null) {
            property.setPrecision(Integer.valueOf(Integer.parseInt(precision)));
        }
        if ((scale = MetadataParser.attr(element, "Scale")) != null) {
            property.setScale(Integer.valueOf(Integer.parseInt(scale)));
        }
        if ((srid = MetadataParser.attr(element, "SRID")) != null) {
            property.setSrid(SRID.valueOf((String)srid));
        }
        if ((defaultValue = MetadataParser.attr(element, "DefaultValue")) != null) {
            property.setDefaultValue(defaultValue);
        }
        this.peekAnnotations(reader, element.getName().getLocalPart(), (CsdlAnnotatable)property);
        return property;
    }

    private void readEntityContainer(XMLEventReader reader, StartElement element, CsdlSchema schema) throws XMLStreamException {
        final CsdlEntityContainer container = new CsdlEntityContainer();
        container.setName(MetadataParser.attr(element, "Name"));
        if (MetadataParser.attr(element, "Extends") != null) {
            container.setExtendsContainer(MetadataParser.attr(element, "Extends"));
        }
        container.setActionImports(new ArrayList());
        container.setFunctionImports(new ArrayList());
        container.setEntitySets(new ArrayList());
        container.setSingletons(new ArrayList());
        new ElementReader<CsdlSchema>(){

            @Override
            void build(XMLEventReader reader, StartElement element, CsdlSchema schema, String name) throws XMLStreamException {
                if ("EntitySet".equals(name)) {
                    this.readEntitySet(reader, element, container);
                } else if ("Singleton".equals(name)) {
                    this.readSingleton(reader, element, container);
                } else if ("ActionImport".equals(name)) {
                    this.readActionImport(reader, element, container);
                } else if ("FunctionImport".equals(name)) {
                    this.readFunctionImport(reader, element, container);
                } else if ("Annotation".equals(name)) {
                    MetadataParser.this.readAnnotations(reader, element, (CsdlAnnotatable)container);
                }
            }

            private void readFunctionImport(XMLEventReader reader, StartElement element, CsdlEntityContainer container2) throws XMLStreamException {
                CsdlFunctionImport functionImport = new CsdlFunctionImport();
                functionImport.setName(MetadataParser.attr(element, "Name"));
                functionImport.setFunction(new FullQualifiedName(MetadataParser.attr(element, "Function")));
                functionImport.setIncludeInServiceDocument(Boolean.parseBoolean(MetadataParser.attr(element, "IncludeInServiceDocument")));
                String entitySet = MetadataParser.attr(element, "EntitySet");
                if (entitySet != null) {
                    functionImport.setEntitySet(entitySet);
                }
                MetadataParser.this.peekAnnotations(reader, "FunctionImport", (CsdlAnnotatable)functionImport);
                container2.getFunctionImports().add(functionImport);
            }

            private void readActionImport(XMLEventReader reader, StartElement element, CsdlEntityContainer container2) throws XMLStreamException {
                CsdlActionImport actionImport = new CsdlActionImport();
                actionImport.setName(MetadataParser.attr(element, "Name"));
                actionImport.setAction(new FullQualifiedName(MetadataParser.attr(element, "Action")));
                String entitySet = MetadataParser.attr(element, "EntitySet");
                if (entitySet != null) {
                    actionImport.setEntitySet(entitySet);
                }
                MetadataParser.this.peekAnnotations(reader, "ActionImport", (CsdlAnnotatable)actionImport);
                container2.getActionImports().add(actionImport);
            }

            private void readSingleton(XMLEventReader reader, StartElement element, CsdlEntityContainer container2) throws XMLStreamException {
                CsdlSingleton singleton = new CsdlSingleton();
                singleton.setNavigationPropertyBindings(new ArrayList());
                singleton.setName(MetadataParser.attr(element, "Name"));
                singleton.setType(new FullQualifiedName(MetadataParser.attr(element, "Type")));
                singleton.setNavigationPropertyBindings(new ArrayList());
                this.readNavigationPropertyBindings(reader, element, (CsdlBindingTarget)singleton);
                container2.getSingletons().add(singleton);
            }

            private void readEntitySet(XMLEventReader reader, StartElement element, CsdlEntityContainer container2) throws XMLStreamException {
                CsdlEntitySet entitySet = new CsdlEntitySet();
                entitySet.setName(MetadataParser.attr(element, "Name"));
                entitySet.setType(new FullQualifiedName(MetadataParser.attr(element, "EntityType")));
                entitySet.setIncludeInServiceDocument(Boolean.parseBoolean(MetadataParser.attr(element, "IncludeInServiceDocument")));
                entitySet.setNavigationPropertyBindings(new ArrayList());
                this.readNavigationPropertyBindings(reader, element, (CsdlBindingTarget)entitySet);
                container2.getEntitySets().add(entitySet);
            }

            private void readNavigationPropertyBindings(XMLEventReader reader, StartElement element, CsdlBindingTarget entitySet) throws XMLStreamException {
                new ElementReader<CsdlBindingTarget>(){

                    @Override
                    void build(XMLEventReader reader, StartElement element, CsdlBindingTarget entitySet, String name) throws XMLStreamException {
                        if ("NavigationPropertyBinding".equals(name)) {
                            CsdlNavigationPropertyBinding binding = new CsdlNavigationPropertyBinding();
                            binding.setPath(MetadataParser.attr(element, "Path"));
                            binding.setTarget(MetadataParser.attr(element, "Target"));
                            entitySet.getNavigationPropertyBindings().add(binding);
                        } else if ("Annotation".equals(name)) {
                            MetadataParser.this.readAnnotations(reader, element, (CsdlAnnotatable)entitySet);
                        }
                    }
                }.read(reader, element, entitySet, "NavigationPropertyBinding", "Annotation");
            }
        }.read(reader, element, schema, "EntitySet", "Singleton", "ActionImport", "FunctionImport", "Annotation");
        schema.setEntityContainer(container);
    }

    private void readComplexType(XMLEventReader reader, StartElement element, CsdlSchema schema) throws XMLStreamException {
        CsdlComplexType complexType = new CsdlComplexType();
        complexType.setProperties(new ArrayList());
        complexType.setNavigationProperties(new ArrayList());
        complexType.setName(MetadataParser.attr(element, "Name"));
        if (MetadataParser.attr(element, "BaseType") != null) {
            complexType.setBaseType(new FullQualifiedName(MetadataParser.attr(element, "BaseType")));
        }
        complexType.setAbstract(Boolean.parseBoolean(MetadataParser.attr(element, "Abstract")));
        complexType.setOpenType(Boolean.parseBoolean(MetadataParser.attr(element, "OpenType")));
        this.readProperties(reader, complexType);
        schema.getComplexTypes().add(complexType);
    }

    private void readProperties(XMLEventReader reader, CsdlComplexType complexType) throws XMLStreamException {
        new ElementReader<CsdlComplexType>(){

            @Override
            void build(XMLEventReader reader, StartElement element, CsdlComplexType complexType, String name) throws XMLStreamException {
                if ("Property".equals(name)) {
                    complexType.getProperties().add(MetadataParser.this.readProperty(reader, element));
                } else if ("NavigationProperty".equals(name)) {
                    complexType.getNavigationProperties().add(MetadataParser.this.readNavigationProperty(reader, element));
                } else if ("Annotation".equals(name)) {
                    MetadataParser.this.readAnnotations(reader, element, (CsdlAnnotatable)complexType);
                }
            }
        }.read(reader, null, complexType, "Property", "NavigationProperty", "Annotation");
    }

    private static class DefaultReferenceResolver
    implements ReferenceResolver {
        private DefaultReferenceResolver() {
        }

        @Override
        public InputStream resolveReference(URI referenceUri, String xmlBase) {
            InputStream in = null;
            try {
                if (referenceUri.isAbsolute()) {
                    URL schemaURL = referenceUri.toURL();
                    in = schemaURL.openStream();
                } else if (xmlBase != null) {
                    URL schemaURL = new URL(xmlBase + referenceUri.toString());
                    in = schemaURL.openStream();
                } else {
                    in = this.getClass().getClassLoader().getResourceAsStream(referenceUri.getPath());
                    if (in == null) {
                        throw new EdmException("No xml:base set to read the references from the metadata");
                    }
                }
                return in;
            }
            catch (MalformedURLException e) {
                throw new EdmException((Exception)e);
            }
            catch (IOException e) {
                throw new EdmException((Exception)e);
            }
        }
    }

    abstract class ElementReader<T> {
        ElementReader() {
        }

        void read(XMLEventReader reader, StartElement parentElement, T t, String ... names) throws XMLStreamException {
            while (reader.hasNext()) {
                XMLEvent eventBefore;
                XMLEvent event = reader.peek();
                if (!MetadataParser.this.parseAnnotations && (eventBefore = event) != (event = this.skipAnnotations(reader, event))) continue;
                if (!event.isStartElement() && !event.isEndElement()) {
                    reader.nextEvent();
                    continue;
                }
                if (parentElement != null && event.isEndElement() && ((EndElement)event).getName().equals(parentElement.getName())) break;
                boolean hit = false;
                for (String name : names) {
                    EndElement e;
                    StartElement element;
                    if (event.isStartElement() && (element = event.asStartElement()).getName().getLocalPart().equals(name)) {
                        reader.nextEvent();
                        this.build(reader, element, t, name);
                        hit = true;
                        break;
                    }
                    if (!event.isEndElement() || !(e = event.asEndElement()).getName().getLocalPart().equals(name)) continue;
                    reader.nextEvent();
                    hit = true;
                    break;
                }
                if (hit) continue;
                break;
            }
        }

        private XMLEvent skipAnnotations(XMLEventReader reader, XMLEvent event) throws XMLStreamException {
            boolean skip = false;
            while (reader.hasNext()) {
                XMLEvent element;
                if (event.isStartElement() && "Annotation".equals((element = event.asStartElement()).getName().getLocalPart())) {
                    skip = true;
                }
                if (event.isEndElement() && "Annotation".equals((element = event.asEndElement()).getName().getLocalPart())) {
                    return reader.peek();
                }
                if (skip) {
                    event = reader.nextEvent();
                    continue;
                }
                return event;
            }
            return event;
        }

        abstract void build(XMLEventReader var1, StartElement var2, T var3, String var4) throws XMLStreamException;
    }
}

